/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.server;

import com.auth0.jwt.JWT;
import com.auth0.jwt.algorithms.Algorithm;
import com.auth0.jwt.exceptions.JWTDecodeException;
import com.auth0.jwt.interfaces.Claim;
import com.auth0.jwt.interfaces.DecodedJWT;
import java.util.Objects;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.languagetool.server.AuthException;
import org.languagetool.server.DatabaseAccess;
import org.languagetool.server.HTTPServerConfig;
import org.languagetool.server.LimitEnforcementMode;
import org.languagetool.server.UserInfoEntry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class UserLimits {
    private static final Logger logger = LoggerFactory.getLogger(UserLimits.class);
    @Nullable
    private final UserInfoEntry account;
    private final int maxTextLength;
    private final long maxCheckTimeMillis;
    private final boolean hasPremium;
    private final Long dictionaryCacheSize;
    private final Long premiumUid;
    private boolean skipLimits;
    private final Long requestsPerDay;
    private final LimitEnforcementMode limitEnforcementMode;

    static UserLimits getDefaultLimits(HTTPServerConfig config) {
        if (config.premiumAlways) {
            return new UserLimits(config.getMaxTextLengthPremium(), config.getMaxCheckTimeMillisAnonymous(), 1L, true);
        }
        return new UserLimits(config.getMaxTextLengthAnonymous(), config.getMaxCheckTimeMillisAnonymous(), null, false);
    }

    static UserLimits getLimitsFromUserAccount(HTTPServerConfig config, @NotNull String username, @NotNull String password) {
        UserInfoEntry entry = DatabaseAccess.getInstance().getUserInfoWithPassword(username, password);
        if (entry == null) {
            return UserLimits.getDefaultLimits(config);
        }
        if (entry.hasPremium()) {
            logger.info("Access via username/password for " + username);
            return new UserLimits(config.getMaxTextLengthPremium(), config.getMaxCheckTimeMillisPremium(), entry.getUserId(), true, entry.getUserDictCacheSize(), entry.getRequestsPerDay(), entry.getLimitEnforcement(), entry);
        }
        logger.info("Non-premium access via username/password for " + username);
        return new UserLimits(config.getMaxTextLengthLoggedIn(), config.getMaxCheckTimeMillisLoggedIn(), entry.getUserId(), false, entry.getUserDictCacheSize(), entry.getRequestsPerDay(), entry.getLimitEnforcement(), entry);
    }

    static UserLimits getLimitsFromToken(HTTPServerConfig config, String jwtToken) {
        DecodedJWT decodedToken;
        Objects.requireNonNull(jwtToken);
        String secretKey = config.getSecretTokenKey();
        if (secretKey == null) {
            throw new RuntimeException("You specified a 'token' parameter but this server is not configured to accept tokens");
        }
        Algorithm algorithm = Algorithm.HMAC256(secretKey);
        try {
            JWT.require(algorithm).build().verify(jwtToken);
            decodedToken = JWT.decode(jwtToken);
        }
        catch (JWTDecodeException e) {
            throw new AuthException("Could not decode token '" + jwtToken + "'", e);
        }
        Claim maxTextLengthClaim = decodedToken.getClaim("maxTextLength");
        Claim premiumClaim = decodedToken.getClaim("premium");
        boolean hasPremium = !premiumClaim.isNull() && premiumClaim.asBoolean() != false;
        Claim uidClaim = decodedToken.getClaim("uid");
        Claim dictCacheSizeClaim = decodedToken.getClaim("dictCacheSize");
        Long dictCacheSize = dictCacheSizeClaim.asLong();
        Claim requestsPerDayClaim = decodedToken.getClaim("requestsPerDay");
        Long requestsPerDay = requestsPerDayClaim.asLong();
        Claim limitEnforcementClaim = decodedToken.getClaim("limitEnforcement");
        LimitEnforcementMode limitEnforcementMode = LimitEnforcementMode.parse(limitEnforcementClaim.asInt());
        int maxTextLength = maxTextLengthClaim.isNull() ? (hasPremium ? config.getMaxTextLengthPremium() : config.getMaxTextLengthLoggedIn()) : maxTextLengthClaim.asInt();
        long maxCheckTime = hasPremium ? config.getMaxCheckTimeMillisPremium() : config.getMaxCheckTimeMillisLoggedIn();
        UserLimits userLimits = new UserLimits(maxTextLength, maxCheckTime, uidClaim.asLong(), hasPremium, dictCacheSize == null || dictCacheSize <= 0L ? null : dictCacheSize, requestsPerDay, limitEnforcementMode);
        userLimits.skipLimits = decodedToken.getClaim("skipLimits").isNull() ? false : decodedToken.getClaim("skipLimits").asBoolean();
        return userLimits;
    }

    public static UserLimits getLimitsByApiKey(HTTPServerConfig config, String username, String apiKey) {
        DatabaseAccess db = DatabaseAccess.getInstance();
        UserInfoEntry data = db.getUserInfoWithApiKey(username, apiKey);
        if (data == null) {
            return UserLimits.getDefaultLimits(config);
        }
        if (data.hasPremium()) {
            return new UserLimits(config.getMaxTextLengthPremium(), config.getMaxCheckTimeMillisPremium(), data.getUserId(), true, data.getUserDictCacheSize(), data.getRequestsPerDay(), data.getLimitEnforcement(), data);
        }
        return new UserLimits(config.getMaxTextLengthLoggedIn(), config.getMaxCheckTimeMillisLoggedIn(), data.getUserId(), false, data.getUserDictCacheSize(), data.getRequestsPerDay(), data.getLimitEnforcement(), data);
    }

    public static UserLimits getLimitsByAddonToken(HTTPServerConfig config, String username, String addonToken) {
        DatabaseAccess db = DatabaseAccess.getInstance();
        UserInfoEntry data = db.getUserInfoWithAddonToken(username, addonToken);
        if (data == null) {
            return UserLimits.getDefaultLimits(config);
        }
        if (data.hasPremium()) {
            return new UserLimits(config.getMaxTextLengthPremium(), config.getMaxCheckTimeMillisPremium(), data.getUserId(), true, data.getUserDictCacheSize(), data.getRequestsPerDay(), data.getLimitEnforcement(), data);
        }
        return new UserLimits(config.getMaxTextLengthLoggedIn(), config.getMaxCheckTimeMillisLoggedIn(), data.getUserId(), false, data.getUserDictCacheSize(), data.getRequestsPerDay(), data.getLimitEnforcement(), data);
    }

    private UserLimits(int maxTextLength, long maxCheckTimeMillis, Long premiumUid, boolean hasPremium) {
        this(maxTextLength, maxCheckTimeMillis, premiumUid, hasPremium, null, null, null);
    }

    private UserLimits(int maxTextLength, long maxCheckTimeMillis, Long premiumUid, boolean hasPremium, Long dictCacheSize, Long requestsPerDay, LimitEnforcementMode limitEnforcement) {
        this(maxTextLength, maxCheckTimeMillis, premiumUid, hasPremium, dictCacheSize, requestsPerDay, limitEnforcement, null);
    }

    private UserLimits(int maxTextLength, long maxCheckTimeMillis, Long premiumUid, boolean hasPremium, Long dictCacheSize, Long requestsPerDay, LimitEnforcementMode limitEnforcement, UserInfoEntry account) {
        this.maxTextLength = maxTextLength;
        this.maxCheckTimeMillis = maxCheckTimeMillis;
        this.premiumUid = premiumUid;
        this.hasPremium = hasPremium;
        this.dictionaryCacheSize = dictCacheSize;
        this.requestsPerDay = requestsPerDay;
        this.limitEnforcementMode = limitEnforcement != null ? limitEnforcement : LimitEnforcementMode.DISABLED;
        this.account = account;
    }

    UserLimits(boolean skipLimits) {
        this(0, 0L, -1L, true);
        this.skipLimits = skipLimits;
    }

    int getMaxTextLength() {
        return this.maxTextLength;
    }

    long getMaxCheckTimeMillis() {
        return this.maxCheckTimeMillis;
    }

    boolean getSkipLimits() {
        return this.skipLimits;
    }

    @Nullable
    Long getPremiumUid() {
        return this.premiumUid;
    }

    public boolean hasPremium() {
        return this.hasPremium;
    }

    public String toString() {
        return new ToStringBuilder(this).append("premiumUid", this.premiumUid).append("maxTextLength", this.maxTextLength).append("maxCheckTimeMillis", this.maxCheckTimeMillis).append("dictCacheSize", this.dictionaryCacheSize).append("requestsPerDay", this.requestsPerDay).append("limitEnforcement", (Object)this.limitEnforcementMode).build();
    }

    public Long getDictCacheSize() {
        return this.dictionaryCacheSize;
    }

    public Long getRequestsPerDay() {
        return this.requestsPerDay;
    }

    public LimitEnforcementMode getLimitEnforcementMode() {
        return this.limitEnforcementMode;
    }

    @Nullable
    UserInfoEntry getAccount() {
        return this.account;
    }

    static class Account {
        private final String username;
        private final String password;

        Account(String username, String password) {
            this.username = Objects.requireNonNull(username);
            this.password = Objects.requireNonNull(password);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Account account = (Account)o;
            return Objects.equals(this.username, account.username) && Objects.equals(this.password, account.password);
        }

        public int hashCode() {
            return Objects.hash(this.username, this.password);
        }
    }
}

