/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.server;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.sun.net.httpserver.HttpExchange;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Queue;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.languagetool.CheckResults;
import org.languagetool.DetectedLanguage;
import org.languagetool.ErrorRateTooHighException;
import org.languagetool.FragmentWithLanguage;
import org.languagetool.JLanguageTool;
import org.languagetool.Language;
import org.languagetool.LanguageAnnotator;
import org.languagetool.Languages;
import org.languagetool.Premium;
import org.languagetool.ResultCache;
import org.languagetool.RuleMatchListener;
import org.languagetool.UserConfig;
import org.languagetool.language.LanguageIdentifier;
import org.languagetool.markup.AnnotatedText;
import org.languagetool.markup.AnnotatedTextBuilder;
import org.languagetool.rules.CategoryId;
import org.languagetool.rules.DictionaryMatchFilter;
import org.languagetool.rules.RemoteRule;
import org.languagetool.rules.RuleMatch;
import org.languagetool.rules.bitext.BitextRule;
import org.languagetool.rules.spelling.morfologik.suggestions_ordering.SuggestionsOrdererConfig;
import org.languagetool.server.AuthException;
import org.languagetool.server.BadRequestException;
import org.languagetool.server.DatabaseAccess;
import org.languagetool.server.DatabaseAccessLimitLogEntry;
import org.languagetool.server.DatabaseCheckErrorLogEntry;
import org.languagetool.server.DatabaseCheckLogEntry;
import org.languagetool.server.DatabaseLogger;
import org.languagetool.server.DatabasePingLogEntry;
import org.languagetool.server.DatabaseRuleMatchLogEntry;
import org.languagetool.server.ErrorRequestLimiter;
import org.languagetool.server.HTTPServerConfig;
import org.languagetool.server.Pipeline;
import org.languagetool.server.PipelinePool;
import org.languagetool.server.RemoteRuleMatch;
import org.languagetool.server.RequestCounter;
import org.languagetool.server.RequestLimiter;
import org.languagetool.server.ResultExtender;
import org.languagetool.server.ServerMetricsCollector;
import org.languagetool.server.ServerTools;
import org.languagetool.server.TextTooLongException;
import org.languagetool.server.TooManyRequestsException;
import org.languagetool.server.UserLimits;
import org.languagetool.tools.Tools;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class TextChecker {
    private static final int PINGS_CLEAN_MILLIS = 60000;
    private static final int PINGS_MAX_SIZE = 5000;
    private static final int NGRAM_THRESHOLD = 50;
    protected static final int CONTEXT_SIZE = 40;
    protected static final int NUM_PIPELINES_PER_SETTING = 3;
    protected final HTTPServerConfig config;
    private static final Logger logger = LoggerFactory.getLogger(TextChecker.class);
    private static final String ENCODING = "UTF-8";
    private static final int CACHE_STATS_PRINT = 500;
    private final Map<String, Integer> languageCheckCounts = new HashMap<String, Integer>();
    private final Queue<Runnable> workQueue;
    private final RequestCounter reqCounter;
    private long lastHiddenMatchesServerTimeout;
    private long hiddenMatchesServerFailures = 0L;
    private final LanguageIdentifier fastTextIdentifier;
    private final ExecutorService executorService;
    private final ResultCache cache;
    private final DatabaseLogger databaseLogger;
    private final Long logServerId;
    private final Random random = new Random();
    private final Set<DatabasePingLogEntry> pings = new HashSet<DatabasePingLogEntry>();
    private long pingsCleanDateMillis = System.currentTimeMillis();
    private LanguageIdentifier ngramIdentifier = null;
    PipelinePool pipelinePool;

    protected abstract void setHeaders(HttpExchange var1);

    protected abstract String getResponse(AnnotatedText var1, Language var2, DetectedLanguage var3, Language var4, List<CheckResults> var5, List<RuleMatch> var6, String var7, int var8, boolean var9);

    @NotNull
    protected abstract List<String> getPreferredVariants(Map<String, String> var1);

    protected abstract DetectedLanguage getLanguage(String var1, Map<String, String> var2, List<String> var3, List<String> var4, List<String> var5, boolean var6);

    protected abstract boolean getLanguageAutoDetect(Map<String, String> var1);

    @NotNull
    protected abstract List<String> getEnabledRuleIds(Map<String, String> var1);

    @NotNull
    protected abstract List<String> getDisabledRuleIds(Map<String, String> var1);

    TextChecker(HTTPServerConfig config, boolean internalServer, Queue<Runnable> workQueue, RequestCounter reqCounter) {
        this.config = config;
        this.workQueue = workQueue;
        this.reqCounter = reqCounter;
        this.fastTextIdentifier = new LanguageIdentifier();
        this.fastTextIdentifier.enableFasttext(config.getFasttextBinary(), config.getFasttextModel());
        if (config.getNgramLangIdentData() != null) {
            this.ngramIdentifier = new LanguageIdentifier();
            this.ngramIdentifier.enableNgrams(config.getNgramLangIdentData());
        }
        this.executorService = Executors.newCachedThreadPool(new ThreadFactoryBuilder().setNameFormat("lt-textchecker-thread-%d").build());
        this.cache = config.getCacheSize() > 0 ? new ResultCache(config.getCacheSize(), config.getCacheTTLSeconds(), TimeUnit.SECONDS) : null;
        this.databaseLogger = DatabaseLogger.getInstance();
        this.logServerId = this.databaseLogger.isLogging() ? DatabaseAccess.getInstance().getOrCreateServerId() : null;
        ServerMetricsCollector.getInstance().logHiddenServerConfiguration(config.getHiddenMatchesServer() != null);
        if (this.cache != null) {
            ServerMetricsCollector.getInstance().monitorCache("languagetool_matches_cache", this.cache.getMatchesCache());
            ServerMetricsCollector.getInstance().monitorCache("languagetool_remote_matches_cache", this.cache.getRemoteMatchesCache());
            ServerMetricsCollector.getInstance().monitorCache("languagetool_sentences_cache", this.cache.getSentenceCache());
            ServerMetricsCollector.getInstance().monitorCache("languagetool_remote_matches_cache", this.cache.getRemoteMatchesCache());
        }
        this.pipelinePool = new PipelinePool(config, this.cache, internalServer);
        if (config.isPipelinePrewarmingEnabled()) {
            logger.info("Prewarming pipelines...");
            this.prewarmPipelinePool();
            logger.info("Prewarming finished.");
        }
        if (config.getAbTest() != null) {
            UserConfig.enableABTests();
            logger.info("A/B-Test enabled: " + config.getAbTest());
            if (config.getAbTest().equals("SuggestionsOrderer")) {
                SuggestionsOrdererConfig.setMLSuggestionsOrderingEnabled(true);
            }
        }
    }

    protected static Language parseLanguage(String code) throws BadRequestException {
        try {
            return Languages.getLanguageForShortCode(code);
        }
        catch (IllegalArgumentException e) {
            throw new BadRequestException(e.getMessage());
        }
    }

    private void prewarmPipelinePool() {
        HashMap<PipelinePool.PipelineSettings, Integer> prewarmSettings = new HashMap<PipelinePool.PipelineSettings, Integer>();
        List prewarmLanguages = Stream.of("de-DE", "en-US", "en-GB", "pt-BR", "ru-RU", "es", "it", "fr", "pl-PL", "uk-UA").map(Languages::getLanguageForShortCode).collect(Collectors.toList());
        List<String> addonDisabledRules = Collections.singletonList("WHITESPACE_RULE");
        List<JLanguageTool.Mode> addonModes = Arrays.asList(JLanguageTool.Mode.TEXTLEVEL_ONLY, JLanguageTool.Mode.ALL_BUT_TEXTLEVEL_ONLY);
        UserConfig user = new UserConfig();
        for (Language language : prewarmLanguages) {
            for (JLanguageTool.Mode mode : addonModes) {
                QueryParams params = new QueryParams(Collections.emptyList(), Collections.emptyList(), addonDisabledRules, Collections.emptyList(), Collections.emptyList(), false, true, true, true, Premium.isPremiumVersion(), false, mode, JLanguageTool.Level.PICKY, null);
                PipelinePool.PipelineSettings settings = new PipelinePool.PipelineSettings(language, null, params, this.config.globalConfig, user);
                prewarmSettings.put(settings, 3);
                PipelinePool.PipelineSettings settingsMotherTongueEqual = new PipelinePool.PipelineSettings(language, language, params, this.config.globalConfig, user);
                PipelinePool.PipelineSettings settingsMotherTongueEnglish = new PipelinePool.PipelineSettings(language, Languages.getLanguageForName("English"), params, this.config.globalConfig, user);
                prewarmSettings.put(settingsMotherTongueEqual, 3);
                prewarmSettings.put(settingsMotherTongueEnglish, 3);
            }
        }
        try {
            for (Map.Entry entry : prewarmSettings.entrySet()) {
                int numPipelines = (Integer)entry.getValue();
                PipelinePool.PipelineSettings setting = (PipelinePool.PipelineSettings)entry.getKey();
                ArrayList<Pipeline> pipelines = new ArrayList<Pipeline>();
                for (int i = 0; i < numPipelines; ++i) {
                    Pipeline p = this.pipelinePool.getPipeline(setting);
                    p.check("LanguageTool");
                    pipelines.add(p);
                }
                for (Pipeline p : pipelines) {
                    this.pipelinePool.returnPipeline(setting, p);
                }
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Error while prewarming pipelines", e);
        }
    }

    void shutdownNow() {
        this.executorService.shutdownNow();
        RemoteRule.shutdown();
    }

    void checkText(final AnnotatedText aText, HttpExchange httpExchange, final Map<String, String> parameters, ErrorRequestLimiter errorRequestLimiter, String remoteAddress) throws Exception {
        List<CheckResults> res;
        this.checkParams(parameters);
        long timeStart = System.currentTimeMillis();
        UserLimits limits = ServerTools.getUserLimits(parameters, this.config);
        String requestId = httpExchange.getRequestHeaders().getFirst("X-Request-ID");
        String agent = parameters.get("useragent") != null ? parameters.get("useragent") : "-";
        Long agentId = null;
        Long userId = null;
        if (this.databaseLogger.isLogging()) {
            DatabaseAccess db = DatabaseAccess.getInstance();
            agentId = db.getOrCreateClientId(parameters.get("useragent"));
            userId = limits.getPremiumUid();
        }
        String referrer = httpExchange.getRequestHeaders().getFirst("Referer");
        String userAgent = httpExchange.getRequestHeaders().getFirst("User-Agent");
        if (!this.config.isAnonymousAccessAllowed() && limits.getPremiumUid() == null) {
            this.databaseLogger.log(new DatabaseAccessLimitLogEntry("AnonymousAccessOnRestrictedServer", this.logServerId, agentId, userId, "", referrer, userAgent));
            throw new AuthException("Anonymous access is prohibited on this server, please provide authentication.");
        }
        if (aText.getPlainText().length() > limits.getMaxTextLength()) {
            String msg = "limit: " + limits.getMaxTextLength() + ", size: " + aText.getPlainText().length();
            this.databaseLogger.log(new DatabaseAccessLimitLogEntry("MaxCharacterSizeExceeded", this.logServerId, agentId, userId, msg, referrer, userAgent));
            ServerMetricsCollector.getInstance().logRequestError(ServerMetricsCollector.RequestErrorType.MAX_TEXT_SIZE);
            throw new TextTooLongException("Your text exceeds the limit of " + limits.getMaxTextLength() + " characters (it's " + aText.getPlainText().length() + " characters). Please submit a shorter text.");
        }
        try {
            RequestLimiter.checkUserLimit(referrer, userAgent, agentId, this.logServerId, limits);
        }
        catch (TooManyRequestsException e) {
            String text;
            String response = "Error: Access denied: " + e.getMessage();
            httpExchange.sendResponseHeaders(403, response.getBytes(ENCODING).length);
            httpExchange.getResponseBody().write(response.getBytes(ENCODING));
            String message = "Blocked request from uid:" + userId + " because user limit is reached: ";
            message = message + "limit = " + limits.getRequestsPerDay() + ", mode = " + (Object)((Object)limits.getLimitEnforcementMode()) + ". ";
            message = message + "Access from " + remoteAddress + ", ";
            message = message + "HTTP user agent: " + userAgent + ", ";
            message = message + "User agent param: " + parameters.get("useragent") + ", ";
            message = message + "Referrer: " + referrer + ", ";
            message = message + "language: " + parameters.get("language") + ", ";
            message = message + "h: " + this.reqCounter.getHandleCount() + ", ";
            message = message + "r: " + this.reqCounter.getRequestCount();
            if (parameters.get("username") != null) {
                message = message + ", user: " + parameters.get("username");
            }
            if (parameters.get("apiKey") != null) {
                message = message + ", apiKey: " + parameters.get("apiKey");
            }
            if ((text = parameters.get("text")) != null) {
                message = message + ", text length: " + text.length();
            }
            logger.warn(message);
            return;
        }
        List<String> dictGroups = null;
        String dictName = "default";
        if (parameters.containsKey("dicts")) {
            dictGroups = Arrays.asList(parameters.get("dicts").split(","));
            dictGroups.sort(Comparator.naturalOrder());
            dictName = "groups_" + String.join((CharSequence)",", dictGroups);
        }
        List<String> dictWords = limits.getPremiumUid() != null ? this.getUserDictWords(limits, dictGroups) : Collections.emptyList();
        boolean filterDictionaryMatches = "true".equals(parameters.get("filterDictionaryMatches"));
        Long textSessionId = null;
        try {
            if (parameters.containsKey("textSessionId")) {
                String textSessionIdStr = parameters.get("textSessionId");
                if (textSessionIdStr.startsWith("user:")) {
                    int sepPos = textSessionIdStr.indexOf(58);
                    String sessionId = textSessionIdStr.substring(sepPos + 1);
                    textSessionId = Long.valueOf(sessionId);
                } else if (textSessionIdStr.contains(":")) {
                    int sepPos = textSessionIdStr.indexOf(58);
                    long random = Long.parseLong(textSessionIdStr.substring(0, sepPos));
                    long timestamp = Long.parseLong(textSessionIdStr.substring(sepPos + 1));
                    long maxRandom = 100000L;
                    long randomSegmentSize = (Long.MAX_VALUE - maxRandom) / maxRandom;
                    long segmentOffset = random * randomSegmentSize;
                    if (timestamp > randomSegmentSize) {
                        logger.warn(String.format("Could not transform textSessionId '%s'", textSessionIdStr));
                    }
                    textSessionId = segmentOffset + timestamp;
                } else {
                    textSessionId = Long.valueOf(textSessionIdStr);
                }
            }
        }
        catch (NumberFormatException ex) {
            logger.warn("Could not parse textSessionId '" + parameters.get("textSessionId") + "' as long: " + ex.getMessage());
        }
        String abTest = null;
        if (agent != null && this.config.getAbTestClients() != null && this.config.getAbTestClients().matcher(agent).matches()) {
            boolean testRolledOut;
            if (textSessionId != null) {
                testRolledOut = textSessionId % 100L < (long)this.config.getAbTestRollout();
            } else {
                boolean bl = testRolledOut = this.random.nextInt(100) < this.config.getAbTestRollout();
            }
            if (testRolledOut) {
                abTest = this.config.getAbTest();
            }
        }
        final UserConfig userConfig = new UserConfig(dictWords, this.getRuleValues(parameters), this.config.getMaxSpellingSuggestions(), limits.getPremiumUid(), dictName, limits.getDictCacheSize(), null, filterDictionaryMatches, abTest, textSessionId);
        boolean autoDetectLanguage = this.getLanguageAutoDetect(parameters);
        final List<String> preferredVariants = this.getPreferredVariants(parameters);
        if (parameters.get("noopLanguages") != null && !autoDetectLanguage) {
            ServerMetricsCollector.getInstance().logRequestError(ServerMetricsCollector.RequestErrorType.INVALID_REQUEST);
            throw new BadRequestException("You can specify 'noopLanguages' only when also using 'language=auto'");
        }
        List<String> noopLangs = parameters.get("noopLanguages") != null ? Arrays.asList(parameters.get("noopLanguages").split(",")) : Collections.emptyList();
        final List<String> preferredLangs = parameters.get("preferredLanguages") != null ? Arrays.asList(parameters.get("preferredLanguages").split(",")) : Collections.emptyList();
        final DetectedLanguage detLang = this.getLanguage(aText.getPlainText(), parameters, preferredVariants, noopLangs, preferredLangs, parameters.getOrDefault("ld", "control").equalsIgnoreCase("test"));
        final Language lang = detLang.getGivenLanguage();
        Integer count = this.languageCheckCounts.get(lang.getShortCodeWithCountryAndVariant());
        if (count == null) {
            count = 1;
        } else {
            Integer n = count;
            Integer segmentOffset = count = Integer.valueOf(count + 1);
        }
        String motherTongueParam = parameters.get("motherTongue");
        final Language motherTongue = motherTongueParam != null ? TextChecker.parseLanguage(motherTongueParam) : null;
        boolean useEnabledOnly = "yes".equals(parameters.get("enabledOnly")) || "true".equals(parameters.get("enabledOnly"));
        ArrayList<Language> altLanguages = new ArrayList<Language>();
        if (parameters.get("altLanguages") != null) {
            String[] altLangParams;
            for (String langCode : altLangParams = parameters.get("altLanguages").split(",\\s*")) {
                Language altLang = TextChecker.parseLanguage(langCode);
                altLanguages.add(altLang);
                if (!altLang.hasVariant() || altLang.isVariant()) continue;
                ServerMetricsCollector.getInstance().logRequestError(ServerMetricsCollector.RequestErrorType.INVALID_REQUEST);
                throw new BadRequestException("You specified altLanguage '" + langCode + "', but for this language you need to specify a variant, e.g. 'en-GB' instead of just 'en'");
            }
        }
        List<String> enabledRules = this.getEnabledRuleIds(parameters);
        List<String> disabledRules = this.getDisabledRuleIds(parameters);
        List<CategoryId> enabledCategories = this.getCategoryIds("enabledCategories", parameters);
        List<CategoryId> disabledCategories = this.getCategoryIds("disabledCategories", parameters);
        if ((disabledRules.size() > 0 || disabledCategories.size() > 0) && useEnabledOnly) {
            ServerMetricsCollector.getInstance().logRequestError(ServerMetricsCollector.RequestErrorType.INVALID_REQUEST);
            throw new BadRequestException("You cannot specify disabled rules or categories using enabledOnly=true");
        }
        if (enabledRules.isEmpty() && enabledCategories.isEmpty() && useEnabledOnly) {
            ServerMetricsCollector.getInstance().logRequestError(ServerMetricsCollector.RequestErrorType.INVALID_REQUEST);
            throw new BadRequestException("You must specify enabled rules or categories when using enabledOnly=true");
        }
        boolean enableTempOffRules = "true".equals(parameters.get("enableTempOffRules"));
        boolean useQuerySettings = enabledRules.size() > 0 || disabledRules.size() > 0 || enabledCategories.size() > 0 || disabledCategories.size() > 0 || enableTempOffRules;
        boolean allowIncompleteResults = "true".equals(parameters.get("allowIncompleteResults"));
        boolean enableHiddenRules = "true".equals(parameters.get("enableHiddenRules"));
        if (limits.hasPremium()) {
            enableHiddenRules = false;
        }
        JLanguageTool.Mode mode = ServerTools.getMode(parameters);
        JLanguageTool.Level level = ServerTools.getLevel(parameters);
        String callback = parameters.get("callback");
        boolean inputLogging = !parameters.getOrDefault("inputLogging", "").equals("no");
        final QueryParams params = new QueryParams(altLanguages, enabledRules, disabledRules, enabledCategories, disabledCategories, useEnabledOnly, useQuerySettings, allowIncompleteResults, enableHiddenRules, limits.getPremiumUid() != null && limits.hasPremium(), enableTempOffRules, mode, level, callback, inputLogging);
        int textSize = aText.getPlainText().length();
        final List ruleMatchesSoFar = Collections.synchronizedList(new ArrayList());
        Future<List<CheckResults>> future = this.executorService.submit(new Callable<List<CheckResults>>(){

            @Override
            public List<CheckResults> call() throws Exception {
                List results = TextChecker.this.getRuleMatches(aText, lang, motherTongue, parameters, params, userConfig, detLang, preferredLangs, preferredVariants, f -> ruleMatchesSoFar.add(new CheckResults(Collections.singletonList(f), Collections.emptyList())));
                results.stream().flatMap(r -> r.getRuleMatches().stream()).forEach(RuleMatch::computeLazySuggestedReplacements);
                return results;
            }
        });
        String incompleteResultReason = null;
        try {
            res = limits.getMaxCheckTimeMillis() < 0L ? future.get() : future.get(limits.getMaxCheckTimeMillis(), TimeUnit.MILLISECONDS);
        }
        catch (ExecutionException e) {
            future.cancel(true);
            if (ExceptionUtils.getRootCause(e) instanceof ErrorRateTooHighException) {
                ServerMetricsCollector.getInstance().logRequestError(ServerMetricsCollector.RequestErrorType.TOO_MANY_ERRORS);
                this.databaseLogger.log(new DatabaseCheckErrorLogEntry("ErrorRateTooHigh", this.logServerId, agentId, userId, lang, detLang.getDetectedLanguage(), textSize, "matches: " + ruleMatchesSoFar.size()));
            }
            if (params.allowIncompleteResults && ExceptionUtils.getRootCause(e) instanceof ErrorRateTooHighException) {
                logger.warn(e.getMessage() + " - returning " + ruleMatchesSoFar.size() + " matches found so far. Detected language: " + detLang + ", " + ServerTools.getLoggingInfo(remoteAddress, null, -1, httpExchange, parameters, System.currentTimeMillis() - timeStart, this.reqCounter));
                res = new ArrayList<CheckResults>(ruleMatchesSoFar);
                incompleteResultReason = "Results are incomplete: " + ExceptionUtils.getRootCause(e).getMessage();
            }
            if (e.getCause() != null && e.getCause() instanceof OutOfMemoryError) {
                throw (OutOfMemoryError)e.getCause();
            }
            throw new RuntimeException(ServerTools.cleanUserTextFromMessage(e.getMessage(), parameters) + ", detected: " + detLang, e);
        }
        catch (TimeoutException e) {
            Object loadInfo;
            boolean cancelled = future.cancel(true);
            Path loadFile = Paths.get("/proc/loadavg", new String[0]);
            Object object = loadInfo = loadFile.toFile().exists() ? Files.readAllLines(loadFile).toString() : "(unknown)";
            if (errorRequestLimiter != null) {
                errorRequestLimiter.logAccess(remoteAddress, httpExchange.getRequestHeaders(), parameters);
            }
            String message = "Text checking took longer than allowed maximum of " + limits.getMaxCheckTimeMillis() + " milliseconds (cancelled: " + cancelled + ", lang: " + lang.getShortCodeWithCountryAndVariant() + ", detected: " + detLang + ", #" + count + ", " + aText.getPlainText().length() + " characters of text, mode: " + mode.toString().toLowerCase() + ", h: " + this.reqCounter.getHandleCount() + ", r: " + this.reqCounter.getRequestCount() + ", requestId: " + requestId + ", system load: " + (String)loadInfo + ")";
            if (params.allowIncompleteResults) {
                logger.info(message + " - returning " + ruleMatchesSoFar.size() + " matches found so far");
                res = new ArrayList<CheckResults>(ruleMatchesSoFar);
                incompleteResultReason = "Results are incomplete: text checking took longer than allowed maximum of " + String.format(Locale.ENGLISH, "%.2f", (double)limits.getMaxCheckTimeMillis() / 1000.0) + " seconds";
            }
            ServerMetricsCollector.getInstance().logRequestError(ServerMetricsCollector.RequestErrorType.MAX_CHECK_TIME);
            this.databaseLogger.log(new DatabaseCheckErrorLogEntry("MaxCheckTimeExceeded", this.logServerId, agentId, limits.getPremiumUid(), lang, detLang.getDetectedLanguage(), textSize, "load: " + (String)loadInfo));
            throw new RuntimeException(message, e);
        }
        this.setHeaders(httpExchange);
        List<RuleMatch> hiddenMatches = new ArrayList<RuleMatch>();
        if (!params.premium && this.config.getHiddenMatchesServer() == null && params.enableHiddenRules && this.config.getHiddenMatchesLanguages().contains(lang)) {
            ArrayList<RuleMatch> allMatches = new ArrayList<RuleMatch>();
            ArrayList<RuleMatch> premiumMatches = new ArrayList<RuleMatch>();
            for (CheckResults result : res) {
                ArrayList<RuleMatch> filteredMatches = new ArrayList<RuleMatch>();
                for (RuleMatch match : result.getRuleMatches()) {
                    if (Premium.get().isPremiumRule(match.getRule())) {
                        premiumMatches.add(match);
                    } else {
                        filteredMatches.add(match);
                        allMatches.add(match);
                    }
                    result.setRuleMatches(filteredMatches);
                }
            }
            hiddenMatches.addAll(ResultExtender.getAsHiddenMatches(allMatches, premiumMatches));
        }
        if (this.config.getHiddenMatchesServer() != null && params.enableHiddenRules && this.config.getHiddenMatchesLanguages().contains(lang)) {
            if (this.config.getHiddenMatchesServerFailTimeout() > 0 && this.lastHiddenMatchesServerTimeout != -1L && System.currentTimeMillis() - this.lastHiddenMatchesServerTimeout < (long)this.config.getHiddenMatchesServerFailTimeout()) {
                ServerMetricsCollector.getInstance().logHiddenServerStatus(false);
                ServerMetricsCollector.getInstance().logHiddenServerRequest(false, lang, 0);
                logger.warn("Warn: Skipped querying hidden matches server at " + this.config.getHiddenMatchesServer() + " because of recent error/timeout (timeout=" + this.config.getHiddenMatchesServerFailTimeout() + "ms).");
            } else {
                ResultExtender resultExtender = new ResultExtender(this.config.getHiddenMatchesServer(), this.config.getHiddenMatchesServerTimeout());
                try {
                    long start = System.currentTimeMillis();
                    List<RemoteRuleMatch> extensionMatches = resultExtender.getExtensionMatches(aText.getPlainText(), parameters);
                    ArrayList<RuleMatch> matches = new ArrayList<RuleMatch>();
                    for (CheckResults result : res) {
                        matches.addAll(result.getRuleMatches());
                    }
                    hiddenMatches = resultExtender.getFilteredExtensionMatches(matches, extensionMatches);
                    long end = System.currentTimeMillis();
                    logger.info("Hidden matches: " + extensionMatches.size() + " -> " + hiddenMatches.size() + " in " + (end - start) + "ms for " + lang.getShortCodeWithCountryAndVariant());
                    ServerMetricsCollector.getInstance().logHiddenServerStatus(true);
                    this.lastHiddenMatchesServerTimeout = -1L;
                    this.hiddenMatchesServerFailures = 0L;
                    ServerMetricsCollector.getInstance().logHiddenServerRequest(true, lang, hiddenMatches.size());
                }
                catch (Exception e) {
                    ServerMetricsCollector.getInstance().logHiddenServerRequest(false, lang, 0);
                    ++this.hiddenMatchesServerFailures;
                    if (this.hiddenMatchesServerFailures >= (long)this.config.getHiddenMatchesServerFall()) {
                        ServerMetricsCollector.getInstance().logHiddenServerStatus(false);
                        logger.warn("Failed to query hidden matches server at " + this.config.getHiddenMatchesServer() + ": " + e.getClass() + ": " + e.getMessage() + ", input was " + aText.getPlainText().length() + " characters - marked as down now");
                        this.lastHiddenMatchesServerTimeout = System.currentTimeMillis();
                    }
                    logger.warn("Failed to query hidden matches server at " + this.config.getHiddenMatchesServer() + ": " + e.getClass() + ": " + e.getMessage() + ", input was " + aText.getPlainText().length() + " characters - " + ((long)this.config.getHiddenMatchesServerFall() - this.hiddenMatchesServerFailures) + " errors until marked as down");
                }
            }
        }
        int compactMode = Integer.parseInt(parameters.getOrDefault("c", "0"));
        String response = this.getResponse(aText, lang, detLang, motherTongue, res, hiddenMatches, incompleteResultReason, compactMode, limits.getPremiumUid() == null);
        if (params.callback != null) {
            response = params.callback + "(" + response + ");";
        }
        String messageSent = "sent";
        String languageMessage = lang.getShortCodeWithCountryAndVariant();
        try {
            httpExchange.sendResponseHeaders(200, response.getBytes(ENCODING).length);
            httpExchange.getResponseBody().write(response.getBytes(ENCODING));
            ServerMetricsCollector.getInstance().logResponse(200);
        }
        catch (IOException exception) {
            messageSent = "notSent: " + exception.getMessage();
        }
        if (motherTongue != null) {
            languageMessage = languageMessage + " (mother tongue: " + motherTongue.getShortCodeWithCountryAndVariant() + ")";
        }
        if (autoDetectLanguage) {
            languageMessage = languageMessage + "[auto]";
        }
        this.languageCheckCounts.put(lang.getShortCodeWithCountryAndVariant(), count);
        int computationTime = (int)(System.currentTimeMillis() - timeStart);
        List premiumMatchRuleIds = res.stream().flatMap(r -> r.getRuleMatches().stream()).filter(k -> Premium.get().isPremiumRule(k.getRule())).map(k -> k.getRule().getId()).collect(Collectors.toList());
        String version = parameters.get("v") != null ? ", version: " + parameters.get("v") : "";
        String skipLimits = limits.getSkipLimits() ? ", skipLimits" : "";
        logger.info("Check done: " + aText.getPlainText().length() + " chars, " + languageMessage + ", requestId: " + requestId + ", #" + count + ", " + referrer + ", " + premiumMatchRuleIds.size() + "/" + res.size() + " matches, " + computationTime + "ms, agent:" + agent + version + ", " + messageSent + ", q:" + (this.workQueue != null ? Integer.valueOf(this.workQueue.size()) : "?") + ", h:" + this.reqCounter.getHandleCount() + ", dH:" + this.reqCounter.getDistinctIps() + ", r:" + this.reqCounter.getRequestCount() + ", m:" + ServerTools.getModeForLog(mode) + skipLimits + ", premium: " + (limits.getPremiumUid() != null && limits.hasPremium()) + (limits.getPremiumUid() != null ? ", uid:" + limits.getPremiumUid() : ""));
        if (limits.getPremiumUid() != null && limits.getPremiumUid() == 1456L) {
            logger.info("Eggbun input: " + aText.getPlainText().replace("\n", "\\n").replace("\r", "\\r"));
        }
        if (premiumMatchRuleIds.size() > 0) {
            for (String premiumMatchRuleId : premiumMatchRuleIds) {
                logger.info("premium:" + lang.getShortCodeWithCountryAndVariant() + ":" + premiumMatchRuleId);
            }
        }
        int matchCount = 0;
        HashMap<String, Integer> ruleMatchCount = new HashMap<String, Integer>();
        for (CheckResults r2 : res) {
            for (RuleMatch ruleMatch : r2.getRuleMatches()) {
                ++matchCount;
                String ruleId = ruleMatch.getRule().getId();
                ruleMatchCount.put(ruleId, ruleMatchCount.getOrDefault(ruleId, 0) + 1);
            }
        }
        if (!Premium.isPremiumStatusCheck(aText)) {
            ServerMetricsCollector.getInstance().logCheck(lang, computationTime, textSize, matchCount, mode);
            if (!this.config.isSkipLoggingChecks() && limits.getRequestsPerDay() != null) {
                DatabaseCheckLogEntry logEntry = new DatabaseCheckLogEntry(userId, agentId, this.logServerId, textSize, matchCount, lang, detLang.getDetectedLanguage(), computationTime, textSessionId, mode.toString());
                logEntry.setRuleMatches(new DatabaseRuleMatchLogEntry(this.config.isSkipLoggingRuleMatches() ? Collections.emptyMap() : ruleMatchCount));
                this.databaseLogger.log(logEntry);
            }
            if (this.databaseLogger.isLogging()) {
                DatabasePingLogEntry ping;
                if (System.currentTimeMillis() - this.pingsCleanDateMillis > 60000L && this.pings.size() < 5000) {
                    logger.info("Cleaning pings DB (" + this.pings.size() + " items)");
                    this.pings.clear();
                    this.pingsCleanDateMillis = System.currentTimeMillis();
                }
                if (agentId != null && userId != null && !this.pings.contains(ping = new DatabasePingLogEntry(agentId, userId))) {
                    this.databaseLogger.log(ping);
                    if (this.pings.size() >= 5000) {
                        logger.warn("Pings DB has reached max size: " + this.pings.size());
                    } else {
                        this.pings.add(ping);
                    }
                }
            }
        }
    }

    private Map<String, Integer> getRuleValues(Map<String, String> parameters) {
        String[] pairs;
        HashMap<String, Integer> ruleValues = new HashMap<String, Integer>();
        String parameterString = parameters.get("ruleValues");
        if (parameterString == null) {
            return ruleValues;
        }
        for (String pair : pairs = parameterString.split("[,]")) {
            String[] ruleAndValue = pair.split("[:]");
            ruleValues.put(ruleAndValue[0], Integer.parseInt(ruleAndValue[1]));
        }
        return ruleValues;
    }

    private List<String> getUserDictWords(UserLimits limits, List<String> groups) {
        DatabaseAccess db = DatabaseAccess.getInstance();
        return db.getWordsFromDictionaries(limits, groups);
    }

    protected void checkParams(Map<String, String> parameters) {
        if (parameters.get("text") == null && parameters.get("data") == null) {
            throw new BadRequestException("Missing 'text' or 'data' parameter");
        }
    }

    private List<CheckResults> getRuleMatches(AnnotatedText aText, Language lang, Language motherTongue, Map<String, String> parameters, QueryParams params, UserConfig userConfig, DetectedLanguage detLang, List<String> preferredLangs, List<String> preferredVariants, RuleMatchListener listener) throws Exception {
        if (this.cache != null && this.cache.requestCount() > 0.0 && this.cache.requestCount() % 500.0 == 0.0) {
            String sentenceHitPercentage = String.format(Locale.ENGLISH, "%.2f", this.cache.getSentenceCache().stats().hitRate() * 100.0);
            String matchesHitPercentage = String.format(Locale.ENGLISH, "%.2f", this.cache.getMatchesCache().stats().hitRate() * 100.0);
            String remoteHitPercentage = String.format(Locale.ENGLISH, "%.2f", this.cache.getRemoteMatchesCache().stats().hitRate() * 100.0);
            logger.info("Cache stats: " + sentenceHitPercentage + "% / " + matchesHitPercentage + "% / " + remoteHitPercentage + "% hit rate");
        }
        if (parameters.get("sourceText") != null) {
            if (parameters.get("sourceLanguage") == null) {
                throw new BadRequestException("'sourceLanguage' parameter missing - must be set when 'sourceText' is set");
            }
            Language sourceLanguage = TextChecker.parseLanguage(parameters.get("sourceLanguage"));
            JLanguageTool sourceLt = new JLanguageTool(sourceLanguage);
            JLanguageTool targetLt = new JLanguageTool(lang);
            if (userConfig.filterDictionaryMatches()) {
                targetLt.addMatchFilter(new DictionaryMatchFilter(userConfig));
            }
            List<BitextRule> bitextRules = Tools.getBitextRules(sourceLanguage, lang);
            return Collections.singletonList(new CheckResults(Tools.checkBitext(parameters.get("sourceText"), aText.getPlainText(), sourceLt, targetLt, bitextRules), Collections.emptyList()));
        }
        ArrayList<CheckResults> res = new ArrayList<CheckResults>();
        if (preferredLangs.size() < 2 || parameters.get("multilingual") == null || parameters.get("multilingual").equals("false")) {
            res.addAll(this.getPipelineResults(aText, lang, motherTongue, params, userConfig, listener));
        } else {
            try {
                Language mainLang = this.getLanguageVariantForCode(detLang.getDetectedLanguage().getShortCode(), preferredVariants);
                ArrayList<Language> secondLangs = new ArrayList<Language>();
                for (String preferredLangCode : preferredLangs) {
                    if (preferredLangCode.equals(mainLang.getShortCode())) continue;
                    secondLangs.add(this.getLanguageVariantForCode(preferredLangCode, preferredVariants));
                    break;
                }
                LanguageAnnotator annotator = new LanguageAnnotator();
                List<FragmentWithLanguage> fragments = annotator.detectLanguages(aText.getPlainText(), mainLang, secondLangs);
                ArrayList<Language> langs = new ArrayList<Language>();
                langs.add(mainLang);
                langs.addAll(secondLangs);
                Map<Language, AnnotatedTextBuilder> lang2builder = this.getBuilderMap(fragments, new HashSet<Language>(langs));
                for (Map.Entry<Language, AnnotatedTextBuilder> entry : lang2builder.entrySet()) {
                    res.addAll(this.getPipelineResults(entry.getValue().build(), entry.getKey(), motherTongue, params, userConfig, listener));
                }
            }
            catch (Exception e) {
                logger.error("Problem with multilingual mode (preferredLangs=" + preferredLangs + ", preferredVariants=" + preferredVariants + "), falling back to single language.", e);
                res.addAll(this.getPipelineResults(aText, lang, motherTongue, params, userConfig, listener));
            }
        }
        return res;
    }

    private Language getLanguageVariantForCode(String langCode, List<String> preferredVariants) {
        for (String preferredVariant : preferredVariants) {
            if (!preferredVariant.startsWith(langCode + "-")) continue;
            return TextChecker.parseLanguage(preferredVariant);
        }
        return TextChecker.parseLanguage(langCode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private List<CheckResults> getPipelineResults(AnnotatedText aText, Language lang, Language motherTongue, QueryParams params, UserConfig userConfig, RuleMatchListener listener) throws Exception {
        PipelinePool.PipelineSettings settings = null;
        Pipeline lt = null;
        ArrayList<CheckResults> res = new ArrayList<CheckResults>();
        try {
            settings = new PipelinePool.PipelineSettings(lang, motherTongue, params, this.config.globalConfig, userConfig);
            lt = this.pipelinePool.getPipeline(settings);
            Long textSessionId = userConfig.getTextSessionId();
            if (params.regressionTestMode) {
                textSessionId = -2L;
            }
            res.add(lt.check2(aText, true, JLanguageTool.ParagraphHandling.NORMAL, listener, params.mode, params.level, this.executorService, textSessionId));
            if (lt == null) return res;
        }
        catch (Throwable throwable) {
            if (lt == null) throw throwable;
            this.pipelinePool.returnPipeline(settings, lt);
            throw throwable;
        }
        this.pipelinePool.returnPipeline(settings, lt);
        return res;
    }

    @NotNull
    private Map<Language, AnnotatedTextBuilder> getBuilderMap(List<FragmentWithLanguage> fragments, Set<Language> maybeUsedLangs) {
        HashMap<Language, AnnotatedTextBuilder> lang2builder = new HashMap<Language, AnnotatedTextBuilder>();
        for (Language usedLang : maybeUsedLangs) {
            if (!lang2builder.containsKey(usedLang)) {
                lang2builder.put(usedLang, new AnnotatedTextBuilder());
            }
            AnnotatedTextBuilder atb = (AnnotatedTextBuilder)lang2builder.get(usedLang);
            for (FragmentWithLanguage fragment : fragments) {
                if (usedLang.getShortCodeWithCountryAndVariant().equals(fragment.getLangCode())) {
                    atb.addText(fragment.getFragment());
                    continue;
                }
                atb.addMarkup(fragment.getFragment());
            }
        }
        return lang2builder;
    }

    @NotNull
    private List<CategoryId> getCategoryIds(String paramName, Map<String, String> parameters) {
        List<String> stringIds = this.getCommaSeparatedStrings(paramName, parameters);
        ArrayList<CategoryId> ids = new ArrayList<CategoryId>();
        for (String stringId : stringIds) {
            ids.add(new CategoryId(stringId));
        }
        return ids;
    }

    @NotNull
    protected List<String> getCommaSeparatedStrings(String paramName, Map<String, String> parameters) {
        String disabledParam = parameters.get(paramName);
        ArrayList<String> result = new ArrayList<String>();
        if (disabledParam != null) {
            result.addAll(Arrays.asList(disabledParam.split(",")));
        }
        return result;
    }

    DetectedLanguage detectLanguageOfString(String text, String fallbackLanguage, List<String> preferredVariants, List<String> noopLangs, List<String> preferredLangs, boolean testMode) {
        String cleanText = this.ngramIdentifier != null ? this.ngramIdentifier.cleanAndShortenText(text) : this.fastTextIdentifier.cleanAndShortenText(text);
        DetectedLanguage detected = this.ngramIdentifier != null && cleanText.length() < 50 ? this.ngramIdentifier.detectLanguage(cleanText, noopLangs, preferredLangs) : this.fastTextIdentifier.detectLanguage(cleanText, noopLangs, preferredLangs);
        Language lang = detected == null ? TextChecker.parseLanguage(fallbackLanguage != null ? fallbackLanguage : "en") : detected.getDetectedLanguage();
        if (preferredVariants.size() > 0) {
            for (String preferredVariant : preferredVariants) {
                if (!preferredVariant.contains("-")) {
                    throw new BadRequestException("Invalid format for 'preferredVariants', expected a dash as in 'en-GB': '" + preferredVariant + "'");
                }
                String preferredVariantLang = preferredVariant.split("-")[0];
                if (!preferredVariantLang.equals(lang.getShortCode()) || (lang = TextChecker.parseLanguage(preferredVariant)) != null) continue;
                throw new BadRequestException("Invalid 'preferredVariants', no such language/variant found: '" + preferredVariant + "'");
            }
        } else if (lang.getDefaultLanguageVariant() != null) {
            lang = lang.getDefaultLanguageVariant();
        }
        return new DetectedLanguage(null, lang, detected != null ? detected.getDetectionConfidence() : 0.0f);
    }

    static class QueryParams {
        final List<Language> altLanguages;
        final List<String> enabledRules;
        final List<String> disabledRules;
        final List<CategoryId> enabledCategories;
        final List<CategoryId> disabledCategories;
        final boolean useEnabledOnly;
        final boolean useQuerySettings;
        final boolean allowIncompleteResults;
        final boolean enableHiddenRules;
        final boolean premium;
        final boolean enableTempOffRules;
        final JLanguageTool.Mode mode;
        final JLanguageTool.Level level;
        final String callback;
        final boolean inputLogging;
        final boolean regressionTestMode;

        QueryParams(List<Language> altLanguages, List<String> enabledRules, List<String> disabledRules, List<CategoryId> enabledCategories, List<CategoryId> disabledCategories, boolean useEnabledOnly, boolean useQuerySettings, boolean allowIncompleteResults, boolean enableHiddenRules, boolean premium, boolean enableTempOffRules, JLanguageTool.Mode mode, JLanguageTool.Level level, @Nullable String callback) {
            this(altLanguages, enabledRules, disabledRules, enabledCategories, disabledCategories, useEnabledOnly, useQuerySettings, allowIncompleteResults, enableHiddenRules, premium, enableTempOffRules, mode, level, callback, true);
        }

        QueryParams(List<Language> altLanguages, List<String> enabledRules, List<String> disabledRules, List<CategoryId> enabledCategories, List<CategoryId> disabledCategories, boolean useEnabledOnly, boolean useQuerySettings, boolean allowIncompleteResults, boolean enableHiddenRules, boolean premium, boolean enableTempOffRules, JLanguageTool.Mode mode, JLanguageTool.Level level, @Nullable String callback, boolean inputLogging) {
            this.altLanguages = Objects.requireNonNull(altLanguages);
            this.enabledRules = enabledRules;
            this.disabledRules = disabledRules;
            this.enabledCategories = enabledCategories;
            this.disabledCategories = disabledCategories;
            this.useEnabledOnly = useEnabledOnly;
            this.useQuerySettings = useQuerySettings;
            this.allowIncompleteResults = allowIncompleteResults;
            this.enableHiddenRules = enableHiddenRules;
            this.premium = premium;
            this.enableTempOffRules = enableTempOffRules;
            this.regressionTestMode = enableTempOffRules;
            this.mode = Objects.requireNonNull(mode);
            this.level = Objects.requireNonNull(level);
            if (callback != null && !callback.matches("[a-zA-Z]+")) {
                throw new BadRequestException("'callback' value must match [a-zA-Z]+: '" + callback + "'");
            }
            this.callback = callback;
            this.inputLogging = inputLogging;
        }

        public int hashCode() {
            return new HashCodeBuilder().append(this.altLanguages).append(this.enabledRules).append(this.disabledRules).append(this.enabledCategories).append(this.disabledCategories).append(this.useEnabledOnly).append(this.useQuerySettings).append(this.allowIncompleteResults).append(this.enableHiddenRules).append(this.premium).append(this.enableTempOffRules).append(this.regressionTestMode).append((Object)this.mode).append((Object)this.level).append(this.callback).append(this.inputLogging).toHashCode();
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            QueryParams other = (QueryParams)obj;
            return new EqualsBuilder().append(this.altLanguages, other.altLanguages).append(this.enabledRules, other.enabledRules).append(this.disabledRules, other.disabledRules).append(this.enabledCategories, other.enabledCategories).append(this.disabledCategories, other.disabledCategories).append(this.useEnabledOnly, other.useEnabledOnly).append(this.useQuerySettings, other.useQuerySettings).append(this.allowIncompleteResults, other.allowIncompleteResults).append(this.enableHiddenRules, other.enableHiddenRules).append(this.premium, other.premium).append(this.enableTempOffRules, other.enableTempOffRules).append(this.regressionTestMode, other.regressionTestMode).append((Object)this.mode, (Object)other.mode).append((Object)this.level, (Object)other.level).append(this.callback, other.callback).append(this.inputLogging, other.inputLogging).isEquals();
        }

        public String toString() {
            return new ToStringBuilder(this).append("altLanguages", this.altLanguages).append("enabledRules", this.enabledRules).append("disabledRules", this.disabledRules).append("enabledCategories", this.enabledCategories).append("disabledCategories", this.disabledCategories).append("useEnabledOnly", this.useEnabledOnly).append("useQuerySettings", this.useQuerySettings).append("allowIncompleteResults", this.allowIncompleteResults).append("enableHiddenRules", this.enableHiddenRules).append("premium", this.premium).append("enableTempOffRules", this.enableTempOffRules).append("regressionTestMode", this.regressionTestMode).append("mode", (Object)this.mode).append("level", (Object)this.level).append("callback", this.callback).append("inputLogging", this.inputLogging).build();
        }
    }
}

