/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.FutureTask;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;
import org.languagetool.AnalyzedSentence;
import org.languagetool.JLanguageTool;
import org.languagetool.Language;
import org.languagetool.RuleMatchListener;
import org.languagetool.TestTools;
import org.languagetool.language.Demo;
import org.languagetool.markup.AnnotatedText;
import org.languagetool.markup.AnnotatedTextBuilder;
import org.languagetool.rules.RemoteRule;
import org.languagetool.rules.RemoteRuleConfig;
import org.languagetool.rules.RemoteRuleResult;
import org.languagetool.rules.Rule;
import org.languagetool.rules.RuleMatch;

@Ignore(value="For interactive use")
public class RemoteRuleTimeoutTest {
    private static final long TIMEOUT = 50L;
    RemoteRule rule;
    JLanguageTool lt;
    AnnotatedText text;

    @Before
    public void setUp() throws Exception {
        this.rule = this.getTestRemoteRule();
        this.lt = new JLanguageTool(TestTools.getDemoLanguage());
        this.lt.getAllRules().forEach(r -> this.lt.disableRule(this.rule.getId()));
        this.lt.addRule((Rule)this.rule);
        this.lt.enableRule(this.rule.getId());
        this.text = new AnnotatedTextBuilder().addText("Foo").build();
    }

    @NotNull
    private RemoteRule getTestRemoteRule() throws ExecutionException {
        return new TestRemoteRule();
    }

    @After
    public void tearDown() throws Exception {
    }

    @Test
    public void testCancelThreads() throws IOException, InterruptedException, TimeoutException, ExecutionException {
        ThreadFactory factory = new ThreadFactoryBuilder().setDaemon(true).setNameFormat("test-pool-%d").build();
        ExecutorService pool = Executors.newCachedThreadPool(factory);
        int runs = 100;
        int batches = 10;
        long wait = 500L;
        RuleMatchListener listener = ruleMatch -> {
            throw new RuntimeException("This shouldn't happen");
        };
        for (int i = 0; i < runs; ++i) {
            for (int j = 0; j < batches; ++j) {
                FutureTask<List> task = new FutureTask<List>(() -> {
                    List matches = this.lt.check(this.text, true, JLanguageTool.ParagraphHandling.NORMAL, listener, JLanguageTool.Mode.ALL, JLanguageTool.Level.DEFAULT, pool);
                    return matches;
                });
                pool.submit(task);
                try {
                    List matches = task.get(50L, TimeUnit.MILLISECONDS);
                    Assert.assertTrue((boolean)matches.isEmpty());
                    continue;
                }
                catch (ExecutionException | TimeoutException e) {
                    task.cancel(true);
                }
            }
            Thread.sleep(wait);
        }
        Thread.sleep(wait);
        int running = Thread.activeCount();
        Thread.getAllStackTraces().forEach((thread, stack) -> System.out.printf("Stacktrace for %s (%s)%n: %s%n", new Object[]{thread.getName(), thread.getState(), Arrays.toString(stack)}));
        System.out.println("Running threads: " + running);
    }

    static class TestRemoteRule
    extends RemoteRule {
        private static final RemoteRuleConfig testConfig = new RemoteRuleConfig("TEST_REMOTE_RULE", "example.com", Integer.valueOf(1234), Integer.valueOf(0), Long.valueOf(50L), Float.valueOf(0.0f), Integer.valueOf(Integer.MAX_VALUE), Long.valueOf(0L), Long.valueOf(0L), Long.valueOf(0L), Collections.emptyMap());

        TestRemoteRule() {
            super((Language)new Demo(), JLanguageTool.getMessageBundle(), testConfig, false);
        }

        protected RemoteRule.RemoteRequest prepareRequest(List<AnalyzedSentence> sentences, Long textSessionId) {
            return new TestRemoteRequest(sentences);
        }

        private RuleMatch testMatch(AnalyzedSentence s) {
            return new RuleMatch((Rule)this, s, 0, 1, "Test match");
        }

        protected Callable<RemoteRuleResult> executeRequest(RemoteRule.RemoteRequest request, long timeoutMilliseconds) throws TimeoutException {
            return () -> {
                TestRemoteRequest req = (TestRemoteRequest)request;
                List matches = req.sentences.stream().map(this::testMatch).collect(Collectors.toList());
                while (!Thread.interrupted()) {
                }
                return new RemoteRuleResult(true, true, matches, req.sentences);
            };
        }

        protected RemoteRuleResult fallbackResults(RemoteRule.RemoteRequest request) {
            TestRemoteRequest req = (TestRemoteRequest)request;
            return new RemoteRuleResult(false, false, Collections.emptyList(), req.sentences);
        }

        public String getDescription() {
            return "TEST REMOTE RULE";
        }

        class TestRemoteRequest
        extends RemoteRule.RemoteRequest {
            private final List<AnalyzedSentence> sentences;

            TestRemoteRequest(List<AnalyzedSentence> sentences) {
                this.sentences = sentences;
            }
        }
    }
}

