/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.languagetool.LinguServices;

public class UserConfig {
    private static boolean abTestEnabled = false;
    private final List<String> userSpecificSpellerWords;
    private final int maxSpellingSuggestions;
    private final Long userDictCacheSize;
    private final String userDictName;
    private final Long premiumUid;
    private final Map<String, Integer> configurableRuleValues = new HashMap<String, Integer>();
    private final LinguServices linguServices;
    private final boolean filterDictionaryMatches;
    private final Long textSessionId;
    private final String abTest;

    public static void enableABTests() {
        abTestEnabled = true;
    }

    public static boolean hasABTestsEnabled() {
        return abTestEnabled;
    }

    public UserConfig() {
        this(new ArrayList<String>(), new HashMap<String, Integer>());
    }

    public UserConfig(List<String> userSpecificSpellerWords) {
        this(userSpecificSpellerWords, new HashMap<String, Integer>());
    }

    public UserConfig(Map<String, Integer> ruleValues) {
        this(new ArrayList<String>(), Objects.requireNonNull(ruleValues));
    }

    public UserConfig(Map<String, Integer> ruleValues, LinguServices linguServices) {
        this(new ArrayList<String>(), Objects.requireNonNull(ruleValues), 0, 0L, null, 0L, linguServices);
    }

    public UserConfig(List<String> userSpecificSpellerWords, Map<String, Integer> ruleValues) {
        this(userSpecificSpellerWords, ruleValues, 0);
    }

    public UserConfig(List<String> userSpecificSpellerWords, Map<String, Integer> ruleValues, int maxSpellingSuggestions) {
        this(userSpecificSpellerWords, ruleValues, maxSpellingSuggestions, null, null, null, null);
    }

    public UserConfig(List<String> userSpecificSpellerWords, Map<String, Integer> ruleValues, int maxSpellingSuggestions, Long premiumUid, String userDictName, Long userDictCacheSize, LinguServices linguServices) {
        this(userSpecificSpellerWords, ruleValues, maxSpellingSuggestions, premiumUid, userDictName, userDictCacheSize, linguServices, false);
    }

    public UserConfig(List<String> userSpecificSpellerWords, Map<String, Integer> ruleValues, int maxSpellingSuggestions, Long premiumUid, String userDictName, Long userDictCacheSize, LinguServices linguServices, boolean filterDictionaryMatches) {
        this(userSpecificSpellerWords, ruleValues, maxSpellingSuggestions, premiumUid, userDictName, userDictCacheSize, linguServices, filterDictionaryMatches, null, null);
    }

    public UserConfig(List<String> userSpecificSpellerWords, Map<String, Integer> ruleValues, int maxSpellingSuggestions, Long premiumUid, String userDictName, Long userDictCacheSize, LinguServices linguServices, boolean filterDictionaryMatches, @Nullable String abTest, @Nullable Long textSessionId) {
        this.userSpecificSpellerWords = Objects.requireNonNull(userSpecificSpellerWords);
        for (Map.Entry<String, Integer> entry : ruleValues.entrySet()) {
            this.configurableRuleValues.put(entry.getKey(), entry.getValue());
        }
        this.maxSpellingSuggestions = maxSpellingSuggestions;
        this.premiumUid = premiumUid;
        this.userDictName = userDictName == null ? "default" : userDictName;
        this.userDictCacheSize = userDictCacheSize;
        this.linguServices = linguServices;
        this.filterDictionaryMatches = filterDictionaryMatches;
        this.abTest = abTest;
        this.textSessionId = textSessionId;
    }

    public List<String> getAcceptedWords() {
        return this.userSpecificSpellerWords;
    }

    @NotNull
    public Set<String> getAcceptedPhrases() {
        HashSet<String> phrases = new HashSet<String>();
        for (String wordOrPhrase : this.userSpecificSpellerWords) {
            if (!wordOrPhrase.contains(" ")) continue;
            phrases.add(wordOrPhrase);
        }
        return phrases;
    }

    public int getMaxSpellingSuggestions() {
        return this.maxSpellingSuggestions;
    }

    public Map<String, Integer> getConfigValues() {
        return this.configurableRuleValues;
    }

    public void insertConfigValues(Map<String, Integer> ruleValues) {
        for (Map.Entry<String, Integer> entry : ruleValues.entrySet()) {
            this.configurableRuleValues.put(entry.getKey(), entry.getValue());
        }
    }

    public int getConfigValueByID(String ruleID) {
        if (this.configurableRuleValues.containsKey(ruleID)) {
            return this.configurableRuleValues.get(ruleID);
        }
        return -1;
    }

    public boolean hasLinguServices() {
        return this.linguServices != null;
    }

    public LinguServices getLinguServices() {
        return this.linguServices;
    }

    public Long getUserDictCacheSize() {
        return this.userDictCacheSize;
    }

    public String getUserDictName() {
        return this.userDictName;
    }

    public Long getPremiumUid() {
        return this.premiumUid;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UserConfig other = (UserConfig)o;
        return new EqualsBuilder().append(this.configurableRuleValues, other.configurableRuleValues).append((Object)this.premiumUid, (Object)other.premiumUid).append((Object)this.userDictName, (Object)other.userDictName).append(this.userSpecificSpellerWords, other.userSpecificSpellerWords).append(this.filterDictionaryMatches, other.filterDictionaryMatches).append((Object)this.abTest, (Object)other.abTest).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder(3, 11).append(this.maxSpellingSuggestions).append((Object)this.premiumUid).append((Object)this.userDictName).append((Object)this.userDictCacheSize).append(this.configurableRuleValues).append((Object)this.abTest).append(this.filterDictionaryMatches).toHashCode();
    }

    public String toString() {
        return "UserConfig{userSpecificSpellerWords=" + this.userSpecificSpellerWords + ", maxSpellingSuggestions=" + this.maxSpellingSuggestions + ", userDictName='" + this.userDictName + '\'' + ", configurableRuleValues=" + this.configurableRuleValues + ", linguServices=" + this.linguServices + ", filterDictionaryMatches=" + this.filterDictionaryMatches + ", textSessionId=" + this.textSessionId + ", abTest='" + this.abTest + '\'' + '}';
    }

    public Long getTextSessionId() {
        return this.textSessionId;
    }

    public String getAbTest() {
        return this.abTest;
    }

    public boolean filterDictionaryMatches() {
        return this.filterDictionaryMatches;
    }
}

