/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules.spelling.morfologik;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.vdurmont.emoji.EmojiManager;
import java.io.IOException;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.function.Supplier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.languagetool.AnalyzedSentence;
import org.languagetool.AnalyzedTokenReadings;
import org.languagetool.Experimental;
import org.languagetool.GlobalConfig;
import org.languagetool.JLanguageTool;
import org.languagetool.Language;
import org.languagetool.UserConfig;
import org.languagetool.languagemodel.LanguageModel;
import org.languagetool.rules.Categories;
import org.languagetool.rules.ITSIssueType;
import org.languagetool.rules.RuleMatch;
import org.languagetool.rules.SuggestedReplacement;
import org.languagetool.rules.spelling.SpellingCheckRule;
import org.languagetool.rules.spelling.morfologik.MorfologikMultiSpeller;
import org.languagetool.rules.spelling.suggestions.SuggestionsChanges;
import org.languagetool.rules.translation.TranslationEntry;
import org.languagetool.rules.translation.Translator;
import org.languagetool.tools.StringTools;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class MorfologikSpellerRule
extends SpellingCheckRule {
    private static final Logger logger = LoggerFactory.getLogger(MorfologikSpellerRule.class);
    protected MorfologikMultiSpeller speller1;
    protected MorfologikMultiSpeller speller2;
    protected MorfologikMultiSpeller speller3;
    protected Locale conversionLocale;
    protected final Language motherTongue;
    protected final GlobalConfig globalConfig;
    private boolean ignoreTaggedWords = false;
    private boolean checkCompound = false;
    private Pattern compoundRegex = Pattern.compile("-");
    private final UserConfig userConfig;
    static final int MAX_FREQUENCY_FOR_SPLITTING = 21;
    private final Pattern pHasNoLetter = Pattern.compile("^[^\\p{L}]+$");

    public abstract String getFileName();

    @Override
    public abstract String getId();

    public MorfologikSpellerRule(ResourceBundle messages, Language language) throws IOException {
        this(messages, language, null);
    }

    public MorfologikSpellerRule(ResourceBundle messages, Language language, UserConfig userConfig) throws IOException {
        this(messages, language, userConfig, Collections.emptyList());
    }

    public MorfologikSpellerRule(ResourceBundle messages, Language language, UserConfig userConfig, List<Language> altLanguages) throws IOException {
        this(messages, language, null, userConfig, altLanguages, null, null);
    }

    public MorfologikSpellerRule(ResourceBundle messages, Language language, GlobalConfig globalConfig, UserConfig userConfig, List<Language> altLanguages, LanguageModel languageModel, Language motherTongue) throws IOException {
        super(messages, language, userConfig, altLanguages, languageModel);
        this.globalConfig = globalConfig;
        this.userConfig = userConfig;
        this.motherTongue = motherTongue;
        super.setCategory(Categories.TYPOS.getCategory(messages));
        this.conversionLocale = this.conversionLocale != null ? this.conversionLocale : Locale.getDefault();
        this.init();
        this.setLocQualityIssueType(ITSIssueType.Misspelling);
    }

    @Override
    public String getDescription() {
        return this.messages.getString("desc_spelling");
    }

    public void setLocale(Locale locale) {
        this.conversionLocale = locale;
    }

    public void setIgnoreTaggedWords() {
        this.ignoreTaggedWords = true;
    }

    @Override
    public RuleMatch[] match(AnalyzedSentence sentence) throws IOException {
        ArrayList<RuleMatch> ruleMatches = new ArrayList<RuleMatch>();
        AnalyzedTokenReadings[] tokens = this.getSentenceWithImmunization(sentence).getTokensWithoutWhitespace();
        if (this.initSpellers()) {
            return this.toRuleMatchArray(ruleMatches);
        }
        int idx = -1;
        long sentLength = Arrays.stream(sentence.getTokensWithoutWhitespace()).filter(k -> !k.isNonWord()).count() - 1L;
        for (AnalyzedTokenReadings token : tokens) {
            float errRatio;
            int hiddenCharOffset;
            if (this.canBeIgnored(tokens, ++idx, token)) continue;
            int startPos = token.getStartPos();
            String word = token.getAnalyzedToken(0).getToken();
            Matcher mHasNoLetter = this.pHasNoLetter.matcher(word);
            if (mHasNoLetter.matches()) continue;
            String normalizedWord = StringTools.normalizeNFKC(word);
            if (word.length() > 1 && !word.equals(normalizedWord) && !normalizedWord.contains(" ") && this.isMisspelled(this.speller1, word)) {
                if (!this.isMisspelled(this.speller1, normalizedWord)) {
                    RuleMatch ruleMatch = new RuleMatch(this, sentence, startPos, startPos + word.length(), this.messages.getString("spelling"), this.messages.getString("desc_spelling_short"));
                    ruleMatch.addSuggestedReplacement(normalizedWord);
                    ruleMatches.add(ruleMatch);
                    continue;
                }
                List<String> suggestions = this.speller1.getSuggestions(normalizedWord);
                RuleMatch ruleMatch = new RuleMatch(this, sentence, startPos, startPos + word.length(), this.messages.getString("spelling"), this.messages.getString("desc_spelling_short"));
                ruleMatch.addSuggestedReplacements(suggestions);
                ruleMatches.add(ruleMatch);
                continue;
            }
            int newRuleIdx = ruleMatches.size();
            Pattern pattern = this.tokenizingPattern();
            if (pattern == null) {
                ruleMatches.addAll(this.getRuleMatches(word, startPos, sentence, ruleMatches, idx, tokens));
            } else {
                int index = 0;
                Matcher m = pattern.matcher(word);
                while (m.find()) {
                    String match = word.subSequence(index, m.start()).toString();
                    ruleMatches.addAll(this.getRuleMatches(match, startPos + index, sentence, ruleMatches, idx, tokens));
                    index = m.end();
                }
                if (index == 0) {
                    ruleMatches.addAll(this.getRuleMatches(word, startPos, sentence, ruleMatches, idx, tokens));
                } else {
                    ruleMatches.addAll(this.getRuleMatches(word.subSequence(index, word.length()).toString(), startPos + index, sentence, ruleMatches, idx, tokens));
                }
            }
            if (ruleMatches.size() > newRuleIdx && (hiddenCharOffset = token.getToken().length() - word.length()) > 0) {
                for (int i = newRuleIdx; i < ruleMatches.size(); ++i) {
                    RuleMatch ruleMatch = (RuleMatch)ruleMatches.get(i);
                    if (token.getEndPos() < ruleMatch.getToPos()) continue;
                    ruleMatch.setOffsetPosition(ruleMatch.getFromPos(), ruleMatch.getToPos() + hiddenCharOffset);
                }
            }
            if (sentLength <= 3L || !((double)(errRatio = (float)ruleMatches.size() / (float)sentLength) >= 0.5)) continue;
            ((RuleMatch)ruleMatches.get(0)).setErrorLimitLang("zz");
        }
        return this.toRuleMatchArray(ruleMatches);
    }

    @Nullable
    protected Translator getTranslator(GlobalConfig globalConfig) {
        return null;
    }

    private boolean initSpellers() throws IOException {
        if (this.speller1 == null) {
            String binaryDict = null;
            if (JLanguageTool.getDataBroker().resourceExists(this.getFileName()) || Paths.get(this.getFileName(), new String[0]).toFile().exists()) {
                binaryDict = this.getFileName();
            }
            if (binaryDict != null) {
                this.initSpeller(binaryDict);
            } else {
                return true;
            }
        }
        return false;
    }

    private void initSpeller(String binaryDict) throws IOException {
        ArrayList<String> plainTextDicts = new ArrayList<String>();
        String languageVariantPlainTextDict = null;
        if (this.getSpellingFileName() != null && JLanguageTool.getDataBroker().resourceExists(this.getSpellingFileName())) {
            plainTextDicts.add(this.getSpellingFileName());
        }
        for (String fileName : this.getAdditionalSpellingFileNames()) {
            if (!JLanguageTool.getDataBroker().resourceExists(fileName)) continue;
            plainTextDicts.add(fileName);
        }
        if (this.getLanguageVariantSpellingFileName() != null && JLanguageTool.getDataBroker().resourceExists(this.getLanguageVariantSpellingFileName())) {
            languageVariantPlainTextDict = this.getLanguageVariantSpellingFileName();
        }
        this.speller1 = new MorfologikMultiSpeller(binaryDict, plainTextDicts, languageVariantPlainTextDict, this.userConfig, 1);
        this.speller2 = new MorfologikMultiSpeller(binaryDict, plainTextDicts, languageVariantPlainTextDict, this.userConfig, 2);
        this.speller3 = new MorfologikMultiSpeller(binaryDict, plainTextDicts, languageVariantPlainTextDict, this.userConfig, 3);
        this.setConvertsCase(this.speller1.convertsCase());
    }

    private boolean canBeIgnored(AnalyzedTokenReadings[] tokens, int idx, AnalyzedTokenReadings token) throws IOException {
        return token.isSentenceStart() || token.isImmunized() || token.isIgnoredBySpeller() || MorfologikSpellerRule.isUrl(token.getToken()) || MorfologikSpellerRule.isEMail(token.getToken()) || this.ignoreTaggedWords && token.isTagged() && !this.isProhibited(token.getToken()) || this.ignoreToken(tokens, idx);
    }

    @Override
    @Experimental
    public boolean isMisspelled(String word) throws IOException {
        this.initSpellers();
        return this.isMisspelled(this.speller1, word);
    }

    protected boolean isMisspelled(MorfologikMultiSpeller speller, String word) {
        if (!speller.isMisspelled(word)) {
            return false;
        }
        if (this.checkCompound && this.compoundRegex.matcher(word).find()) {
            String[] words;
            for (String singleWord : words = this.compoundRegex.split(word)) {
                if (!speller.isMisspelled(singleWord)) continue;
                return true;
            }
            return false;
        }
        return true;
    }

    private static int getFrequency(MorfologikMultiSpeller speller, String word) {
        return speller.getFrequency(word);
    }

    protected List<RuleMatch> getRuleMatches(String word, int startPos, AnalyzedSentence sentence, List<RuleMatch> ruleMatchesSoFar, int idx, AnalyzedTokenReadings[] tokens) throws IOException {
        boolean fullResults;
        String nextWord;
        String sugg;
        String sugg2b;
        String sugg2a;
        String sugg1b;
        String sugg1a;
        String prevWord;
        ArrayList<RuleMatch> ruleMatches = new ArrayList<RuleMatch>();
        RuleMatch ruleMatch = null;
        if (!this.isMisspelled(this.speller1, word) && !this.isProhibited(word)) {
            return ruleMatches;
        }
        if (ruleMatchesSoFar.size() > 0 && ruleMatchesSoFar.get(ruleMatchesSoFar.size() - 1).getToPos() > startPos) {
            return ruleMatches;
        }
        String beforeSuggestionStr = "";
        String afterSuggestionStr = "";
        if (idx > 0 && tokens[idx].isWhitespaceBefore() && (prevWord = tokens[idx - 1].getToken()).length() > 0 && !StringUtils.containsAny((CharSequence)prevWord, (CharSequence[])new CharSequence[]{"0", "1", "2", "3", "4", "5", "6", "7", "8", "9"}) && MorfologikSpellerRule.getFrequency(this.speller1, prevWord) < 21) {
            int prevStartPos = tokens[idx - 1].getStartPos();
            sugg1a = prevWord.substring(0, prevWord.length() - 1);
            sugg1b = prevWord.substring(prevWord.length() - 1) + word;
            if (sugg1a.length() > 1 && sugg1b.length() > 2 && !this.isMisspelled(this.speller1, sugg1a) && !this.isMisspelled(this.speller1, sugg1b) && MorfologikSpellerRule.getFrequency(this.speller1, sugg1a) + MorfologikSpellerRule.getFrequency(this.speller1, sugg1b) > MorfologikSpellerRule.getFrequency(this.speller1, prevWord)) {
                ruleMatch = this.createWrongSplitMatch(sentence, ruleMatchesSoFar, startPos, word, sugg1a, sugg1b, prevStartPos);
                beforeSuggestionStr = prevWord + " ";
            }
            sugg2a = prevWord + word.charAt(0);
            sugg2b = word.substring(1);
            if (sugg2b.length() > 2 && !this.isMisspelled(this.speller1, sugg2a) && !this.isMisspelled(this.speller1, sugg2b)) {
                if (ruleMatch == null) {
                    if (MorfologikSpellerRule.getFrequency(this.speller1, sugg2a) + MorfologikSpellerRule.getFrequency(this.speller1, sugg2b) > MorfologikSpellerRule.getFrequency(this.speller1, prevWord)) {
                        ruleMatch = this.createWrongSplitMatch(sentence, ruleMatchesSoFar, startPos, word, sugg2a, sugg2b, prevStartPos);
                        beforeSuggestionStr = prevWord + " ";
                    }
                } else {
                    ruleMatch.addSuggestedReplacement((sugg2a + " " + sugg2b).trim());
                }
            }
            sugg = prevWord + word;
            if (word.equals(word.toLowerCase()) && !this.isMisspelled(this.speller1, sugg)) {
                if (ruleMatch == null) {
                    if (MorfologikSpellerRule.getFrequency(this.speller1, sugg) >= MorfologikSpellerRule.getFrequency(this.speller1, prevWord)) {
                        ruleMatch = new RuleMatch(this, sentence, prevStartPos, startPos + word.length(), this.messages.getString("spelling"), this.messages.getString("desc_spelling_short"));
                        beforeSuggestionStr = prevWord + " ";
                        ruleMatch.setSuggestedReplacement(sugg);
                    }
                } else {
                    ruleMatch.addSuggestedReplacement(sugg);
                }
            }
            if (ruleMatch != null && this.isMisspelled(this.speller1, prevWord)) {
                ruleMatches.add(ruleMatch);
                return ruleMatches;
            }
        }
        if (ruleMatch == null && idx < tokens.length - 1 && tokens[idx + 1].isWhitespaceBefore() && (nextWord = tokens[idx + 1].getToken()).length() > 0 && !StringUtils.containsAny((CharSequence)nextWord, (char[])new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9'}) && MorfologikSpellerRule.getFrequency(this.speller1, nextWord) < 21) {
            int nextStartPos = tokens[idx + 1].getStartPos();
            sugg1a = word.substring(0, word.length() - 1);
            sugg1b = word.substring(word.length() - 1) + nextWord;
            if (sugg1a.length() > 1 && sugg1b.length() > 2 && !this.isMisspelled(this.speller1, sugg1a) && !this.isMisspelled(this.speller1, sugg1b) && MorfologikSpellerRule.getFrequency(this.speller1, sugg1a) + MorfologikSpellerRule.getFrequency(this.speller1, sugg1b) > MorfologikSpellerRule.getFrequency(this.speller1, nextWord)) {
                ruleMatch = this.createWrongSplitMatch(sentence, ruleMatchesSoFar, nextStartPos, nextWord, sugg1a, sugg1b, startPos);
                afterSuggestionStr = " " + nextWord;
            }
            sugg2a = word + nextWord.charAt(0);
            sugg2b = nextWord.substring(1);
            if (sugg2b.length() > 2 && !this.isMisspelled(this.speller1, sugg2a) && !this.isMisspelled(this.speller1, sugg2b)) {
                if (ruleMatch == null) {
                    if (MorfologikSpellerRule.getFrequency(this.speller1, sugg2a) + MorfologikSpellerRule.getFrequency(this.speller1, sugg2b) > MorfologikSpellerRule.getFrequency(this.speller1, nextWord)) {
                        ruleMatch = this.createWrongSplitMatch(sentence, ruleMatchesSoFar, nextStartPos, nextWord, sugg2a, sugg2b, startPos);
                        afterSuggestionStr = " " + nextWord;
                    }
                } else {
                    ruleMatch.addSuggestedReplacement((sugg2a + " " + sugg2b).trim());
                }
            }
            sugg = word + nextWord;
            if (nextWord.equals(nextWord.toLowerCase()) && !this.isMisspelled(this.speller1, sugg)) {
                if (ruleMatch == null) {
                    if (MorfologikSpellerRule.getFrequency(this.speller1, sugg) >= MorfologikSpellerRule.getFrequency(this.speller1, nextWord)) {
                        ruleMatch = new RuleMatch(this, sentence, startPos, nextStartPos + nextWord.length(), this.messages.getString("spelling"), this.messages.getString("desc_spelling_short"));
                        afterSuggestionStr = " " + nextWord;
                        ruleMatch.setSuggestedReplacement(sugg);
                    }
                } else {
                    ruleMatch.addSuggestedReplacement(sugg);
                }
            }
            if (ruleMatch != null && this.isMisspelled(this.speller1, nextWord)) {
                ruleMatches.add(ruleMatch);
                return ruleMatches;
            }
        }
        int translationSuggestionCount = 0;
        boolean preventFurtherSuggestions = false;
        Translator translator = this.getTranslator(this.globalConfig);
        if (translator != null && ruleMatch == null && this.motherTongue != null && this.language.getShortCode().equals("en") && this.motherTongue.getShortCode().equals("de")) {
            Object nextWord2;
            ArrayList<PhraseToTranslate> phrasesToTranslate = new ArrayList<PhraseToTranslate>();
            if (idx + 1 < tokens.length && this.isMisspelled((String)(nextWord2 = tokens[idx + 1].getToken()))) {
                phrasesToTranslate.add(new PhraseToTranslate(word + " " + (String)nextWord2, tokens[idx + 1].getEndPos()));
            }
            phrasesToTranslate.add(new PhraseToTranslate(word, startPos + word.length()));
            for (PhraseToTranslate phraseToTranslate : phrasesToTranslate) {
                List<TranslationEntry> translations = translator.translate(phraseToTranslate.phrase, this.motherTongue.getShortCode(), this.language.getShortCode());
                if (translations.isEmpty()) continue;
                logger.info("Translated: {}", (Object)word);
                ruleMatch = new RuleMatch(this, sentence, startPos, phraseToTranslate.endPos, translator.getMessage());
                ruleMatch.setType(RuleMatch.Type.Hint);
                ruleMatch.setSuggestedReplacements(new ArrayList<String>());
                ArrayList<SuggestedReplacement> l = new ArrayList<SuggestedReplacement>();
                String prevWord2 = idx > 0 ? tokens[idx - 1].getToken() : null;
                for (TranslationEntry translation : translations) {
                    for (String s : translation.getL2()) {
                        String suffix = translator.getTranslationSuffix(s);
                        SuggestedReplacement repl = new SuggestedReplacement(translator.cleanTranslationForReplace(s, prevWord2), String.join((CharSequence)", ", translation.getL1()), suffix.isEmpty() ? null : suffix);
                        repl.setType(SuggestedReplacement.SuggestionType.Translation);
                        if (repl.getReplacement().equals(word)) continue;
                        l.add(repl);
                    }
                }
                List<SuggestedReplacement> mergedRepl = MorfologikSpellerRule.mergeSuggestionsWithSameTranslation(l);
                if (mergedRepl.isEmpty()) continue;
                ruleMatch.setSuggestedReplacementObjects(mergedRepl);
                translationSuggestionCount = mergedRepl.size();
                if (!phraseToTranslate.phrase.contains(" ")) break;
                preventFurtherSuggestions = true;
                break;
            }
        }
        if (ruleMatch == null) {
            ruleMatch = new RuleMatch(this, sentence, startPos, startPos + word.length(), this.messages.getString("spelling"), this.messages.getString("desc_spelling_short"));
        }
        boolean bl = fullResults = SuggestionsChanges.getInstance() != null && SuggestionsChanges.getInstance().getCurrentExperiment() != null && (Boolean)SuggestionsChanges.getInstance().getCurrentExperiment().parameters.getOrDefault("fullSuggestionCandidates", Boolean.FALSE) != false;
        if (this.userConfig == null || this.userConfig.getMaxSpellingSuggestions() == 0 || ruleMatchesSoFar.size() <= this.userConfig.getMaxSpellingSuggestions()) {
            if (translationSuggestionCount > 0) {
                List<SuggestedReplacement> prev = ruleMatch.getSuggestedReplacementObjects();
                ruleMatch = new RuleMatch(ruleMatch.getRule(), ruleMatch.getSentence(), ruleMatch.getFromPos(), ruleMatch.getToPos(), this.messages.getString("spelling") + " Translations to English are also offered.");
                ruleMatch.setSuggestedReplacementObjects(prev);
            }
            if (!preventFurtherSuggestions) {
                ruleMatch.setLazySuggestedReplacements(this.appendLazySuggestions(word, beforeSuggestionStr, afterSuggestionStr, fullResults, ruleMatch.getSuggestedReplacementObjects()));
            }
        } else {
            ruleMatch.setSuggestedReplacement(this.messages.getString("too_many_errors"));
        }
        ruleMatches.add(ruleMatch);
        return ruleMatches;
    }

    private Supplier<List<SuggestedReplacement>> appendLazySuggestions(String word, String beforeSuggestionStr, String afterSuggestionStr, boolean fullResults, List<SuggestedReplacement> prev) {
        return () -> {
            List<SuggestedReplacement> joined;
            try {
                List<SuggestedReplacement> fromSpeller = this.calcSpellerSuggestions(word, fullResults);
                joined = MorfologikSpellerRule.joinBeforeAfterSuggestions(fromSpeller, beforeSuggestionStr, afterSuggestionStr);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            return Lists.newArrayList((Iterable)Iterables.concat((Iterable)prev, joined));
        };
    }

    private List<SuggestedReplacement> calcSpellerSuggestions(String word, boolean fullResults) throws IOException {
        List<SuggestedReplacement> defaultSuggestions = SuggestedReplacement.convert(this.speller1.getSuggestionsFromDefaultDicts(word));
        List<SuggestedReplacement> userSuggestions = SuggestedReplacement.convert(this.speller1.getSuggestionsFromUserDicts(word));
        boolean onlyCaseDiffers = false;
        if (defaultSuggestions.size() > 0 && word.equalsIgnoreCase(defaultSuggestions.get(0).getReplacement())) {
            onlyCaseDiffers = true;
        }
        if (word.length() >= 3 && (onlyCaseDiffers || fullResults || defaultSuggestions.isEmpty())) {
            defaultSuggestions.addAll(SuggestedReplacement.convert(this.speller2.getSuggestionsFromDefaultDicts(word)));
            userSuggestions.addAll(SuggestedReplacement.convert(this.speller2.getSuggestionsFromUserDicts(word)));
            if (word.length() >= 5 && (fullResults || defaultSuggestions.isEmpty())) {
                defaultSuggestions.addAll(SuggestedReplacement.convert(this.speller3.getSuggestionsFromDefaultDicts(word)));
                userSuggestions.addAll(SuggestedReplacement.convert(this.speller3.getSuggestionsFromUserDicts(word)));
            }
        }
        List<SuggestedReplacement> topSuggestions = this.getAdditionalTopSuggestions(defaultSuggestions, word);
        topSuggestions.forEach(s -> s.setType(SuggestedReplacement.SuggestionType.Curated));
        defaultSuggestions.addAll(0, topSuggestions);
        defaultSuggestions.addAll(this.getAdditionalSuggestions(defaultSuggestions, word));
        if (defaultSuggestions.isEmpty() && userSuggestions.isEmpty()) {
            return Collections.emptyList();
        }
        defaultSuggestions = this.filterSuggestions(defaultSuggestions);
        userSuggestions = MorfologikSpellerRule.filterDupes(userSuggestions);
        defaultSuggestions = this.orderSuggestions(defaultSuggestions, word);
        return Lists.newArrayList((Iterable)Iterables.concat(userSuggestions, defaultSuggestions));
    }

    @NotNull
    private static List<SuggestedReplacement> mergeSuggestionsWithSameTranslation(List<SuggestedReplacement> l) {
        ArrayList<SuggestedReplacement> mergedRepl = new ArrayList<SuggestedReplacement>();
        HashSet<String> handledReplacements = new HashSet<String>();
        for (SuggestedReplacement repl : l) {
            List sameRepl = l.stream().filter(k -> k.getReplacement().equals(repl.getReplacement())).filter(k -> k.getSuffix() == null || k.getSuffix() != null && k.getSuffix().equals(repl.getSuffix())).collect(Collectors.toList());
            if (sameRepl.size() > 1) {
                if (handledReplacements.contains(repl.getReplacement())) continue;
                ArrayList<String> joinedRepls = new ArrayList<String>();
                for (SuggestedReplacement r : sameRepl) {
                    joinedRepls.add("* " + r.getShortDescription());
                }
                mergedRepl.add(new SuggestedReplacement(repl.getReplacement(), String.join((CharSequence)"\n", joinedRepls), repl.getSuffix()));
                handledReplacements.add(repl.getReplacement());
                continue;
            }
            mergedRepl.add(repl);
        }
        return mergedRepl;
    }

    @Nullable
    public Pattern tokenizingPattern() {
        return null;
    }

    protected List<SuggestedReplacement> orderSuggestions(List<SuggestedReplacement> suggestions, String word) {
        return suggestions;
    }

    protected void setCheckCompound(boolean checkCompound) {
        this.checkCompound = checkCompound;
    }

    protected void setCompoundRegex(String compoundRegex) {
        this.compoundRegex = Pattern.compile(compoundRegex);
    }

    protected static boolean isEmoji(String word) {
        if (word.length() > 1 && word.codePointCount(0, word.length()) != word.length()) {
            return EmojiManager.isOnlyEmojis((String)word);
        }
        return false;
    }

    @Override
    protected boolean ignoreWord(String word) throws IOException {
        return super.ignoreWord(word) || MorfologikSpellerRule.isEmoji(word);
    }

    private static List<SuggestedReplacement> joinBeforeAfterSuggestions(List<SuggestedReplacement> suggestionsList, String beforeSuggestionStr, String afterSuggestionStr) {
        ArrayList<SuggestedReplacement> newSuggestionsList = new ArrayList<SuggestedReplacement>();
        for (SuggestedReplacement suggestion : suggestionsList) {
            String str = suggestion.getReplacement();
            SuggestedReplacement newSuggestion = new SuggestedReplacement(suggestion);
            newSuggestion.setReplacement(beforeSuggestionStr + str + afterSuggestionStr);
            newSuggestionsList.add(newSuggestion);
        }
        return newSuggestionsList;
    }

    static class PhraseToTranslate {
        String phrase;
        int endPos;

        PhraseToTranslate(String phrase, int endPos) {
            this.phrase = phrase;
            this.endPos = endPos;
        }
    }
}

