/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.synthesis;

import gnu.trove.THashMap;
import gnu.trove.THashSet;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import java.util.Set;
import org.languagetool.tools.StringTools;

public final class ManualSynthesizer {
    private final Map<String, List<String>> mapping;
    private final Set<String> possibleTags;

    public ManualSynthesizer(InputStream inputStream) throws IOException {
        MappingAndTags mappingAndTags = this.loadMapping(inputStream, "utf8");
        this.mapping = mappingAndTags.mapping;
        this.possibleTags = Collections.unmodifiableSet(mappingAndTags.tags);
    }

    public Set<String> getPossibleTags() {
        return this.possibleTags;
    }

    public List<String> lookup(String lemma, String posTag) {
        return this.mapping.get(lemma + "|" + posTag);
    }

    private MappingAndTags loadMapping(InputStream inputStream, String encoding) throws IOException {
        MappingAndTags result = new MappingAndTags();
        try (Scanner scanner = new Scanner(inputStream, encoding);){
            while (scanner.hasNextLine()) {
                String line = scanner.nextLine();
                if (StringTools.isEmpty(line) || line.charAt(0) == '#') continue;
                String[] parts = (line = line.replaceFirst("#.*", "").trim()).split("\t");
                if (parts.length != 3) {
                    throw new IOException("Unknown line format when loading manual synthesizer dictionary: " + line);
                }
                String key = parts[1] + "|" + parts[2];
                if (!result.mapping.containsKey(key)) {
                    result.mapping.put(key, new ArrayList());
                }
                result.mapping.get(key).add(parts[0]);
                result.tags.add(parts[2]);
            }
        }
        return result;
    }

    static class MappingAndTags {
        Map<String, List<String>> mapping = new THashMap();
        Set<String> tags = new THashSet();

        MappingAndTags() {
        }
    }
}

