/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules.patterns;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.languagetool.AnalyzedToken;
import org.languagetool.AnalyzedTokenReadings;
import org.languagetool.JLanguageTool;
import org.languagetool.Language;
import org.languagetool.language.Demo;
import org.languagetool.rules.patterns.Match;
import org.languagetool.rules.patterns.MatchState;
import org.languagetool.synthesis.ManualSynthesizer;
import org.languagetool.synthesis.ManualSynthesizerAdapter;
import org.languagetool.synthesis.Synthesizer;
import org.languagetool.tagging.ManualTagger;
import org.languagetool.tagging.Tagger;
import org.languagetool.tokenizers.ManualTaggerAdapter;

public class MatchTest {
    private static final String TEST_DATA = "# some test data\ninflectedform11\tlemma1\tPOS1\ninflectedform121\tlemma1\tPOS2\ninflectedform122\tlemma1\tPOS2\ninflectedform123\tlemma1\tPOS3\ninflectedform2\tlemma2\tPOS1\n";
    private JLanguageTool languageTool;
    private Synthesizer synthesizer;
    private Tagger tagger;

    private AnalyzedTokenReadings[] getAnalyzedTokenReadings(String input) throws IOException {
        return this.languageTool.getAnalyzedSentence(input).getTokensWithoutWhitespace();
    }

    private AnalyzedTokenReadings getAnalyzedTokenReadings(String token, String posTag, String lemma) {
        return new AnalyzedTokenReadings(new AnalyzedToken(token, posTag, lemma), 0);
    }

    private Match getMatch(String posTag, String posTagReplace, Match.CaseConversion caseConversion) {
        return new Match(posTag, posTagReplace, true, null, null, caseConversion, false, false, Match.IncludeRange.NONE);
    }

    private Match getMatch(String posTag, String posTagReplace, Match.IncludeRange includeRange) {
        return new Match(posTag, posTagReplace, true, null, null, Match.CaseConversion.NONE, false, false, includeRange);
    }

    @Before
    public void setUp() throws Exception {
        this.tagger = new ManualTaggerAdapter(new ManualTagger((InputStream)new ByteArrayInputStream(TEST_DATA.getBytes(StandardCharsets.UTF_8))));
        Demo demo = new Demo(){

            @Override
            public String getName() {
                return "TEST";
            }

            public Synthesizer getSynthesizer() {
                return MatchTest.this.synthesizer;
            }

            @Override
            public Tagger getTagger() {
                return MatchTest.this.tagger;
            }
        };
        this.synthesizer = new ManualSynthesizerAdapter(new ManualSynthesizer((InputStream)new ByteArrayInputStream(TEST_DATA.getBytes(StandardCharsets.UTF_8))), demo);
        this.languageTool = new JLanguageTool((Language)demo);
    }

    @Test
    public void testStartUpper() throws Exception {
        Match match = this.getMatch("POS1", "POS2", Match.CaseConversion.STARTUPPER);
        MatchState state = match.createState(this.synthesizer, this.getAnalyzedTokenReadings("inflectedform11", "POS1", "Lemma1"));
        Assert.assertEquals((Object)"[Inflectedform121, Inflectedform122]", (Object)Arrays.toString(state.toFinalString(null)));
    }

    @Test
    public void testStartLower() throws Exception {
        Match match = this.getMatch("POS1", "POS2", Match.CaseConversion.STARTLOWER);
        MatchState state = match.createState(this.synthesizer, this.getAnalyzedTokenReadings("InflectedForm11", "POS1", "Lemma1"));
        Assert.assertEquals((Object)"[inflectedform121, inflectedform122]", (Object)Arrays.toString(state.toFinalString(null)));
    }

    @Test
    public void testAllUpper() throws Exception {
        Match match = this.getMatch("POS1", "POS2", Match.CaseConversion.ALLUPPER);
        MatchState state = match.createState(this.synthesizer, this.getAnalyzedTokenReadings("InflectedForm11", "POS1", "Lemma1"));
        Assert.assertEquals((Object)"[INFLECTEDFORM121, INFLECTEDFORM122]", (Object)Arrays.toString(state.toFinalString(null)));
    }

    @Test
    public void testAllLower() throws Exception {
        Match match = this.getMatch("POS1", "POS2", Match.CaseConversion.ALLLOWER);
        MatchState state = match.createState(this.synthesizer, this.getAnalyzedTokenReadings("InflectedForm11", "POS1", "Lemma1"));
        Assert.assertEquals((Object)"[inflectedform121, inflectedform122]", (Object)Arrays.toString(state.toFinalString(null)));
    }

    @Test
    public void testPreserveStartUpper() throws Exception {
        Match match = this.getMatch("POS1", "POS2", Match.CaseConversion.PRESERVE);
        MatchState state = match.createState(this.synthesizer, this.getAnalyzedTokenReadings("InflectedForm11", "POS1", "Lemma1"));
        Assert.assertEquals((Object)"[Inflectedform121, Inflectedform122]", (Object)Arrays.toString(state.toFinalString(null)));
    }

    @Test
    public void testStaticLemmaPreserveStartLower() throws Exception {
        Match match = this.getMatch("POS2", "POS1", Match.CaseConversion.PRESERVE);
        match.setLemmaString("lemma2");
        MatchState state = match.createState(this.synthesizer, this.getAnalyzedTokenReadings("inflectedform121", "POS2", "Lemma1"));
        Assert.assertEquals((Object)"[inflectedform2]", (Object)Arrays.toString(state.toFinalString(null)));
    }

    @Test
    public void testStaticLemmaPreserveStartUpper() throws Exception {
        Match match = this.getMatch("POS2", "POS1", Match.CaseConversion.PRESERVE);
        match.setLemmaString("lemma2");
        MatchState state = match.createState(this.synthesizer, this.getAnalyzedTokenReadings("InflectedForm121", "POS2", "Lemma1"));
        Assert.assertEquals((Object)"[Inflectedform2]", (Object)Arrays.toString(state.toFinalString(null)));
    }

    @Test
    public void testStaticLemmaPreserveAllUpper() throws Exception {
        Match match = this.getMatch("POS2", "POS1", Match.CaseConversion.PRESERVE);
        match.setLemmaString("lemma2");
        MatchState state = match.createState(this.synthesizer, this.getAnalyzedTokenReadings("INFLECTEDFORM121", "POS2", "Lemma1"));
        Assert.assertEquals((Object)"[INFLECTEDFORM2]", (Object)Arrays.toString(state.toFinalString(null)));
    }

    @Test
    public void testStaticLemmaPreserveMixed() throws Exception {
        Match match = this.getMatch("POS2", "POS1", Match.CaseConversion.PRESERVE);
        match.setLemmaString("lemma2");
        MatchState state = match.createState(this.synthesizer, this.getAnalyzedTokenReadings("infleCtedForm121", "POS2", "Lemma1"));
        Assert.assertEquals((Object)"[inflectedform2]", (Object)Arrays.toString(state.toFinalString(null)));
    }

    @Test
    public void testPreserveStartLower() throws Exception {
        Match match = this.getMatch("POS1", "POS2", Match.CaseConversion.PRESERVE);
        MatchState state = match.createState(this.synthesizer, this.getAnalyzedTokenReadings("inflectedForm11", "POS1", "Lemma1"));
        Assert.assertEquals((Object)"[inflectedform121, inflectedform122]", (Object)Arrays.toString(state.toFinalString(null)));
    }

    @Test
    public void testPreserveAllUpper() throws Exception {
        Match match = this.getMatch("POS1", "POS2", Match.CaseConversion.PRESERVE);
        MatchState state = match.createState(this.synthesizer, this.getAnalyzedTokenReadings("INFLECTEDFORM11", "POS1", "Lemma1"));
        Assert.assertEquals((Object)"[INFLECTEDFORM121, INFLECTEDFORM122]", (Object)Arrays.toString(state.toFinalString(null)));
    }

    @Test
    public void testPreserveMixed() throws Exception {
        Match match = this.getMatch("POS1", "POS2", Match.CaseConversion.PRESERVE);
        MatchState state = match.createState(this.synthesizer, this.getAnalyzedTokenReadings("inflecTedForm11", "POS1", "Lemma1"));
        Assert.assertEquals((Object)"[inflectedform121, inflectedform122]", (Object)Arrays.toString(state.toFinalString(null)));
    }

    @Test
    public void testPreserveNoneUpper() throws Exception {
        Match match = this.getMatch("POS1", "POS2", Match.CaseConversion.NONE);
        MatchState state = match.createState(this.synthesizer, this.getAnalyzedTokenReadings("INFLECTEDFORM11", "POS1", "Lemma1"));
        Assert.assertEquals((Object)"[inflectedform121, inflectedform122]", (Object)Arrays.toString(state.toFinalString(null)));
    }

    @Test
    public void testPreserveNoneLower() throws Exception {
        Match match = this.getMatch("POS1", "POS2", Match.CaseConversion.NONE);
        MatchState state = match.createState(this.synthesizer, this.getAnalyzedTokenReadings("inflectedform11", "POS1", "Lemma1"));
        Assert.assertEquals((Object)"[inflectedform121, inflectedform122]", (Object)Arrays.toString(state.toFinalString(null)));
    }

    @Test
    public void testPreserveNoneMixed() throws Exception {
        Match match = this.getMatch("POS1", "POS2", Match.CaseConversion.NONE);
        MatchState state = match.createState(this.synthesizer, this.getAnalyzedTokenReadings("inFLectedFOrm11", "POS1", "Lemma1"));
        Assert.assertEquals((Object)"[inflectedform121, inflectedform122]", (Object)Arrays.toString(state.toFinalString(null)));
    }

    @Test
    public void testSimpleIncludeFollowing() throws Exception {
        Match match = this.getMatch(null, null, Match.IncludeRange.FOLLOWING);
        MatchState state = match.createState(this.synthesizer, this.getAnalyzedTokenReadings("inflectedform11 inflectedform2 inflectedform122 inflectedform122"), 1, 3);
        Assert.assertEquals((Object)"[inflectedform2 inflectedform122]", (Object)Arrays.toString(state.toFinalString(null)));
    }

    @Test
    public void testPOSIncludeFollowing() throws Exception {
        Match match = this.getMatch("POS2", "POS33", Match.IncludeRange.FOLLOWING);
        MatchState state = match.createState(this.synthesizer, this.getAnalyzedTokenReadings("inflectedform11 inflectedform2 inflectedform122 inflectedform122"), 1, 3);
        Assert.assertEquals((Object)"[inflectedform2 inflectedform122]", (Object)Arrays.toString(state.toFinalString(null)));
    }

    @Test
    public void testIncludeAll() throws Exception {
        Match match = this.getMatch(null, null, Match.IncludeRange.ALL);
        MatchState state = match.createState(this.synthesizer, this.getAnalyzedTokenReadings("inflectedform11 inflectedform2 inflectedform122 inflectedform122"), 1, 3);
        Assert.assertEquals((Object)"[inflectedform11 inflectedform2 inflectedform122]", (Object)Arrays.toString(state.toFinalString(null)));
    }

    @Test
    public void testPOSIncludeAll() throws Exception {
        Match match = this.getMatch("POS1", "POS3", Match.IncludeRange.ALL);
        MatchState state = match.createState(this.synthesizer, this.getAnalyzedTokenReadings("inflectedform11 inflectedform2 inflectedform122 inflectedform122"), 1, 3);
        Assert.assertEquals((Object)"[inflectedform123 inflectedform2 inflectedform122]", (Object)Arrays.toString(state.toFinalString(null)));
    }
}

