/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules.spelling.morfologik;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.io.IOException;
import java.net.URL;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import morfologik.speller.Speller;
import morfologik.stemming.Dictionary;
import org.jetbrains.annotations.NotNull;
import org.languagetool.JLanguageTool;
import org.languagetool.databroker.ResourceDataBroker;
import org.languagetool.rules.spelling.morfologik.WeightedSuggestion;
import org.languagetool.tools.StringTools;

public class MorfologikSpeller {
    private static final LoadingCache<String, Dictionary> dictCache = CacheBuilder.newBuilder().expireAfterWrite(10L, TimeUnit.MINUTES).build((CacheLoader)new CacheLoader<String, Dictionary>(){

        public Dictionary load(@NotNull String fileInClassPath) throws IOException {
            ResourceDataBroker dataBroker = JLanguageTool.getDataBroker();
            if (dataBroker.resourceExists(fileInClassPath)) {
                return Dictionary.read((URL)dataBroker.getFromResourceDirAsUrl(fileInClassPath));
            }
            return Dictionary.read((Path)Paths.get(fileInClassPath, new String[0]));
        }
    });
    private final Dictionary dictionary;
    private final Speller speller;
    private final int maxEditDistance;

    public MorfologikSpeller(String fileInClassPath, int maxEditDistance) {
        this((Dictionary)dictCache.getUnchecked((Object)fileInClassPath), maxEditDistance);
    }

    public MorfologikSpeller(String fileInClassPath) throws IOException {
        this(fileInClassPath, 1);
    }

    MorfologikSpeller(Dictionary dictionary, int maxEditDistance) {
        if (maxEditDistance <= 0) {
            throw new RuntimeException("maxEditDistance must be > 0: " + maxEditDistance);
        }
        this.dictionary = dictionary;
        this.maxEditDistance = maxEditDistance;
        this.speller = new Speller(dictionary, maxEditDistance);
    }

    public boolean isMisspelled(String word) {
        return word.length() > 0 && !"LanguageTool".equals(word) && !"LanguageTooler".equals(word) && this.speller.isMisspelled(word);
    }

    public Speller getSpeller() {
        return this.speller;
    }

    public List<WeightedSuggestion> getSuggestions(String word) {
        ArrayList<WeightedSuggestion> suggestions = new ArrayList<WeightedSuggestion>();
        Speller speller = new Speller(this.dictionary, this.maxEditDistance);
        if (word.length() < 50) {
            ArrayList replacementCandidates = speller.findReplacementCandidates(word);
            for (Speller.CandidateData candidate : replacementCandidates) {
                suggestions.add(new WeightedSuggestion(candidate.getWord(), candidate.getDistance()));
            }
        }
        List runOnCandidates = speller.replaceRunOnWordCandidates(word);
        for (Speller.CandidateData runOnCandidate : runOnCandidates) {
            suggestions.add(new WeightedSuggestion(runOnCandidate.getWord(), runOnCandidate.getDistance()));
        }
        if (this.dictionary.metadata.isConvertingCase() && StringTools.startsWithUppercase(word)) {
            for (int i = 0; i < suggestions.size(); ++i) {
                int auxIndex;
                WeightedSuggestion sugg = (WeightedSuggestion)suggestions.get(i);
                String uppercaseFirst = StringTools.uppercaseFirstChar(sugg.getWord());
                if (uppercaseFirst.equals(word) || StringTools.isMixedCase(((WeightedSuggestion)suggestions.get(i)).getWord())) {
                    uppercaseFirst = sugg.getWord();
                }
                if ((auxIndex = this.getSuggestionIndex(suggestions, uppercaseFirst)) > i) {
                    suggestions.remove(auxIndex);
                }
                if (auxIndex > -1 && auxIndex < i) {
                    suggestions.remove(i);
                    --i;
                    continue;
                }
                suggestions.set(i, new WeightedSuggestion(uppercaseFirst, sugg.getWeight()));
            }
        }
        return suggestions;
    }

    private int getSuggestionIndex(List<WeightedSuggestion> suggestions, String uppercaseFirst) {
        int i = 0;
        for (WeightedSuggestion suggestion : suggestions) {
            if (suggestion.getWord().equals(uppercaseFirst)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public boolean convertsCase() {
        return this.speller.convertsCase();
    }

    public String toString() {
        return "dist=" + this.maxEditDistance;
    }

    public int getFrequency(String word) {
        int freq = this.speller.getFrequency((CharSequence)word);
        if (freq == 0 && !word.equals(word.toLowerCase())) {
            freq = this.speller.getFrequency((CharSequence)word.toLowerCase());
        }
        return freq;
    }
}

