/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool;

import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import org.languagetool.Experimental;
import org.languagetool.OutputStreamLogger;
import org.languagetool.RuleLogger;
import org.languagetool.RuleLoggerMessage;

@Experimental
public final class RuleLoggerManager {
    private static final RuleLoggerManager instance = new RuleLoggerManager();
    private final List<RuleLogger> loggerList = new LinkedList<RuleLogger>();
    private Level level = Level.ALL;

    public static RuleLoggerManager getInstance() {
        return instance;
    }

    public RuleLoggerManager() {
        this.addLogger(new OutputStreamLogger());
    }

    public void addLogger(RuleLogger logger) {
        this.loggerList.add(logger);
    }

    public void removeLogger(RuleLogger logger) {
        this.loggerList.remove(logger);
    }

    public void clearLoggers() {
        this.loggerList.clear();
    }

    public void log(RuleLoggerMessage message) {
        this.log(message, Level.INFO);
    }

    public void log(RuleLoggerMessage message, Level logLevel) {
        if (logLevel.intValue() >= this.level.intValue()) {
            this.loggerList.stream().filter(logger -> logger.filter(message)).forEach(logger -> logger.log(message, logLevel));
        }
    }

    public Level getLevel() {
        return this.level;
    }

    public void setLevel(Level level) {
        this.level = level;
    }
}

