/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.server;

import java.util.Calendar;
import java.util.HashMap;
import java.util.Map;
import org.languagetool.server.DatabaseLogEntry;
import org.languagetool.server.ServerTools;

public class DatabaseCacheStatsLogEntry
extends DatabaseLogEntry {
    private Calendar date;
    private Long server;
    private float cacheHits;

    public DatabaseCacheStatsLogEntry(Long server, float cacheHits) {
        this.server = server;
        this.cacheHits = cacheHits;
        this.date = Calendar.getInstance();
    }

    @Override
    public Map<Object, Object> getMapping() {
        HashMap<Object, Object> parameters = new HashMap<Object, Object>();
        parameters.put("date", ServerTools.getSQLDatetimeString(this.date));
        parameters.put("server", this.server);
        parameters.put("cache_hits", Float.valueOf(this.cacheHits));
        return parameters;
    }

    @Override
    public String getMappingIdentifier() {
        return "org.languagetool.server.LogMapper.cacheStats";
    }
}

