/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.tools;

import org.apache.commons.cli.BasicParser;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.jetbrains.annotations.NotNull;
import org.languagetool.tools.DictionaryBuilder;

class BuilderOptions {
    public static final String INFO_OPTION = "info";
    public static final String OUTPUT_OPTION = "o";
    public static final String INPUT_OPTION = "i";
    public static final String FREQ_OPTION = "freq";
    public static final String FREQ_HELP = "optional .xml file with a frequency wordlist, see http://wiki.languagetool.org/developing-a-tagger-dictionary";
    public static final String INFO_HELP = "*.info properties file, see http://wiki.languagetool.org/developing-a-tagger-dictionary";
    public static final String TAB_INPUT_HELP = "tab-separated plain-text dictionary file with format: wordform<tab>lemma<tab>postag";
    protected final Options options = new Options();

    BuilderOptions() {
        Option option = new Option(OUTPUT_OPTION, true, "output file");
        option.setRequired(true);
        this.options.addOption(option);
    }

    public void addOption(String opt, boolean hasArg, String description, boolean isRequired) {
        Option option = new Option(opt, hasArg, description);
        option.setRequired(isRequired);
        this.options.addOption(option);
    }

    @NotNull
    public CommandLine parseArguments(String[] args, Class<? extends DictionaryBuilder> clazz) throws ParseException {
        try {
            BasicParser parser = new BasicParser();
            CommandLine cmd = parser.parse(this.options, args);
            return cmd;
        }
        catch (ParseException e) {
            HelpFormatter formatter = new HelpFormatter();
            formatter.printHelp(clazz.getName(), this.options);
            System.exit(1);
            throw e;
        }
    }
}

