/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.ml.model;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import opennlp.tools.ml.model.AbstractDataIndexer;
import opennlp.tools.ml.model.ComparableEvent;
import opennlp.tools.ml.model.Event;
import opennlp.tools.ml.model.FileEventStream;
import opennlp.tools.util.ObjectStream;

public class TwoPassDataIndexer
extends AbstractDataIndexer {
    @Override
    public void index(ObjectStream<Event> eventStream) throws IOException {
        List<ComparableEvent> eventsToCompare;
        int cutoff = this.trainingParameters.getIntParameter("Cutoff", 5);
        boolean sort = this.trainingParameters.getBooleanParameter("sort", true);
        HashMap<String, Integer> predicateIndex = new HashMap<String, Integer>();
        this.display("Indexing events using cutoff of " + cutoff + "\n\n");
        this.display("\tComputing event counts...  ");
        File tmp = File.createTempFile("events", null);
        tmp.deleteOnExit();
        BufferedWriter osw = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(tmp), "UTF8"));
        int numEvents = this.computeEventCounts(eventStream, osw, predicateIndex, cutoff);
        this.display("done. " + numEvents + " events\n");
        this.display("\tIndexing...  ");
        try (FileEventStream fes = new FileEventStream(tmp);){
            eventsToCompare = this.index(numEvents, fes, predicateIndex);
        }
        predicateIndex = null;
        tmp.delete();
        this.display("done.\n");
        if (sort) {
            this.display("Sorting and merging events... ");
        } else {
            this.display("Collecting events... ");
        }
        this.sortAndMerge(eventsToCompare, sort);
        this.display("Done indexing.\n");
    }

    private int computeEventCounts(ObjectStream<Event> eventStream, Writer eventStore, Map<String, Integer> predicatesInOut, int cutoff) throws IOException {
        Event ev;
        HashMap<String, Integer> counter = new HashMap<String, Integer>();
        int eventCount = 0;
        HashSet<String> predicateSet = new HashSet<String>();
        while ((ev = eventStream.read()) != null) {
            ++eventCount;
            eventStore.write(FileEventStream.toLine(ev));
            String[] ec = ev.getContext();
            TwoPassDataIndexer.update(ec, predicateSet, counter, cutoff);
        }
        this.predCounts = new int[predicateSet.size()];
        int index = 0;
        for (String predicate : predicateSet) {
            this.predCounts[index] = (Integer)counter.get(predicate);
            predicatesInOut.put(predicate, index);
            ++index;
        }
        eventStore.close();
        return eventCount;
    }

    private List<ComparableEvent> index(int numEvents, ObjectStream<Event> es, Map<String, Integer> predicateIndex) throws IOException {
        Event ev;
        HashMap<String, Integer> omap = new HashMap<String, Integer>();
        int outcomeCount = 0;
        ArrayList<ComparableEvent> eventsToCompare = new ArrayList<ComparableEvent>(numEvents);
        ArrayList<Integer> indexedContext = new ArrayList<Integer>();
        while ((ev = es.read()) != null) {
            int ocID;
            String[] econtext = ev.getContext();
            String oc = ev.getOutcome();
            if (omap.containsKey(oc)) {
                ocID = (Integer)omap.get(oc);
            } else {
                ocID = outcomeCount++;
                omap.put(oc, ocID);
            }
            for (String pred : econtext) {
                if (!predicateIndex.containsKey(pred)) continue;
                indexedContext.add(predicateIndex.get(pred));
            }
            if (indexedContext.size() > 0) {
                int[] cons = new int[indexedContext.size()];
                for (int ci = 0; ci < cons.length; ++ci) {
                    cons[ci] = (Integer)indexedContext.get(ci);
                }
                ComparableEvent ce = new ComparableEvent(ocID, cons);
                eventsToCompare.add(ce);
            } else {
                this.display("Dropped event " + ev.getOutcome() + ":" + Arrays.asList(ev.getContext()) + "\n");
            }
            indexedContext.clear();
        }
        this.outcomeLabels = TwoPassDataIndexer.toIndexedStringArray(omap);
        this.predLabels = TwoPassDataIndexer.toIndexedStringArray(predicateIndex);
        return eventsToCompare;
    }
}

