/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules.spelling;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.stream.Collectors;
import org.languagetool.AnalyzedSentence;
import org.languagetool.AnalyzedTokenReadings;
import org.languagetool.Language;
import org.languagetool.UserConfig;
import org.languagetool.rules.ITSIssueType;
import org.languagetool.rules.Rule;
import org.languagetool.rules.RuleMatch;
import org.languagetool.rules.patterns.PatternToken;
import org.languagetool.rules.patterns.PatternTokenBuilder;
import org.languagetool.rules.spelling.CachingWordListLoader;
import org.languagetool.tagging.disambiguation.rules.DisambiguationPatternRule;
import org.languagetool.tokenizers.WordTokenizer;
import org.languagetool.tools.StringTools;

public abstract class SpellingCheckRule
extends Rule {
    public static final String LANGUAGETOOL = "LanguageTool";
    public static final String LANGUAGETOOL_FX = "LanguageToolFx";
    protected final Language language;
    protected final CachingWordListLoader wordListLoader = new CachingWordListLoader();
    private static final String SPELLING_IGNORE_FILE = "/hunspell/ignore.txt";
    private static final String SPELLING_FILE = "/hunspell/spelling.txt";
    private static final String SPELLING_PROHIBIT_FILE = "/hunspell/prohibit.txt";
    private static final Comparator<String> STRING_LENGTH_COMPARATOR = Comparator.comparingInt(String::length);
    private final Set<String> wordsToBeIgnored = new HashSet<String>();
    private final Set<String> wordsToBeProhibited = new HashSet<String>();
    private Map<String, Set<String>> wordsToBeIgnoredDictionary = new HashMap<String, Set<String>>();
    private Map<String, Set<String>> wordsToBeIgnoredDictionaryIgnoreCase = new HashMap<String, Set<String>>();
    private List<DisambiguationPatternRule> antiPatterns = new ArrayList<DisambiguationPatternRule>();
    private boolean considerIgnoreWords = true;
    private boolean convertsCase = false;

    public SpellingCheckRule(ResourceBundle messages, Language language, UserConfig userConfig) {
        super(messages);
        this.language = language;
        if (userConfig != null) {
            this.wordsToBeIgnored.addAll(userConfig.getAcceptedWords());
        }
        this.setLocQualityIssueType(ITSIssueType.Misspelling);
    }

    @Override
    public abstract String getId();

    @Override
    public abstract String getDescription();

    @Override
    public abstract RuleMatch[] match(AnalyzedSentence var1) throws IOException;

    @Override
    public boolean isDictionaryBasedSpellingRule() {
        return true;
    }

    public void addIgnoreTokens(List<String> tokens) {
        this.wordsToBeIgnored.addAll(tokens);
        this.updateIgnoredWordDictionary();
    }

    private void updateIgnoredWordDictionary() {
        this.wordsToBeIgnoredDictionary = this.wordsToBeIgnored.stream().collect(Collectors.groupingBy(s -> s.substring(0, 1), Collectors.toSet()));
        this.wordsToBeIgnoredDictionaryIgnoreCase = this.wordsToBeIgnored.stream().map(s -> s.toLowerCase()).collect(Collectors.groupingBy(s -> s.substring(0, 1), Collectors.toSet()));
    }

    public void setConsiderIgnoreWords(boolean considerIgnoreWords) {
        this.considerIgnoreWords = considerIgnoreWords;
    }

    protected List<String> getAdditionalTopSuggestions(List<String> suggestions, String word) throws IOException {
        ArrayList<String> moreSuggestions = new ArrayList<String>();
        if (("Languagetool".equals(word) || "languagetool".equals(word)) && !suggestions.contains(LANGUAGETOOL)) {
            moreSuggestions.add(LANGUAGETOOL);
        }
        return moreSuggestions;
    }

    protected List<String> getAdditionalSuggestions(List<String> suggestions, String word) {
        return Collections.emptyList();
    }

    protected boolean ignoreToken(AnalyzedTokenReadings[] tokens, int idx) throws IOException {
        ArrayList<String> words = new ArrayList<String>();
        for (AnalyzedTokenReadings token : tokens) {
            words.add(token.getToken());
        }
        return this.ignoreWord(words, idx);
    }

    protected boolean ignoreWord(String word) throws IOException {
        if (!this.considerIgnoreWords) {
            return false;
        }
        if (word.endsWith(".") && !this.wordsToBeIgnored.contains(word)) {
            return this.isIgnoredNoCase(word.substring(0, word.length() - 1));
        }
        return this.isIgnoredNoCase(word);
    }

    private boolean isIgnoredNoCase(String word) {
        return this.wordsToBeIgnored.contains(word) || this.convertsCase && this.wordsToBeIgnored.contains(word.toLowerCase(this.language.getLocale()));
    }

    protected boolean ignoreWord(List<String> words, int idx) throws IOException {
        return this.ignoreWord(words.get(idx));
    }

    public boolean isConvertsCase() {
        return this.convertsCase;
    }

    public void setConvertsCase(boolean convertsCase) {
        this.convertsCase = convertsCase;
    }

    protected boolean isUrl(String token) {
        return WordTokenizer.isUrl(token);
    }

    protected boolean isEMail(String token) {
        return WordTokenizer.isEMail(token);
    }

    protected void init() throws IOException {
        for (String ignoreWord : this.wordListLoader.loadWords(this.getIgnoreFileName())) {
            this.addIgnoreWords(ignoreWord);
        }
        for (String ignoreWord : this.wordListLoader.loadWords(this.getSpellingFileName())) {
            this.addIgnoreWords(ignoreWord);
        }
        this.updateIgnoredWordDictionary();
        for (String prohibitedWord : this.wordListLoader.loadWords(this.getProhibitFileName())) {
            this.addProhibitedWords(this.expandLine(prohibitedWord));
        }
    }

    protected String getIgnoreFileName() {
        return this.language.getShortCode() + SPELLING_IGNORE_FILE;
    }

    public String getSpellingFileName() {
        return this.language.getShortCode() + SPELLING_FILE;
    }

    protected String getProhibitFileName() {
        return this.language.getShortCode() + SPELLING_PROHIBIT_FILE;
    }

    protected boolean isProhibited(String word) {
        return this.wordsToBeProhibited.contains(word);
    }

    protected void filterSuggestions(List<String> suggestions) {
        suggestions.removeIf(suggestion -> this.isProhibited((String)suggestion));
    }

    protected void addIgnoreWords(String line) {
        if (line.contains(" ")) {
            List<String> tokens = this.language.getWordTokenizer().tokenize(line);
            ArrayList<PatternToken> patternTokens = new ArrayList<PatternToken>(tokens.size());
            for (String token : tokens) {
                if (token.trim().isEmpty()) continue;
                patternTokens.add(new PatternToken(token, true, false, false));
            }
            this.antiPatterns.add(new DisambiguationPatternRule("INTERNAL_ANTIPATTERN", "(no description)", this.language, patternTokens, null, null, DisambiguationPatternRule.DisambiguatorAction.IGNORE_SPELLING));
        } else {
            this.wordsToBeIgnored.add(line);
        }
    }

    protected void addProhibitedWords(List<String> words) {
        this.wordsToBeProhibited.addAll(words);
    }

    protected List<String> expandLine(String line) {
        return Collections.singletonList(line);
    }

    public void acceptPhrases(List<String> phrases) {
        ArrayList<List<PatternToken>> antiPatterns = new ArrayList<List<PatternToken>>();
        for (String phrase : phrases) {
            String[] parts = phrase.split(" ");
            ArrayList<PatternToken> patternTokens = new ArrayList<PatternToken>();
            int i = 0;
            boolean startsLowercase = false;
            for (String part : parts) {
                String uppercased;
                if (i == 0 && !(uppercased = StringTools.uppercaseFirstChar(part)).equals(part)) {
                    startsLowercase = true;
                }
                patternTokens.add(new PatternTokenBuilder().csToken(part).build());
                ++i;
            }
            antiPatterns.add(patternTokens);
            if (!startsLowercase) continue;
            antiPatterns.add(this.getTokensForSentenceStart(parts));
        }
        this.antiPatterns = this.makeAntiPatterns(antiPatterns, this.language);
    }

    private List<PatternToken> getTokensForSentenceStart(String[] parts) {
        ArrayList<PatternToken> ucPatternTokens = new ArrayList<PatternToken>();
        int j = 0;
        for (String part : parts) {
            if (j == 0) {
                String uppercased = StringTools.uppercaseFirstChar(part);
                ucPatternTokens.add(new PatternTokenBuilder().posRegex("SENT_START").build());
                ucPatternTokens.add(new PatternTokenBuilder().csToken(uppercased).build());
            } else {
                ucPatternTokens.add(new PatternTokenBuilder().csToken(part).build());
            }
            ++j;
        }
        return ucPatternTokens;
    }

    @Override
    public List<DisambiguationPatternRule> getAntiPatterns() {
        return this.antiPatterns;
    }

    protected int startsWithIgnoredWord(String word, boolean caseSensitive) {
        if (word.length() < 4) {
            return 0;
        }
        Optional<Object> match = Optional.empty();
        if (caseSensitive) {
            Set<String> subset = this.wordsToBeIgnoredDictionary.get(word.substring(0, 1));
            if (subset != null) {
                match = subset.stream().filter(s -> word.startsWith((String)s)).max(STRING_LENGTH_COMPARATOR);
            }
        } else {
            String lowerCaseWord = word.toLowerCase();
            Set<String> subset = this.wordsToBeIgnoredDictionaryIgnoreCase.get(lowerCaseWord.substring(0, 1));
            if (subset != null) {
                match = subset.stream().filter(s -> lowerCaseWord.startsWith((String)s)).max(STRING_LENGTH_COMPARATOR);
            }
        }
        return match.isPresent() ? ((String)match.get()).length() : 0;
    }
}

