/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.stream.Collectors;
import org.languagetool.AnalyzedSentence;
import org.languagetool.AnalyzedToken;
import org.languagetool.AnalyzedTokenReadings;
import org.languagetool.rules.Categories;
import org.languagetool.rules.Rule;
import org.languagetool.rules.RuleMatch;
import org.languagetool.rules.SimpleReplaceDataLoader;
import org.languagetool.tools.StringTools;

public abstract class AbstractSimpleReplaceRule
extends Rule {
    protected boolean ignoreTaggedWords = false;
    private boolean checkLemmas = true;

    protected abstract Map<String, List<String>> getWrongWords();

    protected static Map<String, List<String>> load(String path) {
        return new SimpleReplaceDataLoader().loadWords(path);
    }

    public boolean isCaseSensitive() {
        return true;
    }

    public Locale getLocale() {
        return Locale.getDefault();
    }

    public void setIgnoreTaggedWords() {
        this.ignoreTaggedWords = true;
    }

    public AbstractSimpleReplaceRule(ResourceBundle messages) throws IOException {
        super.setCategory(Categories.MISC.getCategory(messages));
    }

    @Override
    public String getId() {
        return "SIMPLE_REPLACE";
    }

    @Override
    public String getDescription() {
        return "Checks for wrong words/phrases";
    }

    public String getMessage(String tokenStr, List<String> replacements) {
        return tokenStr + " is not valid. Use: " + String.join((CharSequence)", ", replacements) + ".";
    }

    public String getShort() {
        return "Wrong word";
    }

    private String cleanup(String word) {
        return this.isCaseSensitive() ? word : word.toLowerCase(this.getLocale());
    }

    @Override
    public RuleMatch[] match(AnalyzedSentence sentence) {
        AnalyzedTokenReadings[] tokens;
        ArrayList<RuleMatch> ruleMatches = new ArrayList<RuleMatch>();
        for (AnalyzedTokenReadings tokenReadings : tokens = sentence.getTokensWithoutWhitespace()) {
            if ("SENT_START".equals(tokenReadings.getAnalyzedToken(0).getPOSTag()) || tokenReadings.isImmunized() || tokenReadings.isIgnoredBySpeller() || this.ignoreTaggedWords && this.isTagged(tokenReadings)) continue;
            List<RuleMatch> matchesForToken = this.findMatches(tokenReadings, sentence);
            ruleMatches.addAll(matchesForToken);
        }
        return this.toRuleMatchArray(ruleMatches);
    }

    protected List<RuleMatch> findMatches(AnalyzedTokenReadings tokenReadings, AnalyzedSentence sentence) {
        ArrayList<RuleMatch> ruleMatches = new ArrayList<RuleMatch>();
        String originalTokenStr = tokenReadings.getToken();
        String tokenString = this.cleanup(originalTokenStr);
        List<String> possibleReplacements = this.getWrongWords().get(originalTokenStr);
        if (possibleReplacements == null) {
            possibleReplacements = this.getWrongWords().get(tokenString);
        }
        if (possibleReplacements == null && this.checkLemmas) {
            possibleReplacements = new ArrayList<String>();
            ArrayList<String> lemmas = new ArrayList<String>();
            for (AnalyzedToken analyzedToken : tokenReadings.getReadings()) {
                String lemma = analyzedToken.getLemma();
                if (lemma == null || !this.getWrongWords().containsKey(lemma) || lemmas.contains(lemma)) continue;
                lemmas.add(this.cleanup(lemma));
            }
            for (String lemma : lemmas) {
                List<String> replacements = this.getWrongWords().get(lemma);
                if (replacements == null) continue;
                possibleReplacements.addAll(replacements);
            }
            possibleReplacements = possibleReplacements.stream().distinct().collect(Collectors.toList());
        }
        if (possibleReplacements != null && possibleReplacements.size() > 0) {
            ArrayList<String> replacements = new ArrayList<String>();
            replacements.addAll(possibleReplacements);
            if (replacements.contains(originalTokenStr)) {
                replacements.remove(originalTokenStr);
            }
            if (replacements.size() > 0) {
                RuleMatch potentialRuleMatch = this.createRuleMatch(tokenReadings, replacements, sentence);
                ruleMatches.add(potentialRuleMatch);
            }
        }
        return ruleMatches;
    }

    protected boolean isTagged(AnalyzedTokenReadings tokenReadings) {
        return tokenReadings.isTagged();
    }

    protected RuleMatch createRuleMatch(AnalyzedTokenReadings tokenReadings, List<String> replacements, AnalyzedSentence sentence) {
        String tokenString = tokenReadings.getToken();
        int pos = tokenReadings.getStartPos();
        RuleMatch potentialRuleMatch = new RuleMatch(this, sentence, pos, pos + tokenString.length(), this.getMessage(tokenString, replacements), this.getShort());
        if (!this.isCaseSensitive() && StringTools.startsWithUppercase(tokenString)) {
            for (int i = 0; i < replacements.size(); ++i) {
                replacements.set(i, StringTools.uppercaseFirstChar(replacements.get(i)));
            }
        }
        potentialRuleMatch.setSuggestedReplacements(replacements);
        return potentialRuleMatch;
    }

    public boolean isCheckLemmas() {
        return this.checkLemmas;
    }

    public void setCheckLemmas(boolean checkLemmas) {
        this.checkLemmas = checkLemmas;
    }
}

