/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jcs3.utils.serialization;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import org.apache.commons.jcs3.engine.behavior.IElementSerializer;
import org.apache.commons.jcs3.io.ObjectInputStreamClassLoaderAware;

public class StandardSerializer
implements IElementSerializer {
    @Override
    public <T> byte[] serialize(T obj) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try (ObjectOutputStream oos = new ObjectOutputStream(baos);){
            oos.writeUnshared(obj);
        }
        return baos.toByteArray();
    }

    @Override
    public <T> T deSerialize(byte[] data, ClassLoader loader) throws IOException, ClassNotFoundException {
        try (ByteArrayInputStream bais = new ByteArrayInputStream(data);){
            Object object;
            try (ObjectInputStreamClassLoaderAware ois = new ObjectInputStreamClassLoaderAware(bais, loader);){
                Object readObject;
                object = readObject = ois.readObject();
            }
            return (T)object;
        }
    }
}

