/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.tagging.presets;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.swing.JLabel;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.FilterModel;
import org.openstreetmap.josm.data.osm.INode;
import org.openstreetmap.josm.data.osm.IRelation;
import org.openstreetmap.josm.data.osm.IWay;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Tag;
import org.openstreetmap.josm.data.preferences.sources.ValidatorPrefHelper;
import org.openstreetmap.josm.data.validation.OsmValidator;
import org.openstreetmap.josm.data.validation.TestError;
import org.openstreetmap.josm.data.validation.tests.MapCSSTagChecker;
import org.openstreetmap.josm.data.validation.tests.OpeningHourTest;
import org.openstreetmap.josm.data.validation.tests.TagChecker;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.progress.NullProgressMonitor;
import org.openstreetmap.josm.gui.tagging.presets.TaggingPreset;
import org.openstreetmap.josm.gui.util.GuiHelper;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Logging;
import org.openstreetmap.josm.tools.SubclassFilteredCollection;
import org.openstreetmap.josm.tools.Utils;

interface TaggingPresetValidation {
    public static void validateAsync(OsmPrimitive original, JLabel validationLabel, List<Tag> changedTags) {
        OsmPrimitive primitive = TaggingPresetValidation.applyChangedTags(original, changedTags);
        MainApplication.worker.execute(() -> TaggingPresetValidation.validate(primitive, validationLabel));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void validate(OsmPrimitive primitive, JLabel validationLabel) {
        try {
            MapCSSTagChecker mapCSSTagChecker = OsmValidator.getTest(MapCSSTagChecker.class);
            OpeningHourTest openingHourTest = OsmValidator.getTest(OpeningHourTest.class);
            TagChecker tagChecker = OsmValidator.getTest(TagChecker.class);
            tagChecker.startTest(NullProgressMonitor.INSTANCE);
            OsmValidator.initializeTests(Arrays.asList(mapCSSTagChecker, openingHourTest, tagChecker));
            ArrayList<TestError> errors = new ArrayList<TestError>();
            openingHourTest.addErrorsForPrimitive(primitive, errors);
            errors.addAll(mapCSSTagChecker.getErrorsForPrimitive(primitive, ValidatorPrefHelper.PREF_OTHER.get()));
            tagChecker.check(primitive);
            errors.addAll(tagChecker.getErrors());
            boolean visible = !errors.isEmpty();
            String toolTipText = "<html>" + Utils.joinAsHtmlUnorderedList(Utils.transform(errors, e -> e.getDescription() == null ? e.getMessage() : I18n.tr("{0} ({1})", e.getMessage(), e.getDescription())));
            GuiHelper.runInEDTAndWait(() -> {
                validationLabel.setVisible(visible);
                validationLabel.setToolTipText(toolTipText);
            });
        }
        catch (Exception e2) {
            Logging.warn("Failed to validate {0}", primitive);
            Logging.warn(e2);
        }
        finally {
            primitive.getDataSet().clear();
        }
    }

    public static OsmPrimitive applyChangedTags(OsmPrimitive original, List<Tag> changedTags) {
        DataSet ds = new DataSet();
        Collection<OsmPrimitive> primitives = FilterModel.getAffectedPrimitives(Collections.singleton(original));
        OsmPrimitive primitive = ds.clonePrimitives(new SubclassFilteredCollection(primitives, INode.class::isInstance), new SubclassFilteredCollection(primitives, IWay.class::isInstance), new SubclassFilteredCollection(primitives, IRelation.class::isInstance)).get(original);
        Command command = TaggingPreset.createCommand(Collections.singleton(primitive), changedTags);
        if (command != null) {
            command.executeCommand();
        }
        return primitive;
    }
}

