/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.actions.mapmode;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.openstreetmap.josm.actions.mapmode.MapMode;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.command.DeleteCommand;
import org.openstreetmap.josm.data.UndoRedoHandler;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.PrimitiveId;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.data.osm.WaySegment;
import org.openstreetmap.josm.gui.ExtendedDialog;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.MapFrame;
import org.openstreetmap.josm.gui.MapView;
import org.openstreetmap.josm.gui.dialogs.relation.RelationDialogManager;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.gui.layer.MainLayerManager;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.gui.util.HighlightHelper;
import org.openstreetmap.josm.gui.util.ModifierExListener;
import org.openstreetmap.josm.spi.preferences.Config;
import org.openstreetmap.josm.tools.CheckParameterUtil;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.Shortcut;

public class DeleteAction
extends MapMode
implements ModifierExListener {
    private MouseEvent oldEvent;
    private transient WaySegment oldHighlightedWaySegment;
    private static final HighlightHelper HIGHLIGHT_HELPER = new HighlightHelper();
    private boolean drawTargetHighlight;

    public DeleteAction() {
        super(I18n.tr("Delete Mode", new Object[0]), "delete", I18n.tr("Delete nodes or ways.", new Object[0]), Shortcut.registerShortcut("mapmode:delete", I18n.tr("Mode: {0}", I18n.tr("Delete", new Object[0])), 127, 5006), ImageProvider.getCursor("normal", "delete"));
    }

    @Override
    public void enterMode() {
        super.enterMode();
        if (!this.isEnabled()) {
            return;
        }
        this.drawTargetHighlight = Config.getPref().getBoolean("draw.target-highlight", true);
        MapFrame map = MainApplication.getMap();
        map.mapView.addMouseListener(this);
        map.mapView.addMouseMotionListener(this);
        map.keyDetector.addModifierExListener(this);
    }

    @Override
    public void exitMode() {
        super.exitMode();
        MapFrame map = MainApplication.getMap();
        map.mapView.removeMouseListener(this);
        map.mapView.removeMouseMotionListener(this);
        map.keyDetector.removeModifierExListener(this);
        this.removeHighlighting();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        super.actionPerformed(e);
        this.doActionPerformed(e);
    }

    public void doActionPerformed(ActionEvent e) {
        MainLayerManager lm = MainApplication.getLayerManager();
        OsmDataLayer editLayer = lm.getEditLayer();
        if (editLayer == null) {
            return;
        }
        this.updateKeyModifiers(e);
        Command c = this.ctrl ? DeleteCommand.deleteWithReferences(lm.getEditDataSet().getSelected()) : DeleteCommand.delete(lm.getEditDataSet().getSelected(), !this.alt);
        if (c != null) {
            UndoRedoHandler.getInstance().add(c);
            if (DeleteAction.changesHiddenWay(c)) {
                ConfirmDeleteDialog ed = new ConfirmDeleteDialog();
                ed.setContent(I18n.tr("Are you sure that you want to delete elements with attached ways that are hidden by filters?", new Object[0]));
                ed.toggleEnable("deletedHiddenElements");
                if (ed.showDialog().getValue() != 1) {
                    UndoRedoHandler.getInstance().undo(1);
                    return;
                }
            }
            lm.getEditDataSet().setSelected(new PrimitiveId[0]);
        }
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        this.mouseMoved(e);
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        this.oldEvent = e;
        this.giveUserFeedback(e);
    }

    private void removeHighlighting() {
        HIGHLIGHT_HELPER.clear();
        DataSet ds = this.getLayerManager().getEditDataSet();
        if (ds != null) {
            ds.clearHighlightedWaySegments();
        }
    }

    private void addHighlighting(MouseEvent e, int modifiers) {
        if (!this.drawTargetHighlight) {
            return;
        }
        DeleteParameters parameters = this.getDeleteParameters(e, modifiers);
        if (parameters.mode == DeleteMode.segment) {
            this.repaintIfRequired(Collections.emptySet(), parameters.nearestSegment);
        } else {
            Command delCmd = this.buildDeleteCommands(e, modifiers, true);
            this.repaintIfRequired((Set<OsmPrimitive>)(delCmd == null ? Collections.emptySet() : new HashSet<OsmPrimitive>(delCmd.getParticipatingPrimitives())), null);
        }
    }

    private void repaintIfRequired(Set<OsmPrimitive> newHighlights, WaySegment newHighlightedWaySegment) {
        boolean needsRepaint = false;
        OsmDataLayer editLayer = this.getLayerManager().getEditLayer();
        if (newHighlightedWaySegment == null && this.oldHighlightedWaySegment != null) {
            if (editLayer != null) {
                editLayer.data.clearHighlightedWaySegments();
                needsRepaint = true;
            }
            this.oldHighlightedWaySegment = null;
        } else if (newHighlightedWaySegment != null && !newHighlightedWaySegment.equals(this.oldHighlightedWaySegment)) {
            if (editLayer != null) {
                editLayer.data.setHighlightedWaySegments(Collections.singleton(newHighlightedWaySegment));
                needsRepaint = true;
            }
            this.oldHighlightedWaySegment = newHighlightedWaySegment;
        }
        if ((needsRepaint |= HIGHLIGHT_HELPER.highlightOnly(newHighlights)) && editLayer != null) {
            editLayer.invalidate();
        }
    }

    private void updateCursor(MouseEvent e, int modifiers) {
        if (!MainApplication.isDisplayingMapView()) {
            return;
        }
        MapFrame map = MainApplication.getMap();
        if (!map.mapView.isActiveLayerVisible() || e == null) {
            return;
        }
        DeleteParameters parameters = this.getDeleteParameters(e, modifiers);
        map.mapView.setNewCursor(parameters.mode.cursor(), (Object)this);
    }

    private void giveUserFeedback(MouseEvent e, int modifiers) {
        this.updateCursor(e, modifiers);
        this.addHighlighting(e, modifiers);
    }

    private void giveUserFeedback(MouseEvent e) {
        this.giveUserFeedback(e, e.getModifiersEx());
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (e.getButton() != 1) {
            return;
        }
        MapFrame map = MainApplication.getMap();
        if (!map.mapView.isActiveLayerVisible()) {
            return;
        }
        map.mapView.requestFocus();
        Command c = this.buildDeleteCommands(e, e.getModifiersEx(), false);
        if (c != null) {
            UndoRedoHandler.getInstance().add(c);
        }
        this.getLayerManager().getEditDataSet().setSelected(new PrimitiveId[0]);
        this.giveUserFeedback(e);
    }

    @Override
    public String getModeHelpText() {
        return I18n.tr("Click to delete. Shift: delete way segment. Alt: do not delete unused nodes when deleting a way. Ctrl: delete referring objects.", new Object[0]);
    }

    @Override
    public boolean layerIsSupported(Layer l) {
        return this.isEditableDataLayer(l);
    }

    @Override
    protected void updateEnabledState() {
        this.setEnabled(MainApplication.isDisplayingMapView() && MainApplication.getMap().mapView.isActiveLayerDrawable());
    }

    public static void deleteRelation(OsmDataLayer layer, Relation toDelete) {
        DeleteAction.deleteRelations(layer, Collections.singleton(toDelete));
    }

    public static void deleteRelations(OsmDataLayer layer, Collection<Relation> toDelete) {
        CheckParameterUtil.ensureParameterNotNull(layer, "layer");
        CheckParameterUtil.ensureParameterNotNull(toDelete, "toDelete");
        Command cmd = DeleteCommand.delete(toDelete);
        if (cmd != null) {
            List<Relation> toUnselect = toDelete.stream().filter(OsmPrimitive::isSelected).collect(Collectors.toList());
            UndoRedoHandler.getInstance().add(cmd);
            toDelete.forEach(relation -> RelationDialogManager.getRelationDialogManager().close(layer, (Relation)relation));
            toUnselect.forEach(xva$0 -> layer.data.toggleSelected((PrimitiveId)xva$0));
        }
    }

    private DeleteParameters getDeleteParameters(MouseEvent e, int modifiers) {
        this.updateKeyModifiersEx(modifiers);
        DeleteParameters result = new DeleteParameters();
        MapView mapView = MainApplication.getMap().mapView;
        result.nearestNode = mapView.getNearestNode(e.getPoint(), OsmPrimitive::isSelectable);
        if (result.nearestNode == null) {
            result.nearestSegment = mapView.getNearestWaySegment(e.getPoint(), OsmPrimitive::isSelectable);
            if (result.nearestSegment != null) {
                if (this.shift) {
                    result.mode = DeleteMode.segment;
                } else if (this.ctrl) {
                    result.mode = DeleteMode.way_with_references;
                } else {
                    result.mode = this.alt ? DeleteMode.way : DeleteMode.way_with_nodes;
                }
            } else {
                result.mode = DeleteMode.none;
            }
        } else if (this.ctrl) {
            result.mode = DeleteMode.node_with_references;
        } else {
            result.mode = DeleteMode.node;
        }
        return result;
    }

    private Command buildDeleteCommands(MouseEvent e, int modifiers, boolean silent) {
        DeleteParameters parameters = this.getDeleteParameters(e, modifiers);
        switch (parameters.mode.ordinal()) {
            case 2: {
                return DeleteCommand.delete(Collections.singleton(parameters.nearestNode), false, silent);
            }
            case 3: {
                return DeleteCommand.deleteWithReferences(Collections.singleton(parameters.nearestNode), silent);
            }
            case 1: {
                return DeleteCommand.deleteWaySegment(parameters.nearestSegment);
            }
            case 4: {
                return DeleteCommand.delete(Collections.singleton((Way)parameters.nearestSegment.getWay()), false, silent);
            }
            case 6: {
                return DeleteCommand.delete(Collections.singleton((Way)parameters.nearestSegment.getWay()), true, silent);
            }
            case 5: {
                return DeleteCommand.deleteWithReferences(Collections.singleton((Way)parameters.nearestSegment.getWay()), true);
            }
        }
        return null;
    }

    @Override
    public void modifiersExChanged(int modifiers) {
        if (this.oldEvent == null) {
            return;
        }
        this.giveUserFeedback(this.oldEvent, modifiers);
    }

    private static boolean changesHiddenWay(Command c) {
        return c.getParticipatingPrimitives().stream().anyMatch(OsmPrimitive::isDisabledAndHidden);
    }

    static class ConfirmDeleteDialog
    extends ExtendedDialog {
        ConfirmDeleteDialog() {
            super((Component)MainApplication.getMainFrame(), I18n.tr("Delete elements", new Object[0]), I18n.tr("Delete them", new Object[0]), I18n.tr("Undo delete", new Object[0]));
            this.setButtonIcons("dialogs/delete", "cancel");
            this.setCancelButton(2);
        }
    }

    private static class DeleteParameters {
        private DeleteMode mode;
        private Node nearestNode;
        private WaySegment nearestSegment;

        private DeleteParameters() {
        }
    }

    static enum DeleteMode {
        none("delete"),
        segment("delete_segment"),
        node("delete_node"),
        node_with_references("delete_node"),
        way("delete_way_only"),
        way_with_references("delete_way_normal"),
        way_with_nodes("delete_way_node_only");

        private final Cursor c;

        private DeleteMode(String cursorName) {
            this.c = ImageProvider.getCursor("normal", cursorName);
        }

        public Cursor cursor() {
            return this.c;
        }
    }
}

