/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.actions;

import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import java.util.stream.Collectors;
import org.openstreetmap.josm.actions.CombineWayAction;
import org.openstreetmap.josm.actions.CreateMultipolygonAction;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.actions.ReverseWayAction;
import org.openstreetmap.josm.command.AddCommand;
import org.openstreetmap.josm.command.ChangeMembersCommand;
import org.openstreetmap.josm.command.ChangeNodesCommand;
import org.openstreetmap.josm.command.ChangePropertyCommand;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.command.DeleteCommand;
import org.openstreetmap.josm.command.SequenceCommand;
import org.openstreetmap.josm.command.SplitWayCommand;
import org.openstreetmap.josm.data.UndoRedoHandler;
import org.openstreetmap.josm.data.coor.EastNorth;
import org.openstreetmap.josm.data.osm.AbstractPrimitive;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.NodePositionComparator;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.RelationMember;
import org.openstreetmap.josm.data.osm.TagCollection;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.gui.Notification;
import org.openstreetmap.josm.gui.conflict.tags.CombinePrimitiveResolverDialog;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.tools.Geometry;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.JosmRuntimeException;
import org.openstreetmap.josm.tools.Logging;
import org.openstreetmap.josm.tools.Pair;
import org.openstreetmap.josm.tools.Shortcut;
import org.openstreetmap.josm.tools.UserCancelException;
import org.openstreetmap.josm.tools.Utils;

public class JoinAreasAction
extends JosmAction {
    private final transient LinkedList<Command> executedCmds = new LinkedList();
    private final transient LinkedList<Command> cmds = new LinkedList();
    private DataSet ds;
    private final transient List<Relation> addedRelations = new LinkedList<Relation>();
    private final boolean addUndoRedo;

    public JoinAreasAction() {
        this(true);
    }

    public JoinAreasAction(boolean addShortcutToolbarAdapters) {
        super(I18n.tr("Join overlapping Areas", new Object[0]), "joinareas", I18n.tr("Joins areas that overlap each other", new Object[0]), addShortcutToolbarAdapters ? Shortcut.registerShortcut("tools:joinareas", I18n.tr("Tools: {0}", I18n.tr("Join overlapping Areas", new Object[0])), 74, 5005) : null, addShortcutToolbarAdapters, null, addShortcutToolbarAdapters);
        this.addUndoRedo = addShortcutToolbarAdapters;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.join(this.getLayerManager().getEditDataSet().getSelectedWays());
        this.clearFields();
    }

    private void clearFields() {
        this.ds = null;
        this.cmds.clear();
        this.addedRelations.clear();
    }

    public void join(Collection<Way> ways) {
        this.clearFields();
        if (ways.isEmpty()) {
            new Notification(I18n.tr("Please select at least one closed way that should be joined.", new Object[0])).setIcon(1).show();
            return;
        }
        ArrayList<Node> allNodes = new ArrayList<Node>();
        for (Way way : ways) {
            if (!way.isClosed()) {
                new Notification(I18n.tr("One of the selected ways is not closed and therefore cannot be joined.", new Object[0])).setIcon(1).show();
                return;
            }
            allNodes.addAll(way.getNodes());
        }
        boolean ok = JoinAreasAction.checkAndConfirmOutlyingOperation("joinarea", I18n.tr("Join area confirmation", new Object[0]), I18n.trn("The selected way has nodes which can have other referrers not yet downloaded.", "The selected ways have nodes which can have other referrers not yet downloaded.", ways.size(), new Object[0]) + "<br/>" + I18n.tr("This can lead to nodes being deleted accidentally.", new Object[0]) + "<br/>" + I18n.tr("Are you really sure to continue?", new Object[0]) + I18n.tr("Please abort if you are not sure", new Object[0]), I18n.tr("The selected area is incomplete. Continue?", new Object[0]), allNodes, null);
        if (!ok) {
            return;
        }
        List<Multipolygon> areas = JoinAreasAction.collectMultipolygons(ways);
        if (areas == null) {
            return;
        }
        if (!this.testJoin(areas)) {
            new Notification(I18n.tr("No intersection found. Nothing was changed.", new Object[0])).setIcon(1).show();
            return;
        }
        if (!this.resolveTagConflicts(areas)) {
            return;
        }
        try {
            JoinAreasResult result = this.joinAreas(areas);
            if (result.hasChanges) {
                for (Relation r : this.addedRelations) {
                    this.cmds.addAll(CreateMultipolygonAction.removeTagsFromWaysIfNeeded(r));
                }
                this.commitCommands(I18n.tr("Move tags from ways to relations", new Object[0]));
                this.commitExecuted();
                if (result.polygons != null && this.ds != null) {
                    ArrayList<Way> allWays = new ArrayList<Way>();
                    for (Multipolygon pol : result.polygons) {
                        allWays.add(pol.outerWay);
                        allWays.addAll(pol.innerWays);
                    }
                    this.ds.setSelected(allWays);
                }
            } else {
                new Notification(I18n.tr("No intersection found. Nothing was changed.", new Object[0])).setIcon(1).show();
            }
        }
        catch (UserCancelException exception) {
            Logging.trace(exception);
            this.tryUndo();
        }
        catch (IllegalArgumentException | JosmRuntimeException exception) {
            Logging.trace(exception);
            this.tryUndo();
            throw exception;
        }
    }

    private void tryUndo() {
        this.cmds.clear();
        if (!this.executedCmds.isEmpty()) {
            this.ds = this.executedCmds.getFirst().getAffectedDataSet();
            this.ds.update(() -> {
                while (!this.executedCmds.isEmpty()) {
                    this.executedCmds.removeLast().undoCommand();
                }
            });
        }
    }

    private boolean testJoin(List<Multipolygon> areas) {
        ArrayList<Way> allStartingWays = new ArrayList<Way>();
        for (Multipolygon area : areas) {
            allStartingWays.add(area.outerWay);
            allStartingWays.addAll(area.innerWays);
        }
        Set<Node> nodes = Geometry.addIntersections(allStartingWays, true, this.cmds);
        return !nodes.isEmpty();
    }

    private JoinAreasResult joinAreas(List<Multipolygon> areas) throws UserCancelException {
        Command deleteCmd;
        Object splitWays;
        Set<Node> nodes;
        if (!areas.isEmpty()) {
            this.ds = areas.get(0).getOuterWay().getDataSet();
        }
        boolean hasChanges = false;
        ArrayList<Way> allStartingWays = new ArrayList<Way>();
        ArrayList innerStartingWays = new ArrayList();
        ArrayList<Way> outerStartingWays = new ArrayList<Way>();
        for (Multipolygon area : areas) {
            outerStartingWays.add(area.outerWay);
            innerStartingWays.addAll(area.innerWays);
        }
        allStartingWays.addAll(innerStartingWays);
        allStartingWays.addAll(outerStartingWays);
        boolean removedDuplicates = this.removeDuplicateNodes(allStartingWays);
        if (removedDuplicates) {
            hasChanges = true;
            LinkedHashSet oldNodes = new LinkedHashSet();
            allStartingWays.forEach(w -> oldNodes.addAll(w.getNodes()));
            this.commitCommands(I18n.marktr("Removed duplicate nodes"));
            List toRemove = oldNodes.stream().filter(n -> (n.isNew() || !n.isOutsideDownloadArea()) && !n.hasKeys() && n.getReferrers().isEmpty()).collect(Collectors.toList());
            if (!toRemove.isEmpty()) {
                this.cmds.add(new DeleteCommand(toRemove));
                this.commitCommands(I18n.marktr("Removed now unreferrenced nodes"));
            }
        }
        if ((nodes = Geometry.addIntersections(allStartingWays, false, this.cmds)).isEmpty()) {
            return new JoinAreasResult(hasChanges, null);
        }
        this.commitCommands(I18n.marktr("Added node on all intersections"));
        ArrayList<RelationRole> relations = new ArrayList<RelationRole>();
        for (Way way : allStartingWays) {
            relations.addAll(this.removeFromAllRelations(way));
        }
        boolean warnAboutRelations = !relations.isEmpty() && allStartingWays.size() > 1;
        ArrayList<WayInPolygon> preparedWays = new ArrayList<WayInPolygon>();
        HashMap<Node, Way> oldestWayMap = new HashMap<Node, Way>();
        for (Way way : outerStartingWays) {
            splitWays = this.splitWayOnNodes(way, nodes, oldestWayMap);
            preparedWays.addAll(JoinAreasAction.markWayInsideSide(splitWays, false));
        }
        for (Way way : innerStartingWays) {
            splitWays = this.splitWayOnNodes(way, nodes, oldestWayMap);
            preparedWays.addAll(JoinAreasAction.markWayInsideSide(splitWays, true));
        }
        ArrayList<Way> discardedWays = new ArrayList<Way>();
        List<AssembledPolygon> boundaries = JoinAreasAction.findBoundaryPolygons(preparedWays, discardedWays);
        if (discardedWays.stream().anyMatch(w -> !w.isNew())) {
            for (AssembledPolygon ring : boundaries) {
                for (int k = 0; k < ring.ways.size(); ++k) {
                    Iterator ringWay = ring.ways.get(k);
                    Way older = this.keepOlder(((WayInPolygon)((Object)ringWay)).way, oldestWayMap, discardedWays);
                    if (((WayInPolygon)((Object)ringWay)).way == older) continue;
                    WayInPolygon repl = new WayInPolygon(older, ((WayInPolygon)((Object)ringWay)).insideToTheRight);
                    ring.ways.set(k, repl);
                }
            }
            this.commitCommands(I18n.marktr("Keep older versions"));
        }
        List<AssembledMultipolygon> preparedPolygons = JoinAreasAction.findPolygons(boundaries);
        ArrayList<Multipolygon> polygons = new ArrayList<Multipolygon>();
        LinkedHashSet<Relation> relationsToDelete = new LinkedHashSet<Relation>();
        for (AssembledMultipolygon pol : preparedPolygons) {
            Multipolygon resultPol = this.joinPolygon(pol);
            RelationRole ownMultipolygonRelation = this.addOwnMultipolygonRelation(resultPol.innerWays);
            this.fixRelations(relations, resultPol.outerWay, ownMultipolygonRelation, relationsToDelete);
            this.stripTags(resultPol.innerWays);
            polygons.add(resultPol);
        }
        this.commitCommands(I18n.marktr("Assemble new polygons"));
        for (Relation rel : relationsToDelete) {
            this.cmds.add(new DeleteCommand(rel));
        }
        this.commitCommands(I18n.marktr("Delete relations"));
        if (!discardedWays.isEmpty() && (deleteCmd = DeleteCommand.delete(discardedWays, true)) != null) {
            this.cmds.add(deleteCmd);
            this.commitCommands(I18n.marktr("Delete Ways that are not part of an inner multipolygon"));
        }
        if (warnAboutRelations) {
            new Notification(I18n.tr("Some of the ways were part of relations that have been modified.<br>Please verify no errors have been introduced.", new Object[0])).setIcon(1).setDuration(Notification.TIME_LONG).show();
        }
        return new JoinAreasResult(true, polygons);
    }

    private Way keepOlder(Way way, Map<Node, Way> oldestWayMap, List<Way> discardedWays) {
        AbstractPrimitive oldest = null;
        for (Node n : way.getNodes()) {
            Way orig = oldestWayMap.get(n);
            if (orig == null || oldest != null && oldest.getUniqueId() <= orig.getUniqueId() || !discardedWays.contains(orig)) continue;
            oldest = orig;
        }
        if (oldest != null) {
            discardedWays.remove(oldest);
            discardedWays.add(way);
            this.cmds.add(new ChangeNodesCommand((Way)oldest, way.getNodes()));
            return oldest;
        }
        return way;
    }

    private boolean resolveTagConflicts(List<Multipolygon> polygons) {
        ArrayList<Way> ways = new ArrayList<Way>();
        for (Multipolygon pol : polygons) {
            ways.add(pol.outerWay);
            ways.addAll(pol.innerWays);
        }
        if (ways.size() < 2) {
            return true;
        }
        TagCollection wayTags = TagCollection.unionOfAllPrimitives(ways);
        try {
            this.cmds.addAll(CombinePrimitiveResolverDialog.launchIfNecessary(wayTags, ways, ways));
            this.commitCommands(I18n.marktr("Fix tag conflicts"));
            return true;
        }
        catch (UserCancelException ex) {
            Logging.trace(ex);
            return false;
        }
    }

    private boolean removeDuplicateNodes(List<Way> ways) {
        TreeMap<Node, Node> nodeMap = new TreeMap<Node, Node>(new NodePositionComparator());
        int totalWaysModified = 0;
        for (Way way : ways) {
            if (way.getNodes().size() < 2) continue;
            ArrayList<Node> newNodes = new ArrayList<Node>();
            Node prevNode = null;
            boolean modifyWay = false;
            for (Node node : way.getNodes()) {
                Node representator = (Node)nodeMap.get(node);
                if (representator == null) {
                    nodeMap.put(node, node);
                    representator = node;
                } else if (representator != node) {
                    modifyWay = true;
                }
                if (prevNode != representator) {
                    newNodes.add(representator);
                    prevNode = representator;
                    continue;
                }
                modifyWay = true;
            }
            if (!modifyWay) continue;
            if (newNodes.size() == 1) {
                newNodes.add((Node)newNodes.get(0));
            }
            this.cmds.add(new ChangeNodesCommand(way, (List<Node>)newNodes));
            ++totalWaysModified;
        }
        return totalWaysModified > 0;
    }

    private void commitCommands(String description) {
        switch (this.cmds.size()) {
            case 0: {
                return;
            }
            case 1: {
                this.commitCommand(this.cmds.getFirst());
                break;
            }
            default: {
                this.commitCommand(new SequenceCommand(I18n.tr(description, new Object[0]), this.cmds));
            }
        }
        this.cmds.clear();
    }

    private void commitCommand(Command c) {
        c.executeCommand();
        this.executedCmds.add(c);
    }

    private void commitExecuted() {
        this.cmds.clear();
        if (this.addUndoRedo && !this.executedCmds.isEmpty()) {
            UndoRedoHandler ur = UndoRedoHandler.getInstance();
            if (this.executedCmds.size() == 1) {
                ur.add(this.executedCmds.getFirst(), false);
            } else {
                ur.add(new JoinAreaCommand(this.executedCmds), false);
            }
        }
        this.executedCmds.clear();
    }

    private static List<WayInPolygon> markWayInsideSide(List<Way> parts, boolean isInner) {
        boolean wayClockwise;
        HashMap<Way, Way> nextWayMap = new HashMap<Way, Way>();
        for (int pos = 0; pos < parts.size(); ++pos) {
            if (!parts.get(pos).lastNode().equals(parts.get((pos + 1) % parts.size()).firstNode())) {
                throw new IllegalArgumentException("Way not circular");
            }
            nextWayMap.put(parts.get(pos), parts.get((pos + 1) % parts.size()));
        }
        Way topWay = null;
        OsmPrimitive topNode = null;
        int topIndex = 0;
        double minY = Double.POSITIVE_INFINITY;
        for (Way way : parts) {
            for (int pos = 0; pos < way.getNodesCount(); ++pos) {
                Node node = way.getNode(pos);
                if (!(node.getEastNorth().getY() < minY)) continue;
                minY = node.getEastNorth().getY();
                topWay = way;
                topNode = node;
                topIndex = pos;
            }
        }
        if (topWay == null || topNode == null) {
            throw new IllegalArgumentException();
        }
        if (topNode.equals(topWay.firstNode()) || topNode.equals(topWay.lastNode())) {
            OsmPrimitive headNode = topNode;
            Node prevNode = new Node(new EastNorth(headNode.getEastNorth().getX(), headNode.getEastNorth().getY() - 100000.0));
            topWay = null;
            wayClockwise = false;
            Node bestWayNextNode = null;
            for (Way way : parts) {
                Node nextNode;
                if (way.firstNode().equals(headNode)) {
                    nextNode = way.getNode(1);
                    if (topWay == null || !Geometry.isToTheRightSideOfLine(prevNode, headNode, bestWayNextNode, nextNode)) {
                        topWay = way;
                        wayClockwise = true;
                        bestWayNextNode = nextNode;
                    }
                }
                if (!way.lastNode().equals(headNode)) continue;
                nextNode = way.getNode(way.getNodesCount() - 2);
                if (topWay != null && Geometry.isToTheRightSideOfLine(prevNode, headNode, bestWayNextNode, nextNode)) continue;
                topWay = way;
                wayClockwise = false;
                bestWayNextNode = nextNode;
            }
        } else {
            Node prev = topWay.getNode(topIndex - 1);
            Node next = topWay.getNode(topIndex + 1);
            wayClockwise = Geometry.angleIsClockwise(prev, topNode, next);
        }
        Way curWay = topWay;
        boolean curWayInsideToTheRight = wayClockwise ^ isInner;
        ArrayList<WayInPolygon> result = new ArrayList<WayInPolygon>();
        while (curWay != null) {
            WayInPolygon resultWay = new WayInPolygon(curWay, curWayInsideToTheRight);
            result.add(resultWay);
            Way nextWay = (Way)nextWayMap.get(curWay);
            Node prevNode = curWay.getNode(curWay.getNodesCount() - 2);
            Node headNode = curWay.lastNode();
            Node nextNode = nextWay.getNode(1);
            if (nextWay == topWay) break;
            int intersectionCount = 0;
            for (Way wayA : parts) {
                boolean wayBToTheRight;
                if (wayA == curWay || !wayA.lastNode().equals(headNode)) continue;
                Way wayB = (Way)nextWayMap.get(wayA);
                Node wayANode = wayA.getNode(wayA.getNodesCount() - 2);
                Node wayBNode = wayB.getNode(1);
                boolean wayAToTheRight = Geometry.isToTheRightSideOfLine(prevNode, headNode, nextNode, wayANode);
                if (wayAToTheRight == (wayBToTheRight = Geometry.isToTheRightSideOfLine(prevNode, headNode, nextNode, wayBNode))) continue;
                ++intersectionCount;
            }
            if (intersectionCount % 2 != 0) {
                curWayInsideToTheRight = !curWayInsideToTheRight;
            }
            curWay = nextWay;
        }
        JoinAreasAction.revertDuplicateTwoNodeWays(result);
        return result;
    }

    private static void revertDuplicateTwoNodeWays(List<WayInPolygon> parts) {
        for (int i = 0; i < parts.size(); ++i) {
            WayInPolygon w1 = parts.get(i);
            if (w1.way.getNodesCount() != 2) continue;
            for (int j = i + 1; j < parts.size(); ++j) {
                WayInPolygon w2 = parts.get(j);
                if (w2.way.getNodesCount() != 2 || w1.insideToTheRight != w2.insideToTheRight || w1.way.firstNode() != w2.way.firstNode() || w1.way.lastNode() != w2.way.lastNode()) continue;
                w2.insideToTheRight = !w2.insideToTheRight;
            }
        }
    }

    private List<Way> splitWayOnNodes(Way way, Set<Node> nodes, Map<Node, Way> oldestWayMap) {
        SplitWayCommand split;
        ArrayList<Way> result = new ArrayList<Way>();
        List<List<Node>> chunks = JoinAreasAction.buildNodeChunks(way, nodes);
        if (chunks.size() > 1 && (split = SplitWayCommand.splitWay(way, chunks, Collections.emptyList(), SplitWayCommand.Strategy.keepFirstChunk())) != null) {
            this.cmds.add(split);
            this.commitCommands(I18n.marktr("Split ways into fragments"));
            result.add(split.getOriginalWay());
            result.addAll(split.getNewWays());
            if (!way.isNew() && result.size() > 1) {
                for (Way part : result) {
                    Node n = part.firstNode();
                    Way old = oldestWayMap.get(n);
                    if (old != null && old.getUniqueId() <= way.getUniqueId()) continue;
                    oldestWayMap.put(n, way);
                }
            }
        }
        if (result.isEmpty()) {
            result.add(way);
        }
        return result;
    }

    private static List<List<Node>> buildNodeChunks(Way way, Collection<Node> splitNodes) {
        ArrayList<List<Node>> result = new ArrayList<List<Node>>();
        ArrayList<Node> curList = new ArrayList<Node>();
        for (Node node : way.getNodes()) {
            curList.add(node);
            if (curList.size() <= 1 || !splitNodes.contains(node)) continue;
            result.add(curList);
            curList = new ArrayList();
            curList.add(node);
        }
        if (curList.size() > 1) {
            result.add(curList);
        }
        return result;
    }

    private static List<AssembledMultipolygon> findPolygons(Collection<AssembledPolygon> boundaries) {
        List<PolygonLevel> list = JoinAreasAction.findOuterWaysImpl(0, boundaries);
        ArrayList<AssembledMultipolygon> result = new ArrayList<AssembledMultipolygon>();
        for (PolygonLevel pol : list) {
            if (pol.level % 2 != 0) continue;
            result.add(pol.pol);
        }
        return result;
    }

    private static List<PolygonLevel> findOuterWaysImpl(int level, Collection<AssembledPolygon> boundaryWays) {
        ArrayList<PolygonLevel> result = new ArrayList<PolygonLevel>();
        for (AssembledPolygon outerWay : boundaryWays) {
            boolean outerGood = true;
            ArrayList<AssembledPolygon> innerCandidates = new ArrayList<AssembledPolygon>();
            for (AssembledPolygon innerWay : boundaryWays) {
                if (innerWay == outerWay) continue;
                if (JoinAreasAction.wayInsideWay(outerWay, innerWay)) {
                    outerGood = false;
                    break;
                }
                if (!JoinAreasAction.wayInsideWay(innerWay, outerWay)) continue;
                innerCandidates.add(innerWay);
            }
            if (!outerGood) continue;
            AssembledMultipolygon pol = new AssembledMultipolygon(outerWay);
            PolygonLevel polLev = new PolygonLevel(pol, level);
            if (!innerCandidates.isEmpty()) {
                List<PolygonLevel> innerList = JoinAreasAction.findOuterWaysImpl(level + 1, innerCandidates);
                result.addAll(innerList);
                for (PolygonLevel pl : innerList) {
                    if (pl.level != level + 1) continue;
                    pol.innerWays.add(pl.pol.outerWay);
                }
            }
            result.add(polLev);
        }
        return result;
    }

    public static List<AssembledPolygon> findBoundaryPolygons(Collection<WayInPolygon> multigonWays, List<Way> discardedResult) {
        WayInPolygon startWay;
        ArrayList<WayInPolygon> cleanMultigonWays = new ArrayList<WayInPolygon>();
        for (WayInPolygon way : multigonWays) {
            if (way.way.getNodesCount() == 2 && way.way.isClosed()) continue;
            cleanMultigonWays.add(way);
        }
        WayTraverser traverser = new WayTraverser(cleanMultigonWays);
        ArrayList<AssembledPolygon> result = new ArrayList<AssembledPolygon>();
        block1: while ((startWay = traverser.startNewWay()) != null) {
            ArrayList<WayInPolygon> path = new ArrayList<WayInPolygon>();
            ArrayList<WayInPolygon> startWays = new ArrayList<WayInPolygon>();
            path.add(startWay);
            while (true) {
                WayInPolygon nextWay;
                WayInPolygon leftComing;
                if ((leftComing = traverser.leftComingWay()) != null && !startWays.contains(leftComing)) {
                    path.clear();
                    path.add(leftComing);
                    traverser.setStartWay(leftComing);
                    startWays.add(leftComing);
                }
                if ((nextWay = traverser.walk()) == null) {
                    throw new JosmRuntimeException("Join areas internal error.");
                }
                if (path.get(0) == nextWay) {
                    AssembledPolygon ring = new AssembledPolygon(path);
                    if (ring.getNodes().size() <= 2) {
                        traverser.removeWays(path);
                        for (WayInPolygon way : path) {
                            discardedResult.add(way.way);
                        }
                        continue block1;
                    }
                    result.add(ring);
                    traverser.removeWays(path);
                    continue block1;
                }
                if (path.contains(nextWay)) {
                    int index = path.indexOf(nextWay);
                    while (path.size() > index) {
                        WayInPolygon currentWay = (WayInPolygon)path.get(index);
                        discardedResult.add(currentWay.way);
                        traverser.removeWay(currentWay);
                        path.remove(index);
                    }
                    traverser.setStartWay((WayInPolygon)path.get(index - 1));
                    continue;
                }
                path.add(nextWay);
            }
        }
        return JoinAreasAction.fixTouchingPolygons(result);
    }

    public static List<AssembledPolygon> fixTouchingPolygons(List<AssembledPolygon> polygons) {
        ArrayList<AssembledPolygon> newPolygons = new ArrayList<AssembledPolygon>();
        for (AssembledPolygon ring : polygons) {
            WayInPolygon startWay;
            ring.reverse();
            WayTraverser traverser = new WayTraverser(ring.ways);
            while ((startWay = traverser.startNewWay()) != null) {
                WayInPolygon nextWay;
                ArrayList<WayInPolygon> simpleRingWays = new ArrayList<WayInPolygon>();
                simpleRingWays.add(startWay);
                while ((nextWay = traverser.walk()) != startWay) {
                    if (nextWay == null) {
                        throw new JosmRuntimeException("Join areas internal error.");
                    }
                    simpleRingWays.add(nextWay);
                }
                traverser.removeWays(simpleRingWays);
                AssembledPolygon simpleRing = new AssembledPolygon(simpleRingWays);
                simpleRing.reverse();
                newPolygons.add(simpleRing);
            }
        }
        return newPolygons;
    }

    public static boolean wayInsideWay(AssembledPolygon inside, AssembledPolygon outside) {
        HashSet<Node> outsideNodes = new HashSet<Node>(outside.getNodes());
        List<Node> insideNodes = inside.getNodes();
        for (Node insideNode : insideNodes) {
            if (outsideNodes.contains(insideNode)) continue;
            return Geometry.nodeInsidePolygon(insideNode, outside.getNodes());
        }
        return false;
    }

    private Multipolygon joinPolygon(AssembledMultipolygon polygon) throws UserCancelException {
        Multipolygon result = new Multipolygon(this.joinWays(polygon.outerWay.ways));
        for (AssembledPolygon pol : polygon.innerWays) {
            result.innerWays.add(this.joinWays(pol.ways));
        }
        return result;
    }

    private Way joinWays(List<WayInPolygon> ways) throws UserCancelException {
        Way joinedWay;
        boolean allReverse = true;
        for (WayInPolygon way : ways) {
            allReverse &= !way.insideToTheRight;
        }
        if (allReverse) {
            for (WayInPolygon way : ways) {
                way.insideToTheRight = !way.insideToTheRight;
            }
        }
        if ((joinedWay = this.joinOrientedWays(ways)) == null || !joinedWay.isClosed()) {
            throw new JosmRuntimeException("Join areas internal error.");
        }
        return joinedWay;
    }

    private Way joinOrientedWays(List<WayInPolygon> ways) throws UserCancelException {
        if (ways.size() < 2) {
            return ways.get((int)0).way;
        }
        ArrayList<Way> actionWays = new ArrayList<Way>(ways.size());
        int oldestPos = 0;
        Way oldest = ways.get((int)0).way;
        for (WayInPolygon way : ways) {
            actionWays.add(way.way);
            if (oldest.isNew() || !way.way.isNew() && oldest.getUniqueId() > way.way.getUniqueId()) {
                oldest = way.way;
                oldestPos = actionWays.size() - 1;
            }
            if (way.insideToTheRight) continue;
            ReverseWayAction.ReverseWayResult res = ReverseWayAction.reverseWay(way.way);
            this.commitCommand(res.getReverseCommand());
        }
        Collections.rotate(actionWays, actionWays.size() - oldestPos);
        Pair<Way, Command> result = CombineWayAction.combineWaysWorker(actionWays);
        if (result == null) {
            throw new JosmRuntimeException("Join areas internal error.");
        }
        this.commitCommand((Command)result.b);
        return (Way)result.a;
    }

    public static List<Multipolygon> collectMultipolygons(Collection<Way> selectedWays) {
        ArrayList<Multipolygon> result = new ArrayList<Multipolygon>();
        ArrayList<Way> outerWays = new ArrayList<Way>();
        ArrayList<Way> innerWays = new ArrayList<Way>();
        LinkedHashSet<Way> processedOuterWays = new LinkedHashSet<Way>();
        LinkedHashSet<Way> processedInnerWays = new LinkedHashSet<Way>();
        for (Relation r : OsmPrimitive.getParentRelations(selectedWays)) {
            if (r.isDeleted() || !r.isMultipolygon()) continue;
            boolean hasKnownOuter = false;
            outerWays.clear();
            innerWays.clear();
            for (RelationMember relationMember : r.getMembers()) {
                if (!relationMember.isWay()) continue;
                if ("outer".equalsIgnoreCase(relationMember.getRole())) {
                    outerWays.add(relationMember.getWay());
                    hasKnownOuter |= selectedWays.contains(relationMember.getWay());
                    continue;
                }
                if (!"inner".equalsIgnoreCase(relationMember.getRole())) continue;
                innerWays.add(relationMember.getWay());
            }
            if (!hasKnownOuter) continue;
            if (outerWays.size() > 1) {
                new Notification(I18n.tr("Sorry. Cannot handle multipolygon relations with multiple outer ways.", new Object[0])).setIcon(1).show();
                return null;
            }
            Way outerWay = (Way)outerWays.get(0);
            innerWays.retainAll(selectedWays);
            if (!innerWays.isEmpty() && selectedWays.contains(outerWay)) {
                new Notification(I18n.tr("Cannot join inner and outer ways of a multipolygon", new Object[0])).setIcon(1).show();
                return null;
            }
            if (processedOuterWays.contains(outerWay)) {
                new Notification(I18n.tr("Sorry. Cannot handle way that is outer in multiple multipolygon relations.", new Object[0])).setIcon(1).show();
                return null;
            }
            if (processedInnerWays.contains(outerWay)) {
                new Notification(I18n.tr("Sorry. Cannot handle way that is both inner and outer in multipolygon relations.", new Object[0])).setIcon(1).show();
                return null;
            }
            for (Way way : innerWays) {
                if (processedOuterWays.contains(way)) {
                    new Notification(I18n.tr("Sorry. Cannot handle way that is both inner and outer in multipolygon relations.", new Object[0])).setIcon(1).show();
                    return null;
                }
                if (!processedInnerWays.contains(way)) continue;
                new Notification(I18n.tr("Sorry. Cannot handle way that is inner in multiple multipolygon relations.", new Object[0])).setIcon(1).show();
                return null;
            }
            processedOuterWays.add(outerWay);
            processedInnerWays.addAll(innerWays);
            Multipolygon multipolygon = new Multipolygon(outerWay);
            multipolygon.innerWays.addAll(innerWays);
            result.add(multipolygon);
        }
        for (Way way : selectedWays) {
            if (processedOuterWays.contains(way) || processedInnerWays.contains(way)) continue;
            result.add(new Multipolygon(way));
        }
        return result;
    }

    private RelationRole addOwnMultipolygonRelation(Collection<Way> inner) {
        if (inner.isEmpty()) {
            return null;
        }
        OsmDataLayer layer = this.getLayerManager().getEditLayer();
        Relation newRel = new Relation();
        newRel.put("type", "multipolygon");
        for (Way w : inner) {
            newRel.addMember(new RelationMember("inner", w));
        }
        this.cmds.add(layer != null ? new AddCommand(layer.getDataSet(), newRel) : new AddCommand(inner.iterator().next().getDataSet(), newRel));
        this.addedRelations.add(newRel);
        return new RelationRole(newRel, "outer");
    }

    private List<RelationRole> removeFromAllRelations(OsmPrimitive osm) {
        ArrayList<RelationRole> result = new ArrayList<RelationRole>();
        block0: for (Relation r : osm.getDataSet().getRelations()) {
            if (r.isDeleted()) continue;
            for (RelationMember rm : r.getMembers()) {
                if (rm.getMember() != osm) continue;
                List<RelationMember> members = r.getMembers();
                members.remove(rm);
                this.cmds.add(new ChangeMembersCommand(r, members));
                RelationRole saverel = new RelationRole(r, rm.getRole());
                if (result.contains(saverel)) continue block0;
                result.add(saverel);
                continue block0;
            }
        }
        this.commitCommands(I18n.marktr("Removed Element from Relations"));
        return result;
    }

    private void fixRelations(List<RelationRole> rels, Way outer, RelationRole ownMultipol, Set<Relation> relationsToDelete) {
        ArrayList<RelationRole> multiouters = new ArrayList<RelationRole>();
        if (ownMultipol != null) {
            multiouters.add(ownMultipol);
        }
        for (RelationRole r : rels) {
            if (r.rel.isMultipolygon() && "outer".equalsIgnoreCase(r.role)) {
                multiouters.add(r);
                continue;
            }
            ArrayList<RelationMember> modifiedMembers = new ArrayList<RelationMember>(r.rel.getMembers());
            modifiedMembers.add(new RelationMember(r.role, outer));
            this.cmds.add(new ChangeMembersCommand(r.rel, modifiedMembers));
        }
        switch (multiouters.size()) {
            case 0: {
                return;
            }
            case 1: {
                RelationRole soleOuter = (RelationRole)multiouters.get(0);
                ArrayList<RelationMember> modifiedMembers = new ArrayList<RelationMember>(soleOuter.rel.getMembers());
                modifiedMembers.add(new RelationMember(soleOuter.role, outer));
                this.cmds.add(new ChangeMembersCommand(this.ds, soleOuter.rel, modifiedMembers));
                return;
            }
        }
        Relation newRel = new Relation();
        for (RelationRole r : multiouters) {
            for (RelationMember rm : r.rel.getMembers()) {
                if (newRel.getMembers().contains(rm)) continue;
                newRel.addMember(rm);
            }
            r.rel.visitKeys((p, key, value) -> newRel.put(key, value));
            relationsToDelete.add(r.rel);
        }
        newRel.addMember(new RelationMember("outer", outer));
        this.cmds.add(new AddCommand(this.ds, newRel));
    }

    private void stripTags(Collection<Way> ways) {
        HashMap<String, String> tagsToRemove = new HashMap<String, String>();
        ways.stream().flatMap(AbstractPrimitive::keys).forEach(k -> tagsToRemove.put((String)k, (String)null));
        if (tagsToRemove.isEmpty()) {
            return;
        }
        this.cmds.add(new ChangePropertyCommand(new ArrayList<Way>(ways), tagsToRemove));
        this.commitCommands(I18n.marktr("Remove tags from inner ways"));
    }

    @Override
    protected void updateEnabledState() {
        this.updateEnabledStateOnCurrentSelection();
    }

    @Override
    protected void updateEnabledState(Collection<? extends OsmPrimitive> selection) {
        this.updateEnabledStateOnModifiableSelection(selection);
    }

    public static class JoinAreasResult {
        private final boolean hasChanges;
        private final List<Multipolygon> polygons;

        public JoinAreasResult(boolean hasChanges, List<Multipolygon> polygons) {
            this.hasChanges = hasChanges;
            this.polygons = polygons;
        }

        public final boolean hasChanges() {
            return this.hasChanges;
        }

        public final List<Multipolygon> getPolygons() {
            return this.polygons;
        }
    }

    public static class Multipolygon {
        private final Way outerWay;
        private final List<Way> innerWays;

        public Multipolygon(Way way) {
            this.outerWay = Objects.requireNonNull(way, "way");
            this.innerWays = new ArrayList<Way>();
        }

        public final Way getOuterWay() {
            return this.outerWay;
        }

        public final List<Way> getInnerWays() {
            return this.innerWays;
        }
    }

    public static class AssembledPolygon {
        public List<WayInPolygon> ways;

        public AssembledPolygon(List<WayInPolygon> boundary) {
            this.ways = boundary;
        }

        public List<Node> getNodes() {
            ArrayList<Node> nodes = new ArrayList<Node>();
            for (WayInPolygon way : this.ways) {
                int pos;
                if (way.insideToTheRight) {
                    for (pos = 0; pos < way.way.getNodesCount() - 1; ++pos) {
                        nodes.add(way.way.getNode(pos));
                    }
                    continue;
                }
                for (pos = way.way.getNodesCount() - 1; pos > 0; --pos) {
                    nodes.add(way.way.getNode(pos));
                }
            }
            return nodes;
        }

        public void reverse() {
            for (WayInPolygon way : this.ways) {
                way.insideToTheRight = !way.insideToTheRight;
            }
            Collections.reverse(this.ways);
        }
    }

    public static class WayInPolygon {
        public final Way way;
        public boolean insideToTheRight;

        public WayInPolygon(Way way, boolean insideRight) {
            this.way = way;
            this.insideToTheRight = insideRight;
        }

        public int hashCode() {
            return Objects.hash(this.way, this.insideToTheRight);
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (other == null || this.getClass() != other.getClass()) {
                return false;
            }
            WayInPolygon that = (WayInPolygon)other;
            return this.insideToTheRight == that.insideToTheRight && Objects.equals(this.way, that.way);
        }

        public String toString() {
            return "w" + this.way.getUniqueId() + " " + this.way.getNodesCount() + " nodes";
        }
    }

    public static class AssembledMultipolygon {
        public AssembledPolygon outerWay;
        public List<AssembledPolygon> innerWays;

        public AssembledMultipolygon(AssembledPolygon way) {
            this.outerWay = way;
            this.innerWays = new ArrayList<AssembledPolygon>();
        }
    }

    private static class RelationRole {
        public final Relation rel;
        public final String role;

        RelationRole(Relation rel, String role) {
            this.rel = rel;
            this.role = role;
        }

        public int hashCode() {
            return Objects.hash(this.rel, this.role);
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (other == null || this.getClass() != other.getClass()) {
                return false;
            }
            RelationRole that = (RelationRole)other;
            return Objects.equals(this.rel, that.rel) && Objects.equals(this.role, that.role);
        }
    }

    private static class JoinAreaCommand
    extends SequenceCommand {
        JoinAreaCommand(Collection<Command> sequenz) {
            super(I18n.tr("Joined overlapping areas", new Object[0]), sequenz, true);
            this.setSequenceComplete(true);
        }

        @Override
        public void undoCommand() {
            this.getAffectedDataSet().update(() -> super.undoCommand());
        }

        @Override
        public boolean executeCommand() {
            return this.getAffectedDataSet().update(() -> super.executeCommand());
        }
    }

    static class PolygonLevel {
        public final int level;
        public final AssembledMultipolygon pol;

        PolygonLevel(AssembledMultipolygon pol, int level) {
            this.pol = pol;
            this.level = level;
        }
    }

    private static class WayTraverser {
        private final Set<WayInPolygon> availableWays;
        private WayInPolygon lastWay;
        private boolean lastWayReverse;

        WayTraverser(Collection<WayInPolygon> ways) {
            this.availableWays = new LinkedHashSet<WayInPolygon>(ways);
            this.lastWay = null;
        }

        public void removeWays(Collection<WayInPolygon> ways) {
            this.availableWays.removeAll(ways);
        }

        public void removeWay(WayInPolygon way) {
            this.availableWays.remove(way);
        }

        public void setStartWay(WayInPolygon way) {
            this.lastWay = way;
            this.lastWayReverse = !way.insideToTheRight;
        }

        public WayInPolygon startNewWay() {
            if (this.availableWays.isEmpty()) {
                this.lastWay = null;
            } else {
                this.lastWay = this.availableWays.iterator().next();
                this.lastWayReverse = !this.lastWay.insideToTheRight;
            }
            return this.lastWay;
        }

        private Node getHeadNode() {
            return !this.lastWayReverse ? this.lastWay.way.lastNode() : this.lastWay.way.firstNode();
        }

        private Node getPrevNode() {
            return !this.lastWayReverse ? this.lastWay.way.getNode(this.lastWay.way.getNodesCount() - 2) : this.lastWay.way.getNode(1);
        }

        private static double getAngle(Node n1, Node n2, Node n3) {
            double angle;
            EastNorth en1 = n1.getEastNorth();
            EastNorth en2 = n2.getEastNorth();
            EastNorth en3 = n3.getEastNorth();
            for (angle = Math.atan2(en3.getY() - en1.getY(), en3.getX() - en1.getX()) - Math.atan2(en2.getY() - en1.getY(), en2.getX() - en1.getX()); angle >= Math.PI * 2; angle -= Math.PI * 2) {
            }
            while (angle < 0.0) {
                angle += Math.PI * 2;
            }
            return angle;
        }

        public WayInPolygon walk() {
            Node headNode = this.getHeadNode();
            Node prevNode = this.getPrevNode();
            double headAngle = Math.atan2(headNode.getEastNorth().east() - prevNode.getEastNorth().east(), headNode.getEastNorth().north() - prevNode.getEastNorth().north());
            double bestAngle = 0.0;
            WayInPolygon bestWay = null;
            boolean bestWayReverse = false;
            for (WayInPolygon way : this.availableWays) {
                Node nextNode;
                if (way.way.firstNode().equals(headNode) && way.insideToTheRight) {
                    nextNode = way.way.getNode(1);
                } else {
                    if (!way.way.lastNode().equals(headNode) || way.insideToTheRight) continue;
                    nextNode = way.way.getNode(way.way.getNodesCount() - 2);
                }
                if (nextNode == prevNode) {
                    this.lastWay = way;
                    this.lastWayReverse = !way.insideToTheRight;
                    return this.lastWay;
                }
                double angle = Math.atan2(nextNode.getEastNorth().east() - headNode.getEastNorth().east(), nextNode.getEastNorth().north() - headNode.getEastNorth().north()) - headAngle;
                if (angle > Math.PI) {
                    angle -= Math.PI * 2;
                }
                if (angle <= -Math.PI) {
                    angle += Math.PI * 2;
                }
                if (bestWay != null && !(angle > bestAngle)) continue;
                bestWay = way;
                bestWayReverse = !way.insideToTheRight;
                bestAngle = angle;
            }
            this.lastWay = bestWay;
            this.lastWayReverse = bestWayReverse;
            return this.lastWay;
        }

        public WayInPolygon leftComingWay() {
            Node headNode = this.getHeadNode();
            Node prevNode = this.getPrevNode();
            WayInPolygon mostLeft = null;
            boolean comingToHead = false;
            double angle = Math.PI * 2;
            for (WayInPolygon candidateWay : this.availableWays) {
                Node candidatePrevNode;
                boolean candidateComingToHead;
                if (candidateWay.way.firstNode().equals(headNode)) {
                    candidateComingToHead = !candidateWay.insideToTheRight;
                    candidatePrevNode = candidateWay.way.getNode(1);
                } else {
                    if (!candidateWay.way.lastNode().equals(headNode)) continue;
                    candidateComingToHead = candidateWay.insideToTheRight;
                    candidatePrevNode = candidateWay.way.getNode(candidateWay.way.getNodesCount() - 2);
                }
                if (candidateComingToHead && candidateWay.equals(this.lastWay)) continue;
                double candidateAngle = WayTraverser.getAngle(headNode, candidatePrevNode, prevNode);
                if (mostLeft != null && !(candidateAngle < angle) && (!Utils.equalsEpsilon(candidateAngle, angle) || candidateComingToHead)) continue;
                mostLeft = candidateWay;
                comingToHead = candidateComingToHead;
                angle = candidateAngle;
            }
            return comingToHead ? mostLeft : null;
        }
    }
}

