/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.io.remotecontrol.handler;

import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Objects;
import org.openstreetmap.josm.data.StructUtils;
import org.openstreetmap.josm.data.imagery.ImageryInfo;
import org.openstreetmap.josm.data.imagery.ImageryLayerInfo;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.layer.ImageryLayer;
import org.openstreetmap.josm.gui.util.GuiHelper;
import org.openstreetmap.josm.io.remotecontrol.PermissionPrefWithDefault;
import org.openstreetmap.josm.io.remotecontrol.handler.RequestHandler;
import org.openstreetmap.josm.tools.CheckParameterUtil;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Logging;
import org.openstreetmap.josm.tools.Utils;

public class ImageryHandler
extends RequestHandler.RawURLParseRequestHandler {
    public static final String command = "imagery";

    @Override
    public String getPermissionMessage() {
        return I18n.tr("Remote Control has been asked to load an imagery layer from the following URL:", new Object[0]) + "<br>" + this.args.getOrDefault("url", (String)this.args.get("id"));
    }

    @Override
    public String[] getMandatoryParams() {
        return new String[0];
    }

    @Override
    public String[] getOptionalParams() {
        LinkedHashSet<String> params = new LinkedHashSet<String>();
        params.add("url");
        params.add("id");
        Map<String, String> struct = StructUtils.serializeStruct(new ImageryInfo.ImageryPreferenceEntry(), ImageryInfo.ImageryPreferenceEntry.class, StructUtils.SerializeOptions.INCLUDE_NULL, StructUtils.SerializeOptions.INCLUDE_DEFAULT);
        params.addAll(struct.keySet());
        return params.toArray(new String[0]);
    }

    @Override
    public PermissionPrefWithDefault getPermissionPref() {
        return PermissionPrefWithDefault.LOAD_IMAGERY;
    }

    protected ImageryInfo buildImageryInfo() {
        String id = (String)this.args.get("id");
        if (id != null) {
            return ImageryLayerInfo.instance.getAllDefaultLayers().stream().filter(l -> Objects.equals(l.getId(), id)).findFirst().orElseThrow(() -> new IllegalArgumentException("Cannot find layer for id " + id));
        }
        this.args.computeIfAbsent("type", ignore -> ImageryInfo.ImageryType.WMS.getDefault().getTypeString());
        this.args.computeIfAbsent("name", ignore -> this.args.getOrDefault("title", I18n.tr("Remote imagery", new Object[0])));
        ImageryInfo.ImageryPreferenceEntry imageryPreferenceEntry = StructUtils.deserializeStruct(this.args, ImageryInfo.ImageryPreferenceEntry.class);
        return new ImageryInfo(imageryPreferenceEntry);
    }

    @Override
    protected void handleRequest() throws RequestHandler.RequestHandlerErrorException {
        ImageryInfo imgInfo = this.buildImageryInfo();
        if (MainApplication.isDisplayingMapView()) {
            for (ImageryLayer layer : MainApplication.getLayerManager().getLayersOfType(ImageryLayer.class)) {
                if (!layer.getInfo().equals(imgInfo)) continue;
                Logging.info("Imagery layer already exists: " + imgInfo);
                return;
            }
        }
        GuiHelper.runInEDT(() -> {
            try {
                MainApplication.getLayerManager().addLayer(ImageryLayer.create(imgInfo));
            }
            catch (IllegalArgumentException e) {
                Logging.log(Logging.LEVEL_ERROR, e);
            }
        });
    }

    @Override
    protected void validateRequest() throws RequestHandler.RequestHandlerBadRequestException {
        try {
            CheckParameterUtil.ensureParameterNotNull(this.args);
            CheckParameterUtil.ensureThat(this.args.containsKey("url") || this.args.containsKey("id"), I18n.tr("The following keys are mandatory, but have not been provided: {0}", "url/id"));
            ImageryLayer.create(this.buildImageryInfo());
        }
        catch (IllegalArgumentException e) {
            throw new RequestHandler.RequestHandlerBadRequestException(e.getMessage(), e);
        }
    }

    @Override
    public String getUsage() {
        return "adds an imagery layer (e.g. WMS, TMS)";
    }

    @Override
    public String[] getUsageExamples() {
        String types = String.join((CharSequence)"|", Utils.transform(Arrays.asList(ImageryInfo.ImageryType.values()), ImageryInfo.ImageryType::getTypeString));
        return new String[]{"/imagery?id=Bing", "/imagery?title=osm&type=tms&url=https://tile.openstreetmap.org/%7Bzoom%7D/%7Bx%7D/%7By%7D.png", "/imagery?title=landsat&type=wms&url=http://irs.gis-lab.info/?layers=landsat&SRS=%7Bproj%7D&WIDTH=%7Bwidth%7D&HEIGHT=%7Bheight%7D&BBOX=%7Bbbox%7D", "/imagery?title=...&type={" + types + "}&url=....[&cookies=...][&min_zoom=...][&max_zoom=...]"};
    }
}

