/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.preferences.server;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import org.openstreetmap.josm.actions.ExpertToggleAction;
import org.openstreetmap.josm.data.oauth.IOAuthToken;
import org.openstreetmap.josm.data.oauth.OAuth20Authorization;
import org.openstreetmap.josm.data.oauth.OAuth20Token;
import org.openstreetmap.josm.data.oauth.OAuthAccessTokenHolder;
import org.openstreetmap.josm.data.oauth.OAuthParameters;
import org.openstreetmap.josm.data.oauth.OAuthToken;
import org.openstreetmap.josm.data.oauth.OAuthVersion;
import org.openstreetmap.josm.data.oauth.osm.OsmScopes;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.oauth.AdvancedOAuthPropertiesPanel;
import org.openstreetmap.josm.gui.oauth.AuthorizationProcedure;
import org.openstreetmap.josm.gui.oauth.OAuthAuthorizationWizard;
import org.openstreetmap.josm.gui.oauth.TestAccessTokenTask;
import org.openstreetmap.josm.gui.preferences.server.OsmApiUrlInputPanel;
import org.openstreetmap.josm.gui.util.GuiHelper;
import org.openstreetmap.josm.gui.widgets.JMultilineLabel;
import org.openstreetmap.josm.gui.widgets.JosmTextField;
import org.openstreetmap.josm.io.OsmApi;
import org.openstreetmap.josm.io.auth.CredentialsManager;
import org.openstreetmap.josm.io.remotecontrol.RemoteControl;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.Logging;
import org.openstreetmap.josm.tools.UserCancelException;

public class OAuthAuthenticationPreferencesPanel
extends JPanel
implements PropertyChangeListener {
    private final JCheckBox cbUseForAllRequests = new JCheckBox();
    private final JCheckBox cbShowAdvancedParameters = new JCheckBox(I18n.tr("Display Advanced OAuth Parameters", new Object[0]));
    private final JCheckBox cbSaveToPreferences = new JCheckBox(I18n.tr("Save to preferences", new Object[0]));
    private final JPanel pnlAuthorisationMessage = new JPanel(new BorderLayout());
    private final NotYetAuthorisedPanel pnlNotYetAuthorised;
    private final AdvancedOAuthPropertiesPanel pnlAdvancedProperties;
    private final AlreadyAuthorisedPanel pnlAlreadyAuthorised;
    private final OAuthVersion oAuthVersion;
    private String apiUrl;

    public OAuthAuthenticationPreferencesPanel() {
        this(OAuthVersion.OAuth10a);
    }

    public OAuthAuthenticationPreferencesPanel(OAuthVersion oAuthVersion) {
        this.oAuthVersion = oAuthVersion;
        this.pnlNotYetAuthorised = new NotYetAuthorisedPanel();
        this.pnlAdvancedProperties = new AdvancedOAuthPropertiesPanel(this.oAuthVersion);
        this.pnlAlreadyAuthorised = new AlreadyAuthorisedPanel();
        this.build();
    }

    protected JPanel buildAdvancedPropertiesPanel() {
        JPanel pnl = new JPanel(new GridBagLayout());
        this.cbUseForAllRequests.setText(I18n.tr("Use OAuth for all requests to {0}", OsmApi.getOsmApi().getServerUrl()));
        this.cbUseForAllRequests.setToolTipText(I18n.tr("For user-based bandwidth limit instead of IP-based one", new Object[0]));
        pnl.add((Component)this.cbUseForAllRequests, GBC.eol().fill(2));
        pnl.add((Component)this.cbShowAdvancedParameters, GBC.eol().fill(2));
        this.cbShowAdvancedParameters.setSelected(false);
        this.cbShowAdvancedParameters.addItemListener(evt -> this.pnlAdvancedProperties.setVisible(evt.getStateChange() == 1));
        pnl.add((Component)this.pnlAdvancedProperties, GBC.eol().fill(2).insets(0, 3, 0, 0));
        this.pnlAdvancedProperties.initialize(OsmApi.getOsmApi().getServerUrl());
        this.pnlAdvancedProperties.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(Color.GRAY, 1), BorderFactory.createEmptyBorder(3, 3, 3, 3)));
        this.pnlAdvancedProperties.setVisible(false);
        return pnl;
    }

    protected final void build() {
        this.setLayout(new GridBagLayout());
        this.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        GridBagConstraints gc = new GridBagConstraints();
        gc.fill = 1;
        gc.anchor = 18;
        gc.weighty = 1.0;
        gc.weightx = 1.0;
        gc.insets = new Insets(10, 0, 0, 0);
        this.add((Component)this.pnlAuthorisationMessage, gc);
    }

    protected void refreshView() {
        this.pnlAuthorisationMessage.removeAll();
        if (this.oAuthVersion == OAuthVersion.OAuth10a && OAuthAccessTokenHolder.getInstance().containsAccessToken() || OAuthAccessTokenHolder.getInstance().getAccessToken(this.apiUrl, this.oAuthVersion) != null) {
            this.pnlAuthorisationMessage.add((Component)this.pnlAlreadyAuthorised, "Center");
            this.pnlAlreadyAuthorised.refreshView();
            this.pnlAlreadyAuthorised.revalidate();
        } else {
            this.pnlAuthorisationMessage.add((Component)this.pnlNotYetAuthorised, "Center");
            this.pnlNotYetAuthorised.revalidate();
        }
        this.repaint();
    }

    public void setApiUrl(String apiUrl) {
        this.apiUrl = apiUrl;
        this.pnlAdvancedProperties.setApiUrl(apiUrl);
    }

    public void initFromPreferences() {
        this.setApiUrl(OsmApi.getOsmApi().getServerUrl().trim());
        this.cbUseForAllRequests.setSelected(OsmApi.USE_OAUTH_FOR_ALL_REQUESTS.get());
        this.refreshView();
    }

    public void saveToPreferences() {
        OAuthAccessTokenHolder.getInstance().setSaveToPreferences(this.cbSaveToPreferences.isSelected());
        OAuthAccessTokenHolder.getInstance().save(CredentialsManager.getInstance());
        OsmApi.USE_OAUTH_FOR_ALL_REQUESTS.put(this.cbUseForAllRequests.isSelected());
        this.pnlAdvancedProperties.rememberPreferences();
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (!evt.getPropertyName().equals(OsmApiUrlInputPanel.API_URL_PROP)) {
            return;
        }
        this.setApiUrl((String)evt.getNewValue());
    }

    private class NotYetAuthorisedPanel
    extends JPanel {
        NotYetAuthorisedPanel() {
            this.build();
        }

        protected void build() {
            this.setLayout(new GridBagLayout());
            JMultilineLabel lbl = new JMultilineLabel(I18n.tr("You do not have an Access Token yet to access the OSM server using OAuth. Please authorize first.", new Object[0]));
            this.add((Component)lbl, GBC.eol().anchor(18).fill(2));
            lbl.setFont(lbl.getFont().deriveFont(0));
            if (OAuthAuthenticationPreferencesPanel.this.oAuthVersion == OAuthVersion.OAuth10a) {
                this.add((Component)new JButton(new AuthoriseNowAction(AuthorizationProcedure.FULLY_AUTOMATIC)), GBC.eol());
            }
            this.add((Component)new JButton(new AuthoriseNowAction(AuthorizationProcedure.SEMI_AUTOMATIC)), GBC.eol());
            if (OAuthAuthenticationPreferencesPanel.this.oAuthVersion == OAuthVersion.OAuth10a) {
                JButton authManually = new JButton(new AuthoriseNowAction(AuthorizationProcedure.MANUALLY));
                this.add((Component)authManually, GBC.eol());
                ExpertToggleAction.addVisibilitySwitcher(authManually);
            }
            this.add((Component)new JPanel(), GBC.std().fill(1));
        }
    }

    private class AlreadyAuthorisedPanel
    extends JPanel {
        private final JosmTextField tfAccessTokenKey = new JosmTextField(null, null, 0, false);
        private final JosmTextField tfAccessTokenSecret = new JosmTextField(null, null, 0, false);

        AlreadyAuthorisedPanel() {
            this.build();
            this.refreshView();
        }

        protected void build() {
            this.setLayout(new GridBagLayout());
            GridBagConstraints gc = new GridBagConstraints();
            gc.anchor = 18;
            gc.insets = new Insets(0, 0, 3, 3);
            gc.fill = 2;
            gc.weightx = 1.0;
            gc.gridwidth = 2;
            JMultilineLabel lbl = new JMultilineLabel(I18n.tr("You already have an Access Token to access the OSM server using OAuth.", new Object[0]));
            this.add((Component)lbl, gc);
            lbl.setFont(lbl.getFont().deriveFont(0));
            gc.gridy = 1;
            gc.gridx = 0;
            gc.gridwidth = 1;
            gc.weightx = 0.0;
            this.add((Component)new JLabel(I18n.tr("Access Token Key:", new Object[0])), gc);
            gc.gridx = 1;
            gc.weightx = 1.0;
            this.add((Component)this.tfAccessTokenKey, gc);
            this.tfAccessTokenKey.setEditable(false);
            gc.gridy = 2;
            gc.gridx = 0;
            gc.gridwidth = 1;
            gc.weightx = 0.0;
            this.add((Component)new JLabel(I18n.tr("Access Token Secret:", new Object[0])), gc);
            gc.gridx = 1;
            gc.weightx = 1.0;
            this.add((Component)this.tfAccessTokenSecret, gc);
            this.tfAccessTokenSecret.setEditable(false);
            gc.gridy = 3;
            gc.gridx = 0;
            gc.gridwidth = 2;
            gc.weightx = 1.0;
            this.add((Component)OAuthAuthenticationPreferencesPanel.this.cbSaveToPreferences, gc);
            OAuthAuthenticationPreferencesPanel.this.cbSaveToPreferences.setSelected(OAuthAccessTokenHolder.getInstance().isSaveToPreferences());
            JPanel btns = new JPanel(new FlowLayout(0));
            if (OAuthAuthenticationPreferencesPanel.this.oAuthVersion == OAuthVersion.OAuth10a) {
                btns.add(new JButton(new RenewAuthorisationAction(AuthorizationProcedure.FULLY_AUTOMATIC)));
            }
            btns.add(new JButton(new TestAuthorisationAction(OAuthAuthenticationPreferencesPanel.this.oAuthVersion)));
            btns.add(new JButton(new RemoveAuthorisationAction()));
            gc.gridy = 4;
            gc.gridx = 0;
            gc.gridwidth = 2;
            gc.weightx = 1.0;
            this.add((Component)btns, gc);
            gc.gridy = 5;
            gc.gridx = 0;
            gc.gridwidth = 2;
            gc.weightx = 1.0;
            this.add((Component)OAuthAuthenticationPreferencesPanel.this.buildAdvancedPropertiesPanel(), gc);
            gc.gridy = 6;
            gc.fill = 1;
            gc.weightx = 1.0;
            gc.weighty = 1.0;
            this.add((Component)new JPanel(), gc);
        }

        protected final void refreshView() {
            switch (OAuthAuthenticationPreferencesPanel.this.oAuthVersion) {
                case OAuth10a: {
                    String v = OAuthAccessTokenHolder.getInstance().getAccessTokenKey();
                    this.tfAccessTokenKey.setText(v == null ? "" : v);
                    v = OAuthAccessTokenHolder.getInstance().getAccessTokenSecret();
                    this.tfAccessTokenSecret.setText(v == null ? "" : v);
                    this.tfAccessTokenSecret.setVisible(true);
                    break;
                }
                case OAuth20: 
                case OAuth21: {
                    String token = "";
                    if (OAuthAuthenticationPreferencesPanel.this.apiUrl != null) {
                        OAuth20Token bearerToken = (OAuth20Token)OAuthAccessTokenHolder.getInstance().getAccessToken(OAuthAuthenticationPreferencesPanel.this.apiUrl, OAuthAuthenticationPreferencesPanel.this.oAuthVersion);
                        token = bearerToken == null ? "" : bearerToken.getBearerToken();
                    }
                    this.tfAccessTokenKey.setText(token == null ? "" : token);
                    this.tfAccessTokenSecret.setVisible(false);
                }
            }
            OAuthAuthenticationPreferencesPanel.this.cbSaveToPreferences.setSelected(OAuthAccessTokenHolder.getInstance().isSaveToPreferences());
        }
    }

    private class TestAuthorisationAction
    extends AbstractAction {
        private final OAuthVersion oAuthVersion;

        TestAuthorisationAction(OAuthVersion oAuthVersion) {
            this.oAuthVersion = oAuthVersion;
            this.putValue("Name", I18n.tr("Test Access Token", new Object[0]));
            this.putValue("ShortDescription", I18n.tr("Click test access to the OSM server with the current access token", new Object[0]));
            new ImageProvider("oauth", "oauth-small").getResource().attachImageIcon(this);
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            if (this.oAuthVersion == OAuthVersion.OAuth10a) {
                OAuthToken token = OAuthAccessTokenHolder.getInstance().getAccessToken();
                OAuthParameters parameters = OAuthParameters.createFromApiUrl(OsmApi.getOsmApi().getServerUrl());
                TestAccessTokenTask task = new TestAccessTokenTask((Component)OAuthAuthenticationPreferencesPanel.this, OAuthAuthenticationPreferencesPanel.this.apiUrl, parameters, token);
                MainApplication.worker.submit(task);
            } else {
                IOAuthToken token = OAuthAccessTokenHolder.getInstance().getAccessToken(OsmApi.getOsmApi().getBaseUrl(), OAuthVersion.OAuth20);
                TestAccessTokenTask task = new TestAccessTokenTask((Component)OAuthAuthenticationPreferencesPanel.this, OAuthAuthenticationPreferencesPanel.this.apiUrl, token.getParameters(), token);
                MainApplication.worker.submit(task);
            }
        }
    }

    private class RenewAuthorisationAction
    extends AuthoriseNowAction {
        RenewAuthorisationAction(AuthorizationProcedure procedure) {
            super(procedure);
            this.putValue("Name", I18n.tr("New Access Token", new Object[0]));
            this.putValue("ShortDescription", I18n.tr("Click to step through the OAuth authorization process and generate a new Access Token", new Object[0]));
            new ImageProvider("oauth", "oauth-small").getResource().attachImageIcon(this);
        }
    }

    private class RemoveAuthorisationAction
    extends AbstractAction {
        RemoveAuthorisationAction() {
            this.putValue("Name", I18n.tr("Remove token", new Object[0]));
            this.putValue("ShortDescription", I18n.tr("Remove token from JOSM. This does not revoke the token.", new Object[0]));
            new ImageProvider("cancel").getResource().attachImageIcon(this);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (OAuthAuthenticationPreferencesPanel.this.oAuthVersion == OAuthVersion.OAuth10a) {
                OAuthAccessTokenHolder.getInstance().setAccessToken(null);
            } else {
                OAuthAccessTokenHolder.getInstance().setAccessToken(OAuthAuthenticationPreferencesPanel.this.apiUrl, (IOAuthToken)null);
            }
            OAuthAccessTokenHolder.getInstance().save(CredentialsManager.getInstance());
            OAuthAuthenticationPreferencesPanel.this.refreshView();
        }
    }

    private class AuthoriseNowAction
    extends AbstractAction {
        private final AuthorizationProcedure procedure;

        AuthoriseNowAction(AuthorizationProcedure procedure) {
            this.procedure = procedure;
            this.putValue("Name", I18n.tr("{0} ({1})", I18n.tr("Authorize now", new Object[0]), procedure.getText()));
            this.putValue("ShortDescription", procedure.getDescription());
            if (procedure == AuthorizationProcedure.FULLY_AUTOMATIC || OAuthAuthenticationPreferencesPanel.this.oAuthVersion != OAuthVersion.OAuth10a) {
                new ImageProvider("oauth", "oauth-small").getResource().attachImageIcon(this);
            }
        }

        @Override
        public void actionPerformed(ActionEvent arg0) {
            if (OAuthAuthenticationPreferencesPanel.this.oAuthVersion == OAuthVersion.OAuth10a) {
                OAuthAuthorizationWizard wizard = new OAuthAuthorizationWizard(OAuthAuthenticationPreferencesPanel.this, this.procedure, OAuthAuthenticationPreferencesPanel.this.apiUrl, MainApplication.worker);
                try {
                    wizard.showDialog();
                }
                catch (UserCancelException ignore) {
                    Logging.trace(ignore);
                    return;
                }
                OAuthAuthenticationPreferencesPanel.this.pnlAdvancedProperties.setAdvancedParameters(wizard.getOAuthParameters());
                OAuthAuthenticationPreferencesPanel.this.refreshView();
            } else {
                boolean remoteControlIsRunning = Boolean.TRUE.equals(RemoteControl.PROP_REMOTECONTROL_ENABLED.get());
                if (!remoteControlIsRunning) {
                    RemoteControl.start();
                }
                new OAuth20Authorization().authorize(OAuthParameters.createDefault(OsmApi.getOsmApi().getServerUrl(), OAuthAuthenticationPreferencesPanel.this.oAuthVersion), token -> {
                    if (!remoteControlIsRunning) {
                        RemoteControl.stop();
                    }
                    OAuthAccessTokenHolder.getInstance().setAccessToken(OsmApi.getOsmApi().getServerUrl(), (IOAuthToken)token.orElse(null));
                    OAuthAccessTokenHolder.getInstance().save(CredentialsManager.getInstance());
                    GuiHelper.runInEDT(OAuthAuthenticationPreferencesPanel.this::refreshView);
                    if (!token.isPresent()) {
                        GuiHelper.runInEDT(() -> JOptionPane.showMessageDialog(MainApplication.getMainPanel(), I18n.tr("Authentication failed, please check browser for details.", new Object[0]), I18n.tr("OAuth Authentication Failed", new Object[0]), 0));
                    }
                }, OsmScopes.read_gpx, OsmScopes.write_gpx, OsmScopes.read_prefs, OsmScopes.write_prefs, OsmScopes.write_api, OsmScopes.write_notes);
            }
        }
    }
}

