/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.io.session;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.openstreetmap.josm.actions.ExtensionFileFilter;
import org.openstreetmap.josm.gui.io.importexport.FileImporter;
import org.openstreetmap.josm.gui.io.importexport.OsmImporter;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.gui.progress.ProgressMonitor;
import org.openstreetmap.josm.io.IllegalDataException;
import org.openstreetmap.josm.io.session.SessionLayerImporter;
import org.openstreetmap.josm.io.session.SessionReader;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Utils;
import org.w3c.dom.Element;

public class OsmDataSessionImporter
implements SessionLayerImporter {
    @Override
    public Layer load(Element elem, SessionReader.ImportSupport support, ProgressMonitor progressMonitor) throws IOException, IllegalDataException {
        OsmDataSessionImporter.checkMetaVersion(elem);
        String fileStr = OsmDataSessionImporter.extractFileName(elem, support);
        File file = new File(fileStr);
        for (FileImporter importer : ExtensionFileFilter.getImporters()) {
            if (!(importer instanceof OsmImporter) || !importer.acceptFile(file)) continue;
            return OsmDataSessionImporter.importData((OsmImporter)importer, support, fileStr, progressMonitor);
        }
        return OsmDataSessionImporter.importData(new OsmImporter(), support, fileStr, progressMonitor);
    }

    public static void checkMetaVersion(Element elem) throws IllegalDataException {
        String version = elem.getAttribute("version");
        if (!"0.1".equals(version)) {
            throw new IllegalDataException(I18n.tr("Version ''{0}'' of meta data for osm data layer is not supported. Expected: 0.1", version));
        }
    }

    public static String extractFileName(Element elem, SessionReader.ImportSupport support) throws IllegalDataException {
        try {
            XPathFactory xPathFactory = XPathFactory.newInstance();
            XPath xpath = xPathFactory.newXPath();
            XPathExpression fileExp = xpath.compile("file/text()");
            String fileStr = (String)fileExp.evaluate(elem, XPathConstants.STRING);
            if (Utils.isEmpty(fileStr)) {
                throw new IllegalDataException(I18n.tr("File name expected for layer no. {0}", support.getLayerIndex()));
            }
            return fileStr;
        }
        catch (XPathExpressionException e) {
            throw new IllegalDataException(e);
        }
    }

    public static Layer importData(OsmImporter osmImporter, SessionReader.ImportSupport support, String fileStr, ProgressMonitor progressMonitor) throws IOException, IllegalDataException {
        try (InputStream in = support.getInputStream(fileStr);){
            OsmImporter.OsmImporterData importData = osmImporter.loadLayer(in, support.getFile(fileStr), support.getLayerName(), progressMonitor);
            support.addPostLayersTask(importData.getPostLayerTask());
            OsmDataLayer osmDataLayer = importData.getLayer();
            return osmDataLayer;
        }
    }
}

