/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.imagery;

import java.awt.Polygon;
import java.text.MessageFormat;
import java.util.AbstractList;
import java.util.List;
import java.util.stream.Collectors;
import org.openstreetmap.gui.jmapviewer.Coordinate;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.tools.CheckParameterUtil;
import org.openstreetmap.josm.tools.I18n;

public class Shape {
    private final Polygon coords;

    public Shape(String asString, String separator) {
        CheckParameterUtil.ensureParameterNotNull(asString, "asString");
        String[] components = asString.split(separator, -1);
        if (components.length % 2 != 0) {
            throw new IllegalArgumentException(MessageFormat.format("Even number of doubles expected in string, got {0}: {1}", components.length, asString));
        }
        int size = components.length / 2;
        this.coords = new Polygon(new int[size], new int[size], 0);
        for (int i = 0; i < components.length; i += 2) {
            this.addPoint(components[i], components[i + 1]);
        }
    }

    public Shape() {
        this.coords = new Polygon();
    }

    public String encodeAsString(String separator) {
        return this.getPoints().stream().map(c -> c.getLat() + separator + c.getLon()).collect(Collectors.joining(separator));
    }

    public static String encodeAsString(List<Shape> shapes) {
        return shapes.stream().map(s -> s.encodeAsString(",")).collect(Collectors.joining(";"));
    }

    public List<Coordinate> getPoints() {
        return new CoordinateList(this.coords);
    }

    public boolean contains(LatLon latlon) {
        return this.coords.contains(latlon.getX() * 1.0E7, latlon.getY() * 1.0E7);
    }

    public void addPoint(String sLat, String sLon) {
        double lon;
        double lat;
        CheckParameterUtil.ensureParameterNotNull(sLat, "sLat");
        CheckParameterUtil.ensureParameterNotNull(sLon, "sLon");
        try {
            lat = Double.parseDouble(sLat);
            if (!LatLon.isValidLat(lat)) {
                throw new IllegalArgumentException(I18n.tr("Illegal latitude value ''{0}''", lat));
            }
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException(MessageFormat.format("Illegal double value ''{0}''", sLat), e);
        }
        try {
            lon = Double.parseDouble(sLon);
            if (!LatLon.isValidLon(lon)) {
                throw new IllegalArgumentException(I18n.tr("Illegal longitude value ''{0}''", lon));
            }
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException(MessageFormat.format("Illegal double value ''{0}''", sLon), e);
        }
        this.coords.addPoint((int)Math.round(lon * 1.0E7), (int)Math.round(lat * 1.0E7));
    }

    public int hashCode() {
        return 31 + Shape.hashPolygon(this.coords);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Shape shape = (Shape)obj;
        return Shape.equalsPolygon(this.coords, shape.coords);
    }

    public String toString() {
        return "Shape{coords=" + this.getPoints() + '}';
    }

    private static int hashPolygon(Polygon coords) {
        int hashCode = 1;
        for (int index = 0; index < coords.npoints; ++index) {
            double lat = (double)coords.ypoints[index] / 1.0E7;
            double lon = (double)coords.xpoints[index] / 1.0E7;
            int coordinateHash = 31 * (31 + Double.hashCode(lon)) + Double.hashCode(lat);
            hashCode = 31 * hashCode + coordinateHash;
        }
        return hashCode;
    }

    private static boolean equalsPolygon(Polygon first, Polygon second) {
        if (first.npoints != second.npoints) {
            return false;
        }
        for (int i = 0; i < first.npoints; ++i) {
            if (first.xpoints[i] == second.xpoints[i] && first.ypoints[i] == second.ypoints[i]) continue;
            return false;
        }
        return true;
    }

    private static final class CoordinateList
    extends AbstractList<Coordinate> {
        private final Polygon coords;

        CoordinateList(Polygon coords) {
            this.coords = coords;
        }

        @Override
        public Coordinate get(int index) {
            double lat = (double)this.coords.ypoints[index] / 1.0E7;
            double lon = (double)this.coords.xpoints[index] / 1.0E7;
            return new Coordinate(lat, lon);
        }

        @Override
        public int size() {
            return this.coords.npoints;
        }

        @Override
        public boolean equals(Object o) {
            if (o instanceof CoordinateList) {
                CoordinateList other = (CoordinateList)o;
                return Shape.equalsPolygon(this.coords, other.coords);
            }
            return super.equals(o);
        }

        @Override
        public int hashCode() {
            return Shape.hashPolygon(this.coords);
        }
    }
}

