/*
 * Decompiled with CFR 0.152.
 */
package com.drew.metadata.exif.makernotes;

import com.drew.lang.ByteArrayReader;
import com.drew.lang.Charsets;
import com.drew.lang.annotations.NotNull;
import com.drew.lang.annotations.Nullable;
import com.drew.metadata.Age;
import com.drew.metadata.Face;
import com.drew.metadata.TagDescriptor;
import com.drew.metadata.exif.makernotes.PanasonicMakernoteDirectory;
import java.io.IOException;
import java.text.DecimalFormat;

public class PanasonicMakernoteDescriptor
extends TagDescriptor<PanasonicMakernoteDirectory> {
    private static final String[] _sceneModes = new String[]{"Normal", "Portrait", "Scenery", "Sports", "Night Portrait", "Program", "Aperture Priority", "Shutter Priority", "Macro", "Spot", "Manual", "Movie Preview", "Panning", "Simple", "Color Effects", "Self Portrait", "Economy", "Fireworks", "Party", "Snow", "Night Scenery", "Food", "Baby", "Soft Skin", "Candlelight", "Starry Night", "High Sensitivity", "Panorama Assist", "Underwater", "Beach", "Aerial Photo", "Sunset", "Pet", "Intelligent ISO", "Clipboard", "High Speed Continuous Shooting", "Intelligent Auto", null, "Multi-aspect", null, "Transform", "Flash Burst", "Pin Hole", "Film Grain", "My Color", "Photo Frame", null, null, null, null, "HDR"};

    public PanasonicMakernoteDescriptor(@NotNull PanasonicMakernoteDirectory directory) {
        super(directory);
    }

    @Override
    @Nullable
    public String getDescription(int tagType) {
        switch (tagType) {
            case 1: {
                return this.getQualityModeDescription();
            }
            case 2: {
                return this.getVersionDescription();
            }
            case 3: {
                return this.getWhiteBalanceDescription();
            }
            case 7: {
                return this.getFocusModeDescription();
            }
            case 15: {
                return this.getAfAreaModeDescription();
            }
            case 26: {
                return this.getImageStabilizationDescription();
            }
            case 28: {
                return this.getMacroModeDescription();
            }
            case 31: {
                return this.getRecordModeDescription();
            }
            case 32: {
                return this.getAudioDescription();
            }
            case 33: {
                return this.getUnknownDataDumpDescription();
            }
            case 40: {
                return this.getColorEffectDescription();
            }
            case 41: {
                return this.getUptimeDescription();
            }
            case 42: {
                return this.getBurstModeDescription();
            }
            case 44: {
                return this.getContrastModeDescription();
            }
            case 45: {
                return this.getNoiseReductionDescription();
            }
            case 46: {
                return this.getSelfTimerDescription();
            }
            case 48: {
                return this.getRotationDescription();
            }
            case 49: {
                return this.getAfAssistLampDescription();
            }
            case 50: {
                return this.getColorModeDescription();
            }
            case 52: {
                return this.getOpticalZoomModeDescription();
            }
            case 53: {
                return this.getConversionLensDescription();
            }
            case 57: {
                return this.getContrastDescription();
            }
            case 58: {
                return this.getWorldTimeLocationDescription();
            }
            case 61: {
                return this.getAdvancedSceneModeDescription();
            }
            case 78: {
                return this.getDetectedFacesDescription();
            }
            case 89: {
                return this.getTransformDescription();
            }
            case 32786: {
                return this.getTransform1Description();
            }
            case 93: {
                return this.getIntelligentExposureDescription();
            }
            case 98: {
                return this.getFlashWarningDescription();
            }
            case 105: {
                return this.getCountryDescription();
            }
            case 107: {
                return this.getStateDescription();
            }
            case 109: {
                return this.getCityDescription();
            }
            case 111: {
                return this.getLandmarkDescription();
            }
            case 112: {
                return this.getIntelligentResolutionDescription();
            }
            case 97: {
                return this.getRecognizedFacesDescription();
            }
            case 32769: {
                return this.getSceneModeDescription();
            }
            case 32775: {
                return this.getFlashFiredDescription();
            }
            case 59: {
                return this.getTextStampDescription();
            }
            case 62: {
                return this.getTextStamp1Description();
            }
            case 32776: {
                return this.getTextStamp2Description();
            }
            case 32777: {
                return this.getTextStamp3Description();
            }
            case 32768: {
                return this.getMakernoteVersionDescription();
            }
            case 38: {
                return this.getExifVersionDescription();
            }
            case 37: {
                return this.getInternalSerialNumberDescription();
            }
            case 101: {
                return this.getTitleDescription();
            }
            case 69: {
                return this.getBracketSettingsDescription();
            }
            case 72: {
                return this.getFlashCurtainDescription();
            }
            case 73: {
                return this.getLongExposureNoiseReductionDescription();
            }
            case 102: {
                return this.getBabyNameDescription();
            }
            case 103: {
                return this.getLocationDescription();
            }
            case 96: {
                return this.getLensFirmwareVersionDescription();
            }
            case 121: {
                return this.getIntelligentDRangeDescription();
            }
            case 124: {
                return this.getClearRetouchDescription();
            }
            case 137: {
                return this.getPhotoStyleDescription();
            }
            case 138: {
                return this.getShadingCompensationDescription();
            }
            case 140: {
                return this.getAccelerometerZDescription();
            }
            case 141: {
                return this.getAccelerometerXDescription();
            }
            case 142: {
                return this.getAccelerometerYDescription();
            }
            case 143: {
                return this.getCameraOrientationDescription();
            }
            case 144: {
                return this.getRollAngleDescription();
            }
            case 145: {
                return this.getPitchAngleDescription();
            }
            case 147: {
                return this.getSweepPanoramaDirectionDescription();
            }
            case 150: {
                return this.getTimerRecordingDescription();
            }
            case 158: {
                return this.getHDRDescription();
            }
            case 159: {
                return this.getShutterTypeDescription();
            }
            case 171: {
                return this.getTouchAeDescription();
            }
            case 51: {
                return this.getBabyAgeDescription();
            }
            case 32784: {
                return this.getBabyAge1Description();
            }
        }
        return super.getDescription(tagType);
    }

    @Nullable
    public String getTextStampDescription() {
        return this.getIndexedDescription(59, 1, "Off", "On");
    }

    @Nullable
    public String getTextStamp1Description() {
        return this.getIndexedDescription(62, 1, "Off", "On");
    }

    @Nullable
    public String getTextStamp2Description() {
        return this.getIndexedDescription(32776, 1, "Off", "On");
    }

    @Nullable
    public String getTextStamp3Description() {
        return this.getIndexedDescription(32777, 1, "Off", "On");
    }

    @Nullable
    public String getMacroModeDescription() {
        return this.getIndexedDescription(28, 1, "Off", "On");
    }

    @Nullable
    public String getFlashFiredDescription() {
        return this.getIndexedDescription(32775, 1, "Off", "On");
    }

    @Nullable
    public String getImageStabilizationDescription() {
        return this.getIndexedDescription(26, 2, "On, Mode 1", "Off", "On, Mode 2");
    }

    @Nullable
    public String getAudioDescription() {
        return this.getIndexedDescription(32, 1, "Off", "On");
    }

    @Nullable
    public String getTransformDescription() {
        return this.getTransformDescription(89);
    }

    @Nullable
    public String getTransform1Description() {
        return this.getTransformDescription(32786);
    }

    @Nullable
    private String getTransformDescription(int tag) {
        byte[] values = ((PanasonicMakernoteDirectory)this._directory).getByteArray(tag);
        if (values == null) {
            return null;
        }
        ByteArrayReader reader = new ByteArrayReader(values);
        try {
            int val1 = reader.getUInt16(0);
            int val2 = reader.getUInt16(2);
            if (val1 == -1 && val2 == 1) {
                return "Slim Low";
            }
            if (val1 == -3 && val2 == 2) {
                return "Slim High";
            }
            if (val1 == 0 && val2 == 0) {
                return "Off";
            }
            if (val1 == 1 && val2 == 1) {
                return "Stretch Low";
            }
            if (val1 == 3 && val2 == 2) {
                return "Stretch High";
            }
            return "Unknown (" + val1 + " " + val2 + ")";
        }
        catch (IOException e) {
            return null;
        }
    }

    @Nullable
    public String getIntelligentExposureDescription() {
        return this.getIndexedDescription(93, "Off", "Low", "Standard", "High");
    }

    @Nullable
    public String getFlashWarningDescription() {
        return this.getIndexedDescription(98, "No", "Yes (Flash required but disabled)");
    }

    @Nullable
    private static String trim(@Nullable String s) {
        return s == null ? null : s.trim();
    }

    @Nullable
    public String getCountryDescription() {
        return PanasonicMakernoteDescriptor.trim(this.getStringFromBytes(105, Charsets.UTF_8));
    }

    @Nullable
    public String getStateDescription() {
        return PanasonicMakernoteDescriptor.trim(this.getStringFromBytes(107, Charsets.UTF_8));
    }

    @Nullable
    public String getCityDescription() {
        return PanasonicMakernoteDescriptor.trim(this.getStringFromBytes(109, Charsets.UTF_8));
    }

    @Nullable
    public String getLandmarkDescription() {
        return PanasonicMakernoteDescriptor.trim(this.getStringFromBytes(111, Charsets.UTF_8));
    }

    @Nullable
    public String getTitleDescription() {
        return PanasonicMakernoteDescriptor.trim(this.getStringFromBytes(101, Charsets.UTF_8));
    }

    @Nullable
    public String getBracketSettingsDescription() {
        return this.getIndexedDescription(69, "No Bracket", "3 Images, Sequence 0/-/+", "3 Images, Sequence -/0/+", "5 Images, Sequence 0/-/+", "5 Images, Sequence -/0/+", "7 Images, Sequence 0/-/+", "7 Images, Sequence -/0/+");
    }

    @Nullable
    public String getFlashCurtainDescription() {
        return this.getIndexedDescription(72, "n/a", "1st", "2nd");
    }

    @Nullable
    public String getLongExposureNoiseReductionDescription() {
        return this.getIndexedDescription(73, 1, "Off", "On");
    }

    @Nullable
    public String getLensFirmwareVersionDescription() {
        byte[] bytes = ((PanasonicMakernoteDirectory)this._directory).getByteArray(96);
        if (bytes == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < bytes.length; ++i) {
            sb.append(bytes[i]);
            if (i >= bytes.length - 1) continue;
            sb.append(".");
        }
        return sb.toString();
    }

    @Nullable
    public String getIntelligentDRangeDescription() {
        return this.getIndexedDescription(121, "Off", "Low", "Standard", "High");
    }

    @Nullable
    public String getClearRetouchDescription() {
        return this.getIndexedDescription(124, "Off", "On");
    }

    @Nullable
    public String getPhotoStyleDescription() {
        return this.getIndexedDescription(137, "Auto", "Standard or Custom", "Vivid", "Natural", "Monochrome", "Scenery", "Portrait");
    }

    @Nullable
    public String getShadingCompensationDescription() {
        return this.getIndexedDescription(138, "Off", "On");
    }

    @Nullable
    public String getAccelerometerZDescription() {
        Integer value = ((PanasonicMakernoteDirectory)this._directory).getInteger(140);
        if (value == null) {
            return null;
        }
        return String.valueOf(value.shortValue());
    }

    @Nullable
    public String getAccelerometerXDescription() {
        Integer value = ((PanasonicMakernoteDirectory)this._directory).getInteger(141);
        if (value == null) {
            return null;
        }
        return String.valueOf(value.shortValue());
    }

    @Nullable
    public String getAccelerometerYDescription() {
        Integer value = ((PanasonicMakernoteDirectory)this._directory).getInteger(142);
        if (value == null) {
            return null;
        }
        return String.valueOf(value.shortValue());
    }

    @Nullable
    public String getCameraOrientationDescription() {
        return this.getIndexedDescription(143, "Normal", "Rotate CW", "Rotate 180", "Rotate CCW", "Tilt Upwards", "Tile Downwards");
    }

    @Nullable
    public String getRollAngleDescription() {
        Integer value = ((PanasonicMakernoteDirectory)this._directory).getInteger(144);
        if (value == null) {
            return null;
        }
        DecimalFormat format = new DecimalFormat("0.#");
        return format.format((double)value.shortValue() / 10.0);
    }

    @Nullable
    public String getPitchAngleDescription() {
        Integer value = ((PanasonicMakernoteDirectory)this._directory).getInteger(145);
        if (value == null) {
            return null;
        }
        DecimalFormat format = new DecimalFormat("0.#");
        return format.format((double)(-value.shortValue()) / 10.0);
    }

    @Nullable
    public String getSweepPanoramaDirectionDescription() {
        return this.getIndexedDescription(147, "Off", "Left to Right", "Right to Left", "Top to Bottom", "Bottom to Top");
    }

    @Nullable
    public String getTimerRecordingDescription() {
        return this.getIndexedDescription(150, "Off", "Time Lapse", "Stop-motion Animation");
    }

    @Nullable
    public String getHDRDescription() {
        Integer value = ((PanasonicMakernoteDirectory)this._directory).getInteger(158);
        if (value == null) {
            return null;
        }
        switch (value) {
            case 0: {
                return "Off";
            }
            case 100: {
                return "1 EV";
            }
            case 200: {
                return "2 EV";
            }
            case 300: {
                return "3 EV";
            }
            case 32868: {
                return "1 EV (Auto)";
            }
            case 32968: {
                return "2 EV (Auto)";
            }
            case 33068: {
                return "3 EV (Auto)";
            }
        }
        return String.format("Unknown (%d)", value);
    }

    @Nullable
    public String getShutterTypeDescription() {
        return this.getIndexedDescription(159, "Mechanical", "Electronic", "Hybrid");
    }

    @Nullable
    public String getTouchAeDescription() {
        return this.getIndexedDescription(171, "Off", "On");
    }

    @Nullable
    public String getBabyNameDescription() {
        return PanasonicMakernoteDescriptor.trim(this.getStringFromBytes(102, Charsets.UTF_8));
    }

    @Nullable
    public String getLocationDescription() {
        return PanasonicMakernoteDescriptor.trim(this.getStringFromBytes(103, Charsets.UTF_8));
    }

    @Nullable
    public String getIntelligentResolutionDescription() {
        return this.getIndexedDescription(112, "Off", null, "Auto", "On");
    }

    @Nullable
    public String getContrastDescription() {
        return this.getIndexedDescription(57, "Normal");
    }

    @Nullable
    public String getWorldTimeLocationDescription() {
        return this.getIndexedDescription(58, 1, "Home", "Destination");
    }

    @Nullable
    public String getAdvancedSceneModeDescription() {
        return this.getIndexedDescription(61, 1, "Normal", "Outdoor/Illuminations/Flower/HDR Art", "Indoor/Architecture/Objects/HDR B&W", "Creative", "Auto", null, "Expressive", "Retro", "Pure", "Elegant", null, "Monochrome", "Dynamic Art", "Silhouette");
    }

    @Nullable
    public String getUnknownDataDumpDescription() {
        return this.getByteLengthDescription(33);
    }

    @Nullable
    public String getColorEffectDescription() {
        return this.getIndexedDescription(40, 1, "Off", "Warm", "Cool", "Black & White", "Sepia");
    }

    @Nullable
    public String getUptimeDescription() {
        Integer value = ((PanasonicMakernoteDirectory)this._directory).getInteger(41);
        if (value == null) {
            return null;
        }
        return (float)value.intValue() / 100.0f + " s";
    }

    @Nullable
    public String getBurstModeDescription() {
        return this.getIndexedDescription(42, "Off", null, "On", "Indefinite", "Unlimited");
    }

    @Nullable
    public String getContrastModeDescription() {
        Integer value = ((PanasonicMakernoteDirectory)this._directory).getInteger(44);
        if (value == null) {
            return null;
        }
        switch (value) {
            case 0: {
                return "Normal";
            }
            case 1: {
                return "Low";
            }
            case 2: {
                return "High";
            }
            case 6: {
                return "Medium Low";
            }
            case 7: {
                return "Medium High";
            }
            case 256: {
                return "Low";
            }
            case 272: {
                return "Normal";
            }
            case 288: {
                return "High";
            }
        }
        return "Unknown (" + value + ")";
    }

    @Nullable
    public String getNoiseReductionDescription() {
        return this.getIndexedDescription(45, "Standard (0)", "Low (-1)", "High (+1)", "Lowest (-2)", "Highest (+2)");
    }

    @Nullable
    public String getSelfTimerDescription() {
        return this.getIndexedDescription(46, 1, "Off", "10 s", "2 s");
    }

    @Nullable
    public String getRotationDescription() {
        Integer value = ((PanasonicMakernoteDirectory)this._directory).getInteger(48);
        if (value == null) {
            return null;
        }
        switch (value) {
            case 1: {
                return "Horizontal";
            }
            case 3: {
                return "Rotate 180";
            }
            case 6: {
                return "Rotate 90 CW";
            }
            case 8: {
                return "Rotate 270 CW";
            }
        }
        return "Unknown (" + value + ")";
    }

    @Nullable
    public String getAfAssistLampDescription() {
        return this.getIndexedDescription(49, 1, "Fired", "Enabled but not used", "Disabled but required", "Disabled and not required");
    }

    @Nullable
    public String getColorModeDescription() {
        return this.getIndexedDescription(50, "Normal", "Natural", "Vivid");
    }

    @Nullable
    public String getOpticalZoomModeDescription() {
        return this.getIndexedDescription(52, 1, "Standard", "Extended");
    }

    @Nullable
    public String getConversionLensDescription() {
        return this.getIndexedDescription(53, 1, "Off", "Wide", "Telephoto", "Macro");
    }

    @Nullable
    public String getDetectedFacesDescription() {
        return this.buildFacesDescription(((PanasonicMakernoteDirectory)this._directory).getDetectedFaces());
    }

    @Nullable
    public String getRecognizedFacesDescription() {
        return this.buildFacesDescription(((PanasonicMakernoteDirectory)this._directory).getRecognizedFaces());
    }

    @Nullable
    private String buildFacesDescription(@Nullable Face[] faces) {
        if (faces == null) {
            return null;
        }
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < faces.length; ++i) {
            result.append("Face ").append(i + 1).append(": ").append(faces[i].toString()).append("\n");
        }
        return result.length() > 0 ? result.substring(0, result.length() - 1) : null;
    }

    @Nullable
    public String getRecordModeDescription() {
        return this.getIndexedDescription(31, 1, _sceneModes);
    }

    @Nullable
    public String getSceneModeDescription() {
        return this.getIndexedDescription(32769, 1, _sceneModes);
    }

    @Nullable
    public String getFocusModeDescription() {
        return this.getIndexedDescription(7, 1, "Auto", "Manual", null, "Auto, Focus Button", "Auto, Continuous");
    }

    @Nullable
    public String getAfAreaModeDescription() {
        int[] value = ((PanasonicMakernoteDirectory)this._directory).getIntArray(15);
        if (value == null || value.length < 2) {
            return null;
        }
        switch (value[0]) {
            case 0: {
                switch (value[1]) {
                    case 1: {
                        return "Spot Mode On";
                    }
                    case 16: {
                        return "Spot Mode Off";
                    }
                }
                return "Unknown (" + value[0] + " " + value[1] + ")";
            }
            case 1: {
                switch (value[1]) {
                    case 0: {
                        return "Spot Focusing";
                    }
                    case 1: {
                        return "5-area";
                    }
                }
                return "Unknown (" + value[0] + " " + value[1] + ")";
            }
            case 16: {
                switch (value[1]) {
                    case 0: {
                        return "1-area";
                    }
                    case 16: {
                        return "1-area (high speed)";
                    }
                }
                return "Unknown (" + value[0] + " " + value[1] + ")";
            }
            case 32: {
                switch (value[1]) {
                    case 0: {
                        return "Auto or Face Detect";
                    }
                    case 1: {
                        return "3-area (left)";
                    }
                    case 2: {
                        return "3-area (center)";
                    }
                    case 3: {
                        return "3-area (right)";
                    }
                }
                return "Unknown (" + value[0] + " " + value[1] + ")";
            }
            case 64: {
                return "Face Detect";
            }
        }
        return "Unknown (" + value[0] + " " + value[1] + ")";
    }

    @Nullable
    public String getQualityModeDescription() {
        return this.getIndexedDescription(1, 2, "High", "Normal", null, null, "Very High", "Raw", null, "Motion Picture");
    }

    @Nullable
    public String getVersionDescription() {
        return this.getVersionBytesDescription(2, 2);
    }

    @Nullable
    public String getMakernoteVersionDescription() {
        return this.getVersionBytesDescription(32768, 2);
    }

    @Nullable
    public String getExifVersionDescription() {
        return this.getVersionBytesDescription(38, 2);
    }

    @Nullable
    public String getInternalSerialNumberDescription() {
        return this.get7BitStringFromBytes(37);
    }

    @Nullable
    public String getWhiteBalanceDescription() {
        return this.getIndexedDescription(3, 1, "Auto", "Daylight", "Cloudy", "Incandescent", "Manual", null, null, "Flash", null, "Black & White", "Manual", "Shade");
    }

    @Nullable
    public String getBabyAgeDescription() {
        Age age = ((PanasonicMakernoteDirectory)this._directory).getAge(51);
        return age == null ? null : age.toFriendlyString();
    }

    @Nullable
    public String getBabyAge1Description() {
        Age age = ((PanasonicMakernoteDirectory)this._directory).getAge(32784);
        return age == null ? null : age.toFriendlyString();
    }
}

