/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.layer.geoimage;

import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.image.BufferedImage;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.stream.Collectors;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import org.openstreetmap.josm.actions.AutoScaleAction;
import org.openstreetmap.josm.actions.ExpertToggleAction;
import org.openstreetmap.josm.actions.RenameLayerAction;
import org.openstreetmap.josm.actions.mapmode.MapMode;
import org.openstreetmap.josm.actions.mapmode.SelectAction;
import org.openstreetmap.josm.actions.mapmode.SelectLassoAction;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.data.Data;
import org.openstreetmap.josm.data.ImageData;
import org.openstreetmap.josm.data.gpx.GpxData;
import org.openstreetmap.josm.data.gpx.GpxImageEntry;
import org.openstreetmap.josm.data.gpx.GpxTrack;
import org.openstreetmap.josm.data.gpx.WayPoint;
import org.openstreetmap.josm.data.imagery.street_level.IImageEntry;
import org.openstreetmap.josm.data.osm.visitor.BoundingXYVisitor;
import org.openstreetmap.josm.data.preferences.NamedColorProperty;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.MapFrame;
import org.openstreetmap.josm.gui.MapView;
import org.openstreetmap.josm.gui.NavigatableComponent;
import org.openstreetmap.josm.gui.dialogs.LayerListDialog;
import org.openstreetmap.josm.gui.dialogs.LayerListPopup;
import org.openstreetmap.josm.gui.layer.AbstractMapViewPaintable;
import org.openstreetmap.josm.gui.layer.AbstractModifiableLayer;
import org.openstreetmap.josm.gui.layer.GpxLayer;
import org.openstreetmap.josm.gui.layer.JumpToMarkerActions;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.gui.layer.MainLayerManager;
import org.openstreetmap.josm.gui.layer.MapViewPaintable;
import org.openstreetmap.josm.gui.layer.geoimage.CorrelateGpxWithImages;
import org.openstreetmap.josm.gui.layer.geoimage.EditImagesSequenceAction;
import org.openstreetmap.josm.gui.layer.geoimage.IGeoImageLayer;
import org.openstreetmap.josm.gui.layer.geoimage.ImageEntry;
import org.openstreetmap.josm.gui.layer.geoimage.ImageViewerDialog;
import org.openstreetmap.josm.gui.layer.geoimage.ImagesLoader;
import org.openstreetmap.josm.gui.layer.geoimage.ShowThumbnailAction;
import org.openstreetmap.josm.gui.layer.geoimage.ThumbsLoader;
import org.openstreetmap.josm.gui.util.GuiHelper;
import org.openstreetmap.josm.gui.util.imagery.Vector3D;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.ListenerList;
import org.openstreetmap.josm.tools.Utils;

public class GeoImageLayer
extends AbstractModifiableLayer
implements JumpToMarkerActions.JumpToMarkerLayer,
NavigatableComponent.ZoomChangeListener,
ImageData.ImageDataUpdateListener,
IGeoImageLayer {
    private static final List<Action> menuAdditions = new LinkedList<Action>();
    private static volatile List<MapMode> supportedMapModes;
    private final ImageData data;
    private final ListenerList<IGeoImageLayer.ImageChangeListener> imageChangeListeners = ListenerList.create();
    GpxData gpxData;
    GpxLayer gpxFauxLayer;
    GpxData gpxFauxData;
    private CorrelateGpxWithImages gpxCorrelateAction;
    private final Icon icon = ImageProvider.get("dialogs/geoimage/photo-marker");
    private final Icon selectedIcon = ImageProvider.get("dialogs/geoimage/photo-marker-selected");
    private final Icon selectedIconNotImageViewer = GeoImageLayer.generateSelectedIconNotImageViewer(this.selectedIcon);
    boolean useThumbs;
    private final ExecutorService thumbsLoaderExecutor = Executors.newSingleThreadExecutor(Utils.newThreadFactory("thumbnail-loader-%d", 1));
    private ThumbsLoader thumbsloader;
    private boolean thumbsLoaderRunning;
    volatile boolean thumbsLoaded;
    private BufferedImage offscreenBuffer;
    private boolean updateOffscreenBuffer = true;
    private MouseAdapter mouseAdapter;
    private MouseMotionAdapter mouseMotionAdapter;
    private MapFrame.MapModeChangeListener mapModeListener;
    private MainLayerManager.ActiveLayerChangeListener activeLayerChangeListener;
    private Point lastSelPos;
    private Point startPoint;
    private boolean cycleModeArmed;

    private static Icon generateSelectedIconNotImageViewer(Icon selectedIcon) {
        Color color = new NamedColorProperty("geoimage.selected.not.image.viewer", new Color(50, 0, 0)).get();
        BufferedImage bi = new BufferedImage(selectedIcon.getIconWidth(), selectedIcon.getIconHeight(), 2);
        Graphics2D g2d = bi.createGraphics();
        selectedIcon.paintIcon(null, g2d, 0, 0);
        g2d.setComposite(AlphaComposite.getInstance(10, 0.5f));
        g2d.setColor(color);
        g2d.fillRect(0, 0, selectedIcon.getIconWidth(), selectedIcon.getIconHeight());
        g2d.dispose();
        return new ImageIcon(bi);
    }

    public GeoImageLayer(List<ImageEntry> data, GpxLayer gpxLayer) {
        this(data, gpxLayer, null, false);
    }

    public GeoImageLayer(List<ImageEntry> data, GpxLayer gpxLayer, String name) {
        this(data, gpxLayer, name, false);
    }

    public GeoImageLayer(List<ImageEntry> data, GpxLayer gpxLayer, boolean useThumbs) {
        this(data, gpxLayer, null, useThumbs);
    }

    public GeoImageLayer(List<ImageEntry> data, GpxLayer gpxLayer, String name, boolean useThumbs) {
        this(data, gpxLayer != null ? gpxLayer.data : null, name, useThumbs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GeoImageLayer(List<ImageEntry> data, GpxData gpxData, String name, boolean useThumbs) {
        super(!Utils.isBlank(name) ? name : I18n.tr("Geotagged Images", new Object[0]));
        this.data = new ImageData(data);
        this.gpxData = gpxData;
        this.useThumbs = useThumbs;
        this.data.addImageDataUpdateListener(this);
        this.data.setLayer(this);
        Class<ImageViewerDialog> clazz = ImageViewerDialog.class;
        synchronized (ImageViewerDialog.class) {
            if (!ImageViewerDialog.hasInstance()) {
                GuiHelper.runInEDTAndWait(ImageViewerDialog::createInstance);
            }
            // ** MonitorExit[var5_5] (shouldn't be in output)
            if (this.getInvalidGeoImages().size() == data.size()) {
                this.data.setSelectedImage(this.data.getFirstImage());
                MainApplication.worker.execute(() -> GuiHelper.runInEDT(() -> ImageViewerDialog.getInstance().displayImages(this.getSelection())));
            }
            return;
        }
    }

    public static void create(Collection<File> files, GpxLayer gpxLayer) {
        MainApplication.worker.execute(new ImagesLoader(files, gpxLayer));
    }

    @Override
    public void clearSelection() {
        this.getImageData().clearSelectedImage();
    }

    @Override
    public boolean containsImage(IImageEntry<?> imageEntry) {
        if (imageEntry instanceof ImageEntry) {
            return this.data.getImages().contains(imageEntry);
        }
        return false;
    }

    @Override
    public Icon getIcon() {
        return ImageProvider.get("dialogs/geoimage", ImageProvider.ImageSizes.LAYER);
    }

    public List<ImageEntry> getSelection() {
        return this.getImageData().getSelectedImages();
    }

    @Override
    public List<IImageEntry<?>> getInvalidGeoImages() {
        return this.getImageData().getImages().stream().filter(entry -> entry.getPos() == null || !entry.getPos().isValid()).collect(Collectors.toList());
    }

    @Override
    public void addImageChangeListener(IGeoImageLayer.ImageChangeListener listener) {
        this.imageChangeListeners.addListener(listener);
    }

    @Override
    public void removeImageChangeListener(IGeoImageLayer.ImageChangeListener listener) {
        this.imageChangeListeners.removeListener(listener);
    }

    public static void registerMenuAddition(Action addition) {
        menuAdditions.add(addition);
    }

    @Override
    public Action[] getMenuEntries() {
        ArrayList<Action> entries = new ArrayList<Action>();
        entries.add(LayerListDialog.getInstance().createShowHideLayerAction());
        entries.add(LayerListDialog.getInstance().createDeleteLayerAction());
        entries.add(MainApplication.getMenu().autoScaleActions.get((Object)AutoScaleAction.AutoScaleMode.LAYER));
        entries.add(LayerListDialog.getInstance().createMergeLayerAction(this));
        entries.add(new RenameLayerAction(null, this));
        entries.add(Layer.SeparatorLayerAction.INSTANCE);
        entries.add(this.getGpxCorrelateAction());
        if (ExpertToggleAction.isExpert()) {
            entries.add(new EditImagesSequenceAction(this));
            entries.add(new Layer.LayerGpxExportAction(this));
        }
        entries.add(new ShowThumbnailAction(this));
        if (!menuAdditions.isEmpty()) {
            entries.add(Layer.SeparatorLayerAction.INSTANCE);
            entries.addAll(menuAdditions);
        }
        entries.add(Layer.SeparatorLayerAction.INSTANCE);
        entries.add(new JumpToMarkerActions.JumpToNextMarker(this));
        entries.add(new JumpToMarkerActions.JumpToPreviousMarker(this));
        entries.add(Layer.SeparatorLayerAction.INSTANCE);
        entries.add(new LayerListPopup.InfoAction(this));
        return entries.toArray(new Action[0]);
    }

    private String infoText() {
        int tagged = 0;
        int newdata = 0;
        int n = this.data.getImages().size();
        for (ImageEntry e : this.data.getImages()) {
            if (e.getPos() != null) {
                ++tagged;
            }
            if (!e.hasNewGpsData()) continue;
            ++newdata;
        }
        return "<html>" + I18n.trn("{0} image loaded.", "{0} images loaded.", n, n) + ' ' + I18n.trn("{0} was found to be GPS tagged.", "{0} were found to be GPS tagged.", tagged, tagged) + (newdata > 0 ? "<br>" + I18n.trn("{0} has updated GPS data.", "{0} have updated GPS data.", newdata, newdata) : "") + "</html>";
    }

    @Override
    public Object getInfoComponent() {
        return this.infoText();
    }

    @Override
    public String getToolTipText() {
        return this.infoText();
    }

    @Override
    public boolean isModified() {
        return this.data.isModified();
    }

    @Override
    public boolean isMergable(Layer other) {
        return other instanceof GeoImageLayer;
    }

    @Override
    public void mergeFrom(Layer from) {
        if (!(from instanceof GeoImageLayer)) {
            throw new IllegalArgumentException("not a GeoImageLayer: " + from);
        }
        GeoImageLayer l = (GeoImageLayer)from;
        this.stopLoadThumbs();
        l.stopLoadThumbs();
        this.data.mergeFrom(l.getImageData());
        this.setName(l.getName());
        this.thumbsLoaded &= l.thumbsLoaded;
    }

    private static Dimension scaledDimension(Image thumb) {
        double d = MainApplication.getMap().mapView.getDist100Pixel();
        double size = 10.0;
        double s = 1000.0 / d;
        double sMin = 22.0;
        double sMax = 120.0;
        if (s < 22.0) {
            s = 22.0;
        }
        if (s > 120.0) {
            s = 120.0;
        }
        double f = s / 120.0;
        if (thumb == null) {
            return null;
        }
        return new Dimension((int)Math.round(f * (double)thumb.getWidth(null)), (int)Math.round(f * (double)thumb.getHeight(null)));
    }

    private void paintImage(ImageEntry e, MapView mv, Rectangle clip, Graphics2D tempG) {
        if (e.getPos() == null) {
            return;
        }
        Point p = mv.getPoint(e.getPos());
        if (e.hasThumbnail()) {
            Rectangle target;
            Dimension d = GeoImageLayer.scaledDimension(e.getThumbnail());
            if (d != null && clip.intersects(target = new Rectangle(p.x - d.width / 2, p.y - d.height / 2, d.width, d.height))) {
                tempG.drawImage(e.getThumbnail(), target.x, target.y, target.width, target.height, null);
            }
        } else {
            this.icon.paintIcon(mv, tempG, p.x - this.icon.getIconWidth() / 2, p.y - this.icon.getIconHeight() / 2);
        }
    }

    @Override
    public void paint(Graphics2D g, MapView mv, Bounds bounds) {
        int width = mv.getWidth();
        int height = mv.getHeight();
        Rectangle clip = g.getClipBounds();
        if (this.useThumbs) {
            if (!this.thumbsLoaded) {
                this.startLoadThumbs();
            }
            if (null == this.offscreenBuffer || this.offscreenBuffer.getWidth() != width || this.offscreenBuffer.getHeight() != height) {
                this.offscreenBuffer = new BufferedImage(width, height, 2);
                this.updateOffscreenBuffer = true;
            }
            if (this.updateOffscreenBuffer) {
                Graphics2D tempG = this.offscreenBuffer.createGraphics();
                tempG.setColor(new Color(0, 0, 0, 0));
                Composite saveComp = tempG.getComposite();
                tempG.setComposite(AlphaComposite.Clear);
                tempG.fillRect(0, 0, width, height);
                tempG.setComposite(saveComp);
                for (ImageEntry e : this.data.searchImages(bounds)) {
                    this.paintImage(e, mv, clip, tempG);
                }
                for (ImageEntry img : this.data.getSelectedImages()) {
                    this.paintImage(img, mv, clip, tempG);
                }
                this.updateOffscreenBuffer = false;
            }
            g.drawImage((Image)this.offscreenBuffer, 0, 0, null);
        } else {
            for (ImageEntry e : this.data.searchImages(bounds)) {
                if (e.getPos() == null) continue;
                Point p = mv.getPoint(e.getPos());
                this.icon.paintIcon(mv, g, p.x - this.icon.getIconWidth() / 2, p.y - this.icon.getIconHeight() / 2);
            }
        }
        IImageEntry<?> currentImage = ImageViewerDialog.getCurrentImage();
        for (ImageEntry e : this.data.getSelectedImages()) {
            if (e == null || e.getPos() == null) continue;
            Point p = mv.getPoint(e.getPos());
            Dimension imgDim = this.getImageDimension(e);
            if (e.getExifImgDir() != null) {
                Vector3D imgRotation = ImageViewerDialog.getInstance().getRotation(e);
                GeoImageLayer.drawDirectionArrow(g, p, e.getExifImgDir() + (imgRotation != null ? Utils.toDegrees(imgRotation.getPolarAngle()) : 0.0), imgDim);
            }
            if (this.useThumbs && e.hasThumbnail()) {
                g.setColor(new Color(128, 0, 0, 122));
                g.fillRect(p.x - imgDim.width / 2, p.y - imgDim.height / 2, imgDim.width, imgDim.height);
                continue;
            }
            if (e.equals(currentImage)) {
                this.selectedIcon.paintIcon(mv, g, p.x - imgDim.width / 2, p.y - imgDim.height / 2);
                continue;
            }
            this.selectedIconNotImageViewer.paintIcon(mv, g, p.x - imgDim.width / 2, p.y - imgDim.height / 2);
        }
    }

    protected Dimension getImageDimension(ImageEntry e) {
        if (this.useThumbs && e.hasThumbnail()) {
            Dimension d = GeoImageLayer.scaledDimension(e.getThumbnail());
            return d != null ? d : new Dimension(-1, -1);
        }
        return new Dimension(this.selectedIcon.getIconWidth(), this.selectedIcon.getIconHeight());
    }

    protected static void drawDirectionArrow(Graphics2D g, Point p, double dir, Dimension imgDim) {
        double arrowlength = Math.max(25.0, (double)Math.max(imgDim.width, imgDim.height) * 0.85);
        double arrowwidth = arrowlength / 1.4;
        double headdir = dir < 90.0 ? dir + 270.0 : dir - 90.0;
        double leftdir = headdir < 90.0 ? headdir + 270.0 : headdir - 90.0;
        double rightdir = headdir > 270.0 ? headdir - 270.0 : headdir + 90.0;
        double ptx = (double)p.x + Math.cos(Utils.toRadians(headdir)) * arrowlength;
        double pty = (double)p.y + Math.sin(Utils.toRadians(headdir)) * arrowlength;
        double ltx = (double)p.x + Math.cos(Utils.toRadians(leftdir)) * arrowwidth / 2.0;
        double lty = (double)p.y + Math.sin(Utils.toRadians(leftdir)) * arrowwidth / 2.0;
        double rtx = (double)p.x + Math.cos(Utils.toRadians(rightdir)) * arrowwidth / 2.0;
        double rty = (double)p.y + Math.sin(Utils.toRadians(rightdir)) * arrowwidth / 2.0;
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g.setColor(new Color(255, 255, 255, 192));
        int[] xar = new int[]{(int)ltx, (int)ptx, (int)rtx, (int)ltx};
        int[] yar = new int[]{(int)lty, (int)pty, (int)rty, (int)lty};
        g.fillPolygon(xar, yar, 4);
        g.setColor(Color.black);
        g.setStroke(new BasicStroke(1.2f));
        g.drawPolyline(xar, yar, 3);
    }

    @Override
    public void visitBoundingBox(BoundingXYVisitor v) {
        for (ImageEntry e : this.data.getImages()) {
            v.visit(e.getPos());
        }
    }

    public void showCurrentPhoto() {
        this.updateBufferAndRepaint();
    }

    private boolean isPhotoIdxUnderMouse(int idx, MouseEvent evt) {
        ImageEntry img = this.data.getImages().get(idx);
        if (img.getPos() != null) {
            Dimension imgDim;
            Point imgCenter = MainApplication.getMap().mapView.getPoint(img.getPos());
            Rectangle imgRect = this.useThumbs && img.hasThumbnail() ? ((imgDim = GeoImageLayer.scaledDimension(img.getThumbnail())) != null ? new Rectangle(imgCenter.x - imgDim.width / 2, imgCenter.y - imgDim.height / 2, imgDim.width, imgDim.height) : null) : new Rectangle(imgCenter.x - this.icon.getIconWidth() / 2, imgCenter.y - this.icon.getIconHeight() / 2, this.icon.getIconWidth(), this.icon.getIconHeight());
            if (imgRect != null && imgRect.contains(evt.getPoint())) {
                return true;
            }
        }
        return false;
    }

    private int getPhotoIdxUnderMouse(MouseEvent evt, boolean cycle) {
        ImageEntry selectedImage = this.data.getSelectedImage();
        int selectedIndex = this.data.getImages().indexOf(selectedImage);
        if (cycle && selectedImage != null) {
            int idx;
            for (idx = selectedIndex + 1; idx < this.data.getImages().size(); ++idx) {
                if (!this.isPhotoIdxUnderMouse(idx, evt)) continue;
                return idx;
            }
            for (idx = 0; idx <= selectedIndex; ++idx) {
                if (!this.isPhotoIdxUnderMouse(idx, evt)) continue;
                return idx;
            }
        } else {
            if (selectedImage != null && this.isPhotoIdxUnderMouse(selectedIndex, evt)) {
                return selectedIndex;
            }
            for (int idx = this.data.getImages().size() - 1; idx >= 0; --idx) {
                if (!this.isPhotoIdxUnderMouse(idx, evt)) continue;
                return idx;
            }
        }
        return -1;
    }

    private int getPhotoIdxUnderMouse(MouseEvent evt) {
        return this.getPhotoIdxUnderMouse(evt, false);
    }

    public ImageEntry getPhotoUnderMouse(MouseEvent evt) {
        int idx = this.getPhotoIdxUnderMouse(evt);
        if (idx >= 0) {
            return this.data.getImages().get(idx);
        }
        return null;
    }

    public static void registerSupportedMapMode(MapMode mapMode) {
        if (supportedMapModes == null) {
            supportedMapModes = new ArrayList<MapMode>();
        }
        supportedMapModes.add(mapMode);
    }

    private static boolean isSupportedMapMode(MapMode mapMode) {
        if (mapMode instanceof SelectAction || mapMode instanceof SelectLassoAction) {
            return true;
        }
        return supportedMapModes != null && supportedMapModes.stream().anyMatch(supmmode -> mapMode == supmmode);
    }

    @Override
    public void hookUpMapView() {
        this.mouseAdapter = new ImageMouseListener();
        this.mouseMotionAdapter = new MouseMotionAdapter(){

            @Override
            public void mouseMoved(MouseEvent evt) {
                GeoImageLayer.this.lastSelPos = null;
            }

            @Override
            public void mouseDragged(MouseEvent evt) {
                GeoImageLayer.this.lastSelPos = null;
            }
        };
        this.mapModeListener = (oldMapMode, newMapMode) -> {
            MapView mapView = MainApplication.getMap().mapView;
            if (newMapMode == null || GeoImageLayer.isSupportedMapMode(newMapMode)) {
                mapView.addMouseListener(this.mouseAdapter);
                mapView.addMouseMotionListener(this.mouseMotionAdapter);
            } else {
                mapView.removeMouseListener(this.mouseAdapter);
                mapView.removeMouseMotionListener(this.mouseMotionAdapter);
            }
        };
        MapFrame.addMapModeChangeListener(this.mapModeListener);
        this.mapModeListener.mapModeChange(null, MainApplication.getMap().mapMode);
        this.activeLayerChangeListener = e -> {
            if (MainApplication.getLayerManager().getActiveLayer() == this) {
                MainApplication.getMap().selectSelectTool(false);
            }
        };
        MainApplication.getLayerManager().addActiveLayerChangeListener(this.activeLayerChangeListener);
    }

    @Override
    public synchronized void destroy() {
        super.destroy();
        this.stopLoadThumbs();
        if (this.gpxCorrelateAction != null) {
            this.gpxCorrelateAction.destroy();
            this.gpxCorrelateAction = null;
        }
        MapView mapView = MainApplication.getMap().mapView;
        mapView.removeMouseListener(this.mouseAdapter);
        mapView.removeMouseMotionListener(this.mouseMotionAdapter);
        MapView.removeZoomChangeListener(this);
        MapFrame.removeMapModeChangeListener(this.mapModeListener);
        MainApplication.getLayerManager().removeActiveLayerChangeListener(this.activeLayerChangeListener);
        this.data.removeImageDataUpdateListener(this);
    }

    @Override
    public MapViewPaintable.LayerPainter attachToMapView(MapViewPaintable.MapViewEvent event) {
        MapView.addZoomChangeListener(this);
        return new AbstractMapViewPaintable.CompatibilityModeLayerPainter(){

            @Override
            public void detachFromMapView(MapViewPaintable.MapViewEvent event) {
                MapView.removeZoomChangeListener(GeoImageLayer.this);
            }
        };
    }

    @Override
    public void zoomChanged() {
        this.updateBufferAndRepaint();
    }

    public synchronized void startLoadThumbs() {
        if (this.useThumbs && !this.thumbsLoaded && !this.thumbsLoaderRunning) {
            this.stopLoadThumbs();
            this.thumbsloader = new ThumbsLoader(this);
            this.thumbsLoaderExecutor.submit(this.thumbsloader);
            this.thumbsLoaderRunning = true;
        }
    }

    public synchronized void stopLoadThumbs() {
        if (this.thumbsloader != null) {
            this.thumbsloader.stop = true;
        }
        this.thumbsLoaderRunning = false;
    }

    public void thumbsLoaded() {
        this.thumbsLoaded = true;
    }

    public void updateBufferAndRepaint() {
        this.updateOffscreenBuffer = true;
        this.invalidate();
    }

    public List<ImageEntry> getImages() {
        return new ArrayList<ImageEntry>(this.data.getImages());
    }

    public ImageData getImageData() {
        return this.data;
    }

    public GpxData getGpxData() {
        return this.gpxData;
    }

    public GpxLayer getGpxLayer() {
        return this.gpxData != null ? MainApplication.getLayerManager().getLayersOfType(GpxLayer.class).stream().filter(l -> this.gpxData.equals(l.getGpxData())).findFirst().orElseThrow(() -> new IllegalStateException()) : null;
    }

    public CorrelateGpxWithImages getGpxCorrelateAction() {
        if (this.gpxCorrelateAction == null) {
            this.gpxCorrelateAction = new CorrelateGpxWithImages(this);
        }
        return this.gpxCorrelateAction;
    }

    public synchronized GpxLayer getFauxGpxLayer() {
        GpxLayer gpxLayer = this.getGpxLayer();
        if (gpxLayer != null) {
            return gpxLayer;
        }
        if (this.gpxFauxLayer == null) {
            this.gpxFauxLayer = new GpxLayer(this.getFauxGpxData());
        }
        return this.gpxFauxLayer;
    }

    public synchronized GpxData getFauxGpxData() {
        GpxLayer gpxLayer = this.getGpxLayer();
        if (gpxLayer != null) {
            return gpxLayer.data;
        }
        if (this.gpxFauxData == null) {
            this.gpxFauxData = new GpxData();
            this.gpxFauxData.addTrack(new GpxTrack((Collection<Collection<WayPoint>>)Arrays.asList(this.data.getImages().stream().map(GpxImageEntry::asWayPoint).filter(Objects::nonNull).collect(Collectors.toList())), Collections.emptyMap()));
        }
        return this.gpxFauxData;
    }

    @Override
    public void jumpToNextMarker() {
        this.data.setSelectedImage(this.data.getNextImage());
    }

    @Override
    public void jumpToPreviousMarker() {
        this.data.setSelectedImage(this.data.getPreviousImage());
    }

    public boolean isUseThumbs() {
        return this.useThumbs;
    }

    public void setUseThumbs(boolean useThumbs) {
        this.useThumbs = useThumbs;
        if (useThumbs && !this.thumbsLoaded) {
            this.startLoadThumbs();
        } else if (!useThumbs) {
            this.stopLoadThumbs();
        }
        this.invalidate();
    }

    @Override
    public void selectedImageChanged(ImageData data) {
        this.showCurrentPhoto();
        this.imageChangeListeners.fireEvent(e -> e.imageChanged(this, null, data.getSelectedImages()));
    }

    @Override
    public void imageDataUpdated(ImageData data) {
        this.updateBufferAndRepaint();
    }

    @Override
    public String getChangesetSourceTag() {
        return "Geotagged Images";
    }

    @Override
    public Data getData() {
        return this.data;
    }

    void applyTmp() {
        this.data.getImages().forEach(GpxImageEntry::applyTmp);
    }

    void discardTmp() {
        this.data.getImages().forEach(GpxImageEntry::discardTmp);
    }

    List<ImageEntry> getSortedImgList(boolean exif, boolean tagged) {
        return this.data.getImages().stream().filter(GpxImageEntry::hasExifTime).filter(e -> e.getExifCoor() == null || exif).filter(e -> tagged || !e.isTagged() || e.getExifCoor() != null).sorted(Comparator.comparing(GpxImageEntry::getExifInstant)).collect(Collectors.toList());
    }

    private final class ImageMouseListener
    extends MouseAdapter {
        private ImageMouseListener() {
        }

        private boolean isMapModeOk() {
            MapMode mapMode = MainApplication.getMap().mapMode;
            return mapMode == null || GeoImageLayer.isSupportedMapMode(mapMode);
        }

        @Override
        public void mousePressed(MouseEvent e) {
            if (e.getButton() != 1) {
                return;
            }
            if (GeoImageLayer.this.isVisible() && this.isMapModeOk()) {
                GeoImageLayer.this.cycleModeArmed = true;
                GeoImageLayer.this.invalidate();
                GeoImageLayer.this.startPoint = e.getPoint();
            }
        }

        @Override
        public void mouseReleased(MouseEvent ev) {
            if (ev.getButton() != 1) {
                return;
            }
            if (!GeoImageLayer.this.isVisible() || !this.isMapModeOk()) {
                return;
            }
            if (!GeoImageLayer.this.cycleModeArmed) {
                return;
            }
            Rectangle hitBoxClick = new Rectangle((int)GeoImageLayer.this.startPoint.getX() - 10, (int)GeoImageLayer.this.startPoint.getY() - 10, 15, 15);
            if (!hitBoxClick.contains(ev.getPoint())) {
                return;
            }
            Point mousePos = ev.getPoint();
            boolean cycle = GeoImageLayer.this.cycleModeArmed && GeoImageLayer.this.lastSelPos != null && GeoImageLayer.this.lastSelPos.equals(mousePos);
            boolean isShift = (ev.getModifiersEx() & 0x40) == 64;
            boolean isCtrl = (ev.getModifiersEx() & 0x80) == 128;
            int idx = GeoImageLayer.this.getPhotoIdxUnderMouse(ev, cycle);
            if (idx >= 0) {
                GeoImageLayer.this.lastSelPos = mousePos;
                GeoImageLayer.this.cycleModeArmed = false;
                ImageEntry img = GeoImageLayer.this.data.getImages().get(idx);
                if (isShift) {
                    if (isCtrl && !GeoImageLayer.this.data.getSelectedImages().isEmpty()) {
                        int idx2 = GeoImageLayer.this.data.getImages().indexOf(GeoImageLayer.this.data.getSelectedImages().get(GeoImageLayer.this.data.getSelectedImages().size() - 1));
                        int startIndex = Math.min(idx, idx2);
                        int endIndex = Math.max(idx, idx2);
                        for (int i = startIndex; i <= endIndex; ++i) {
                            GeoImageLayer.this.data.addImageToSelection(GeoImageLayer.this.data.getImages().get(i));
                        }
                    } else if (GeoImageLayer.this.data.isImageSelected(img)) {
                        GeoImageLayer.this.data.removeImageToSelection(img);
                    } else {
                        GeoImageLayer.this.data.addImageToSelection(img);
                    }
                } else {
                    GeoImageLayer.this.data.setSelectedImage(img);
                    ImageViewerDialog.getInstance().displayImages(Collections.singletonList(img));
                }
                GeoImageLayer.this.invalidate();
            }
        }
    }
}

