/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.mappaint.styleelement.placement;

import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import org.openstreetmap.josm.gui.draw.MapViewPath;
import org.openstreetmap.josm.gui.draw.MapViewPositionAndRotation;
import org.openstreetmap.josm.gui.mappaint.styleelement.placement.CompletelyInsideAreaStrategy;
import org.openstreetmap.josm.gui.mappaint.styleelement.placement.PositionForAreaStrategy;

public final class PartiallyInsideAreaStrategy
extends CompletelyInsideAreaStrategy {
    public static final PartiallyInsideAreaStrategy INSTANCE = new PartiallyInsideAreaStrategy(0.0, 0.0);

    private PartiallyInsideAreaStrategy(double offsetX, double offsetY) {
        super(offsetX, offsetY);
    }

    @Override
    public MapViewPositionAndRotation findLabelPlacement(MapViewPath path, Rectangle2D nb) {
        MapViewPositionAndRotation inside = super.findLabelPlacement(path, nb);
        if (inside != null) {
            return inside;
        }
        double nbdx = Math.max(0.0, (nb.getWidth() - 20.0) / 2.0);
        double nbdy = Math.max(0.0, (nb.getHeight() - 10.0) / 2.0);
        if (nbdx < 0.5 && nbdy < 0.5) {
            return null;
        }
        Rectangle2D.Double smallNb = new Rectangle2D.Double(nb.getX() + nbdx, nb.getY() + nbdy, nb.getWidth() - 2.0 * nbdx, nb.getHeight() - 2.0 * nbdy);
        return super.findLabelPlacement(path, smallNb);
    }

    @Override
    public PositionForAreaStrategy withAddedOffset(Point2D addToOffset) {
        if (Math.abs(addToOffset.getX()) < 1.0E-5 && Math.abs(addToOffset.getY()) < 1.0E-5) {
            return this;
        }
        return new PartiallyInsideAreaStrategy(this.offsetX + addToOffset.getX(), this.offsetY - addToOffset.getY());
    }

    @Override
    public String toString() {
        return "PartiallyInsideAreaStrategy [offsetX=" + this.offsetX + ", offsetY=" + this.offsetY + "]";
    }
}

