/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.io.rtklib;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.gpx.GpxData;
import org.openstreetmap.josm.data.gpx.GpxTrack;
import org.openstreetmap.josm.data.gpx.WayPoint;
import org.openstreetmap.josm.io.IGpxReader;
import org.openstreetmap.josm.tools.Logging;
import org.openstreetmap.josm.tools.date.DateUtils;
import org.xml.sax.SAXException;

public class RtkLibPosReader
implements IGpxReader {
    private static final int IDX_DATE = 0;
    private static final int IDX_TIME = 1;
    private static final int IDX_LAT = 2;
    private static final int IDX_LON = 3;
    private static final int IDX_HEIGHT = 4;
    private static final int IDX_Q = 5;
    private static final int IDX_NS = 6;
    private static final int IDX_SDN = 7;
    private static final int IDX_SDE = 8;
    private static final int IDX_SDU = 9;
    private static final int IDX_SDNE = 10;
    private static final int IDX_SDEU = 11;
    private static final int IDX_SDUN = 12;
    private static final int IDX_AGE = 13;
    private static final int IDX_RATIO = 14;
    private final InputStream source;
    private GpxData data;
    private int success;

    public RtkLibPosReader(InputStream source) throws IOException {
        this.source = Objects.requireNonNull(source);
    }

    @Override
    public boolean parse(boolean tryToFinish) throws SAXException, IOException {
        this.data = new GpxData();
        ArrayList<Collection<WayPoint>> currentTrack = new ArrayList<Collection<WayPoint>>();
        ArrayList<WayPoint> waypoints = new ArrayList<WayPoint>();
        try (BufferedReader rd = new BufferedReader(new InputStreamReader(this.source, StandardCharsets.UTF_8));){
            String line;
            do {
                if ((line = rd.readLine()) == null || line.startsWith("% ref pos   :") || line.startsWith("%")) continue;
                try {
                    String[] fields = line.split("[ ]+", -1);
                    WayPoint currentwp = new WayPoint(new LatLon(Double.parseDouble(fields[2]), Double.parseDouble(fields[3])));
                    currentwp.put("ele", fields[4]);
                    currentwp.setInstant(DateUtils.parseInstant(fields[0] + " " + fields[1]));
                    currentwp.put("Q", Integer.parseInt(fields[5]));
                    currentwp.put("sat", fields[6]);
                    currentwp.put("sdn", fields[7]);
                    currentwp.put("sde", fields[8]);
                    currentwp.put("sde", fields[9]);
                    currentwp.put("sdne", fields[10]);
                    currentwp.put("sdeu", fields[11]);
                    currentwp.put("sdun", fields[12]);
                    currentwp.put("age", fields[13]);
                    currentwp.put("ratio", fields[14]);
                    double sdn = Double.parseDouble(fields[7]);
                    double sde = Double.parseDouble(fields[7]);
                    currentwp.put("hdop", Float.valueOf((float)Math.sqrt(sdn * sdn + sde * sde)));
                    waypoints.add(currentwp);
                    ++this.success;
                }
                catch (IllegalArgumentException e) {
                    Logging.error(e);
                }
            } while (line != null);
        }
        currentTrack.add(waypoints);
        this.data.tracks.add(new GpxTrack((Collection<Collection<WayPoint>>)currentTrack, Collections.emptyMap()));
        return true;
    }

    @Override
    public GpxData getGpxData() {
        return this.data;
    }

    public int getNumberOfCoordinates() {
        return this.success;
    }
}

