/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.layer.geoimage;

import java.awt.Dimension;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.commons.jcs3.access.behavior.ICacheAccess;
import org.openstreetmap.josm.data.cache.BufferedImageCacheEntry;
import org.openstreetmap.josm.data.cache.JCSCacheManager;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.layer.geoimage.GeoImageLayer;
import org.openstreetmap.josm.gui.layer.geoimage.ImageEntry;
import org.openstreetmap.josm.spi.preferences.Config;
import org.openstreetmap.josm.tools.Logging;
import org.openstreetmap.josm.tools.Stopwatch;

public class ThumbsLoader
implements Runnable {
    public static final int maxSize = 120;
    public static final int minSize = 22;
    public volatile boolean stop;
    private final Collection<ImageEntry> data;
    private final GeoImageLayer layer;
    private ICacheAccess<String, BufferedImageCacheEntry> cache;
    private final boolean cacheOff = Config.getPref().getBoolean("geoimage.noThumbnailCache", false);

    private ThumbsLoader(Collection<ImageEntry> data, GeoImageLayer layer) {
        this.data = data;
        this.layer = layer;
        this.initCache();
    }

    public ThumbsLoader(GeoImageLayer layer) {
        this(new ArrayList<ImageEntry>(layer.getImageData().getImages()), layer);
    }

    public ThumbsLoader(Collection<ImageEntry> entries) {
        this(entries, null);
    }

    private void initCache() {
        if (!this.cacheOff) {
            this.cache = JCSCacheManager.getCache("geoimage-thumbnails", 0, 120, Config.getDirs().getCacheDirectory(true).getPath() + File.separator + "geoimage-thumbnails");
        }
    }

    @Override
    public void run() {
        int count = 0;
        Stopwatch stopwatch = Stopwatch.createStarted();
        Logging.debug("Loading {0} thumbnails", this.data.size());
        for (ImageEntry entry : this.data) {
            if (this.stop) {
                return;
            }
            if (!entry.hasThumbnail()) {
                entry.setThumbnail(this.loadThumb(entry));
                if (this.layer != null && MainApplication.isDisplayingMapView()) {
                    this.layer.updateBufferAndRepaint();
                }
            }
            ++count;
        }
        Logging.debug("Loaded {0} thumbnails in {1}", count, stopwatch);
        if (this.layer != null) {
            this.layer.thumbsLoaded();
            this.layer.updateBufferAndRepaint();
        }
    }

    private BufferedImage loadThumb(ImageEntry entry) {
        BufferedImage img;
        String cacheIdent = entry.getFile().toString() + ":" + 120;
        if (!this.cacheOff && this.cache != null) {
            try {
                BufferedImageCacheEntry cacheEntry = this.cache.get(cacheIdent);
                if (cacheEntry != null && cacheEntry.getImage() != null) {
                    Logging.debug("{0} from cache", cacheIdent);
                    return cacheEntry.getImage();
                }
            }
            catch (IOException e) {
                Logging.warn(e);
            }
        }
        try {
            img = entry.read(new Dimension(120, 120));
        }
        catch (IOException e) {
            Logging.warn("Failed to load geoimage thumb");
            Logging.warn(e);
            return null;
        }
        if (img.getWidth() <= 0 || img.getHeight() <= 0) {
            Logging.error(" Invalid image");
            return null;
        }
        if (!this.cacheOff && this.cache != null) {
            try {
                this.cache.put(cacheIdent, BufferedImageCacheEntry.pngEncoded(img));
            }
            catch (UncheckedIOException e) {
                Logging.warn("Failed to save geoimage thumb to cache");
                Logging.warn(e);
            }
        }
        return img;
    }
}

