/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jcs3.auxiliary.disk.block;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.jcs3.auxiliary.disk.behavior.IDiskCacheAttributes;
import org.apache.commons.jcs3.auxiliary.disk.block.BlockDiskCache;
import org.apache.commons.jcs3.auxiliary.disk.block.BlockDiskCacheAttributes;
import org.apache.commons.jcs3.auxiliary.disk.block.BlockDiskElementDescriptor;
import org.apache.commons.jcs3.io.ObjectInputStreamClassLoaderAware;
import org.apache.commons.jcs3.log.Log;
import org.apache.commons.jcs3.log.LogManager;
import org.apache.commons.jcs3.utils.struct.AbstractLRUMap;
import org.apache.commons.jcs3.utils.struct.LRUMap;
import org.apache.commons.jcs3.utils.timing.ElapsedTimer;

public class BlockDiskKeyStore<K> {
    private static final Log log = LogManager.getLog(BlockDiskKeyStore.class);
    private final BlockDiskCacheAttributes blockDiskCacheAttributes;
    private Map<K, int[]> keyHash;
    private final File keyFile;
    protected final String logCacheName;
    private final String fileName;
    private final int maxKeySize;
    protected final BlockDiskCache<K, ?> blockDiskCache;
    private IDiskCacheAttributes.DiskLimitType diskLimitType = IDiskCacheAttributes.DiskLimitType.COUNT;
    private final int blockSize;

    public BlockDiskKeyStore(BlockDiskCacheAttributes cacheAttributes, BlockDiskCache<K, ?> blockDiskCache) {
        this.blockDiskCacheAttributes = cacheAttributes;
        this.logCacheName = "Region [" + this.blockDiskCacheAttributes.getCacheName() + "] ";
        this.fileName = this.blockDiskCacheAttributes.getCacheName();
        this.maxKeySize = cacheAttributes.getMaxKeySize();
        this.blockDiskCache = blockDiskCache;
        this.diskLimitType = cacheAttributes.getDiskLimitType();
        this.blockSize = cacheAttributes.getBlockSizeBytes();
        File rootDirectory = cacheAttributes.getDiskPath();
        log.info("{0}: Cache file root directory [{1}]", this.logCacheName, rootDirectory);
        this.keyFile = new File(rootDirectory, this.fileName + ".key");
        log.info("{0}: Key File [{1}]", this.logCacheName, this.keyFile.getAbsolutePath());
        if (this.keyFile.length() > 0L) {
            this.loadKeys();
            if (!this.verify()) {
                log.warn("{0}: Key File is invalid. Resetting file.", this.logCacheName);
                this.initKeyMap();
                this.reset();
            }
        } else {
            this.initKeyMap();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void saveKeys() {
        try {
            ElapsedTimer timer = new ElapsedTimer();
            int numKeys = this.keyHash.size();
            log.info("{0}: Saving keys to [{1}], key count [{2}]", () -> this.logCacheName, () -> this.keyFile.getAbsolutePath(), () -> numKeys);
            File file = this.keyFile;
            synchronized (file) {
                FileOutputStream fos = new FileOutputStream(this.keyFile);
                BufferedOutputStream bos = new BufferedOutputStream(fos, 65536);
                try (ObjectOutputStream oos = new ObjectOutputStream(bos);){
                    if (!this.verify()) {
                        throw new IOException("Inconsistent key file");
                    }
                    for (Map.Entry<K, int[]> entry : this.keyHash.entrySet()) {
                        BlockDiskElementDescriptor<K> descriptor = new BlockDiskElementDescriptor<K>();
                        descriptor.setKey(entry.getKey());
                        descriptor.setBlocks(entry.getValue());
                        oos.writeUnshared(descriptor);
                    }
                }
            }
            log.info("{0}: Finished saving keys. It took {1} to store {2} keys. Key file length [{3}]", () -> this.logCacheName, () -> timer.getElapsedTimeString(), () -> numKeys, () -> this.keyFile.length());
        }
        catch (IOException e) {
            log.error("{0}: Problem storing keys.", this.logCacheName, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void reset() {
        File file = this.keyFile;
        synchronized (file) {
            this.clearMemoryMap();
            this.saveKeys();
        }
    }

    protected void clearMemoryMap() {
        this.keyHash.clear();
    }

    private void initKeyMap() {
        this.keyHash = null;
        if (this.maxKeySize >= 0) {
            this.keyHash = this.diskLimitType == IDiskCacheAttributes.DiskLimitType.SIZE ? new LRUMapSizeLimited(this.maxKeySize) : new LRUMapCountLimited(this.maxKeySize);
            log.info("{0}: Set maxKeySize to: \"{1}\"", this.logCacheName, this.maxKeySize);
        } else {
            this.keyHash = new HashMap<K, int[]>();
            log.info("{0}: Set maxKeySize to unlimited", this.logCacheName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void loadKeys() {
        log.info("{0}: Loading keys for {1}", () -> this.logCacheName, () -> this.keyFile.toString());
        try {
            this.initKeyMap();
            HashMap keys = new HashMap();
            File file = this.keyFile;
            synchronized (file) {
                FileInputStream fis = new FileInputStream(this.keyFile);
                BufferedInputStream bis = new BufferedInputStream(fis, 65536);
                try {
                    ObjectInputStreamClassLoaderAware ois = new ObjectInputStreamClassLoaderAware(bis, null);
                    Throwable throwable = null;
                    try {
                        try {
                            while (true) {
                                BlockDiskElementDescriptor descriptor;
                                if ((descriptor = (BlockDiskElementDescriptor)ois.readObject()) == null) {
                                    continue;
                                }
                                keys.put(descriptor.getKey(), descriptor.getBlocks());
                            }
                        }
                        catch (Throwable throwable2) {
                            throwable = throwable2;
                            throw throwable2;
                        }
                    }
                    catch (Throwable throwable3) {
                        if (ois != null) {
                            if (throwable != null) {
                                try {
                                    ois.close();
                                }
                                catch (Throwable throwable4) {
                                    throwable.addSuppressed(throwable4);
                                }
                            } else {
                                ois.close();
                            }
                        }
                        throw throwable3;
                    }
                }
                catch (EOFException eOFException) {
                }
            }
            if (!keys.isEmpty()) {
                this.keyHash.putAll(keys);
                log.debug("{0}: Found {1} in keys file.", this.logCacheName, keys.size());
                log.info("{0}: Loaded keys from [{1}], key count: {2}; up to {3} will be available.", () -> this.logCacheName, () -> this.fileName, () -> this.keyHash.size(), () -> this.maxKeySize);
            }
        }
        catch (Exception e) {
            log.error("{0}: Problem loading keys for file {1}", this.logCacheName, this.fileName, e);
        }
    }

    public Set<Map.Entry<K, int[]>> entrySet() {
        return this.keyHash.entrySet();
    }

    public Set<K> keySet() {
        return this.keyHash.keySet();
    }

    public int size() {
        return this.keyHash.size();
    }

    public int[] get(K key) {
        return this.keyHash.get(key);
    }

    public void put(K key, int[] value) {
        this.keyHash.put(key, value);
    }

    public int[] remove(K key) {
        return this.keyHash.remove(key);
    }

    private boolean verify() {
        TreeMap blockAllocationMap = new TreeMap();
        for (Map.Entry<K, int[]> e : this.keyHash.entrySet()) {
            for (int block : e.getValue()) {
                HashSet<K> keys = (HashSet<K>)blockAllocationMap.get(block);
                if (keys == null) {
                    keys = new HashSet<K>();
                    blockAllocationMap.put(block, keys);
                } else if (!log.isTraceEnabled()) {
                    return false;
                }
                keys.add(e.getKey());
            }
        }
        boolean ok = true;
        if (log.isTraceEnabled()) {
            for (Map.Entry e : blockAllocationMap.entrySet()) {
                log.trace("Block {0}: {1}", e.getKey(), e.getValue());
                if (((Set)e.getValue()).size() <= 1) continue;
                ok = false;
            }
            return ok;
        }
        return ok;
    }

    public class LRUMapCountLimited
    extends LRUMap<K, int[]> {
        public static final String TAG = "orig-lru-count";

        public LRUMapCountLimited(int maxKeySize) {
            super(maxKeySize);
        }

        @Override
        protected void processRemovedLRU(K key, int[] value) {
            BlockDiskKeyStore.this.blockDiskCache.freeBlocks(value);
            if (log.isDebugEnabled()) {
                log.debug("{0}: Removing key: [{1}] from key store.", BlockDiskKeyStore.this.logCacheName, key);
                log.debug("{0}: Key store size: [{1}].", BlockDiskKeyStore.this.logCacheName, super.size());
            }
        }
    }

    public class LRUMapSizeLimited
    extends AbstractLRUMap<K, int[]> {
        public static final String TAG = "orig-lru-size";
        private AtomicInteger contentSize;
        private int maxSize;

        public LRUMapSizeLimited() {
            this(-1);
        }

        public LRUMapSizeLimited(int maxSize) {
            this.maxSize = maxSize;
            this.contentSize = new AtomicInteger(0);
        }

        private void subLengthFromCacheSize(int[] value) {
            this.contentSize.addAndGet(value.length * BlockDiskKeyStore.this.blockSize / -1024 - 1);
        }

        private void addLengthToCacheSize(int[] value) {
            this.contentSize.addAndGet(value.length * BlockDiskKeyStore.this.blockSize / 1024 + 1);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int[] put(K key, int[] value) {
            int[] oldValue = null;
            try {
                oldValue = super.put(key, value);
            }
            finally {
                if (value != null) {
                    this.addLengthToCacheSize(value);
                }
                if (oldValue != null) {
                    this.subLengthFromCacheSize(oldValue);
                }
            }
            return oldValue;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int[] remove(Object key) {
            int[] value = null;
            try {
                int[] nArray = value = (int[])super.remove(key);
                return nArray;
            }
            finally {
                if (value != null) {
                    this.subLengthFromCacheSize(value);
                }
            }
        }

        @Override
        protected void processRemovedLRU(K key, int[] value) {
            BlockDiskKeyStore.this.blockDiskCache.freeBlocks(value);
            if (log.isDebugEnabled()) {
                log.debug("{0}: Removing key: [{1}] from key store.", BlockDiskKeyStore.this.logCacheName, key);
                log.debug("{0}: Key store size: [{1}].", BlockDiskKeyStore.this.logCacheName, super.size());
            }
            if (value != null) {
                this.subLengthFromCacheSize(value);
            }
        }

        @Override
        protected boolean shouldRemove() {
            return this.maxSize > 0 && this.contentSize.get() > this.maxSize && this.size() > 1;
        }
    }
}

