/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.validation.tests;

import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.data.validation.Severity;
import org.openstreetmap.josm.data.validation.Test;
import org.openstreetmap.josm.data.validation.TestError;
import org.openstreetmap.josm.tools.Geometry;
import org.openstreetmap.josm.tools.I18n;

public class WronglyOrderedWays
extends Test {
    protected static final int WRONGLY_ORDERED_COAST = 1001;
    protected static final int WRONGLY_ORDERED_LAND = 1003;

    public WronglyOrderedWays() {
        super(I18n.tr("Wrongly Ordered Ways", new Object[0]), I18n.tr("This test checks the direction of water, land and coastline ways.", new Object[0]));
    }

    @Override
    public void visit(Way w) {
        if (!w.isUsable() || !w.isClosed()) {
            return;
        }
        String natural = w.get("natural");
        if (natural == null) {
            return;
        }
        if ("coastline".equals(natural) && Geometry.isClockwise(w)) {
            this.reportError(w, I18n.tr("Reversed coastline: land not on left side", new Object[0]), 1001);
        } else if ("land".equals(natural) && Geometry.isClockwise(w)) {
            this.reportError(w, I18n.tr("Reversed land: land not on left side", new Object[0]), 1003);
        }
    }

    private void reportError(Way w, String msg, int type) {
        this.errors.add(TestError.builder(this, Severity.WARNING, type).message(msg).primitives(w).build());
    }
}

