/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.io;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import javax.xml.parsers.ParserConfigurationException;
import org.openstreetmap.josm.data.osm.history.HistoryDataSet;
import org.openstreetmap.josm.gui.progress.ProgressMonitor;
import org.openstreetmap.josm.io.AbstractParser;
import org.openstreetmap.josm.tools.CheckParameterUtil;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Logging;
import org.openstreetmap.josm.tools.XmlUtils;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class OsmHistoryReader {
    private final InputStream in;
    private final HistoryDataSet data;

    public OsmHistoryReader(InputStream source) {
        CheckParameterUtil.ensureParameterNotNull(source, "source");
        this.in = source;
        this.data = new HistoryDataSet();
    }

    public HistoryDataSet parse(ProgressMonitor progressMonitor) throws SAXException, IOException {
        InputSource inputSource = new InputSource(new InputStreamReader(this.in, StandardCharsets.UTF_8));
        progressMonitor.beginTask(I18n.tr("Parsing OSM history data ...", new Object[0]));
        try {
            XmlUtils.parseSafeSAX(inputSource, new Parser());
        }
        catch (ParserConfigurationException e) {
            Logging.error(e);
            throw new SAXException(e);
        }
        finally {
            progressMonitor.finishTask();
        }
        return this.data;
    }

    private class Parser
    extends AbstractParser {
        private Parser() {
        }

        protected String getCurrentPosition() {
            if (this.locator == null) {
                return "";
            }
            return "" + '(' + this.locator.getLineNumber() + ',' + this.locator.getColumnNumber() + ')';
        }

        @Override
        protected void throwException(String message) throws SAXException {
            throw new SAXException(this.getCurrentPosition() + message);
        }

        @Override
        protected void throwException(String message, Exception e) throws SAXException {
            throw new SAXException(this.getCurrentPosition() + message, e);
        }

        @Override
        public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
            this.doStartElement(qName, atts);
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
            if ("node".equals(qName) || "way".equals(qName) || "relation".equals(qName)) {
                OsmHistoryReader.this.data.put(this.currentPrimitive);
            }
        }
    }
}

