/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.dialogs.relation;

import java.awt.Component;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.dialogs.relation.RelationEditor;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.gui.layer.LayerManager;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;

public class RelationDialogManager
extends WindowAdapter
implements LayerManager.LayerChangeListener {
    private static RelationDialogManager relationDialogManager;
    private final Map<DialogContext, RelationEditor> openDialogs = new HashMap<DialogContext, RelationEditor>();

    public static RelationDialogManager getRelationDialogManager() {
        if (relationDialogManager == null) {
            relationDialogManager = new RelationDialogManager();
            MainApplication.getLayerManager().addLayerChangeListener(relationDialogManager);
        }
        return relationDialogManager;
    }

    public void register(OsmDataLayer layer, Relation relation, RelationEditor editor) {
        this.openDialogs.put(new DialogContext(layer, Optional.ofNullable(relation).orElseGet(Relation::new)), editor);
        editor.addWindowListener(this);
    }

    public void updateContext(OsmDataLayer layer, Relation relation, RelationEditor editor) {
        this.openDialogs.values().removeIf(i -> Objects.equals(i, editor));
        this.openDialogs.put(new DialogContext(layer, relation), editor);
    }

    public void close(OsmDataLayer layer, Relation relation) {
        DialogContext context = new DialogContext(layer, relation);
        RelationEditor editor = this.openDialogs.get(context);
        if (editor != null) {
            editor.setVisible(false);
        }
    }

    public boolean isOpenInEditor(OsmDataLayer layer, Relation relation) {
        if (relation == null) {
            return false;
        }
        DialogContext context = new DialogContext(layer, relation);
        return this.openDialogs.containsKey(context);
    }

    public RelationEditor getEditorForRelation(OsmDataLayer layer, Relation relation) {
        if (relation == null) {
            return null;
        }
        DialogContext context = new DialogContext(layer, relation);
        return this.openDialogs.get(context);
    }

    @Override
    public void layerRemoving(LayerManager.LayerRemoveEvent e) {
        Layer oldLayer = e.getRemovedLayer();
        if (!(oldLayer instanceof OsmDataLayer)) {
            return;
        }
        OsmDataLayer dataLayer = (OsmDataLayer)oldLayer;
        Iterator<Map.Entry<DialogContext, RelationEditor>> it = this.openDialogs.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<DialogContext, RelationEditor> entry = it.next();
            if (!entry.getKey().matchesLayer(dataLayer)) continue;
            RelationEditor editor = entry.getValue();
            it.remove();
            editor.setVisible(false);
            editor.dispose();
        }
    }

    @Override
    public void layerAdded(LayerManager.LayerAddEvent e) {
    }

    @Override
    public void layerOrderChanged(LayerManager.LayerOrderChangeEvent e) {
    }

    @Override
    public void windowClosed(WindowEvent e) {
        Window w = e.getWindow();
        if (w instanceof RelationEditor) {
            RelationEditor editor = (RelationEditor)w;
            this.openDialogs.values().removeIf(i -> Objects.equals(i, editor));
        }
    }

    protected boolean hasEditorWithCloseUpperLeftCorner(Point p, RelationEditor thisEditor) {
        return this.openDialogs.values().stream().filter(editor -> editor != thisEditor).map(Component::getLocation).anyMatch(corner -> p.x >= corner.x - 5 && corner.x + 5 >= p.x && p.y >= corner.y - 5 && corner.y + 5 >= p.y);
    }

    public void positionOnScreen(RelationEditor editor) {
        if (editor == null) {
            return;
        }
        if (!this.openDialogs.isEmpty()) {
            Point corner = editor.getLocation();
            while (this.hasEditorWithCloseUpperLeftCorner(corner, editor)) {
                corner.x += 20;
                corner.y += 20;
            }
            editor.setLocation(corner);
        }
    }

    private static class DialogContext {
        public final Relation relation;
        public final OsmDataLayer layer;

        DialogContext(OsmDataLayer layer, Relation relation) {
            this.layer = layer;
            this.relation = relation;
        }

        public int hashCode() {
            return Objects.hash(this.relation, this.layer);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            DialogContext that = (DialogContext)obj;
            return Objects.equals(this.relation, that.relation) && Objects.equals(this.layer, that.layer);
        }

        public boolean matchesLayer(OsmDataLayer layer) {
            if (layer == null) {
                return false;
            }
            return this.layer.equals(layer);
        }

        public String toString() {
            return "[Context: layer=" + this.layer.getName() + ",relation=" + this.relation.getId() + ']';
        }
    }
}

