/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.validation.tests;

import java.util.Arrays;
import java.util.Collection;
import java.util.TreeSet;
import org.openstreetmap.josm.data.coor.EastNorth;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.data.osm.WaySegment;
import org.openstreetmap.josm.data.preferences.sources.ValidatorPrefHelper;
import org.openstreetmap.josm.data.validation.Severity;
import org.openstreetmap.josm.data.validation.Test;
import org.openstreetmap.josm.data.validation.TestError;
import org.openstreetmap.josm.tools.Geometry;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.bugreport.BugReport;

public class SharpAngles
extends Test {
    private static final int SHARPANGLESCODE = 3800;
    private static final int SHARP_ANGLES = 3800;
    private double maxAngle = 45.0;
    private double maxLength = 10.0;
    private final Collection<String> ignoreHighways = new TreeSet<String>(Arrays.asList("platform", "rest_area", "services", "via_ferrata"));

    public SharpAngles() {
        super(I18n.tr("Sharp angles", new Object[0]), I18n.tr("Check for sharp angles on roads", new Object[0]));
    }

    @Override
    public void visit(Way way) {
        if (!way.isUsable()) {
            return;
        }
        if (this.shouldBeTestedForSharpAngles(way)) {
            try {
                this.checkWayForSharpAngles(way);
            }
            catch (RuntimeException e) {
                throw BugReport.intercept(e).put("way", way);
            }
        }
    }

    public boolean shouldBeTestedForSharpAngles(Way way) {
        return way.hasKey("highway") && !way.hasTag("area", "yes") && !way.hasKey("via_ferrata_scale") && !this.ignoreHighways.contains(way.get("highway"));
    }

    public void checkWayForSharpAngles(Way way) {
        Node node1 = null;
        Node node2 = null;
        Node node3 = null;
        int i = -2;
        for (Node node : way.getNodes()) {
            node1 = node2;
            node2 = node3;
            node3 = node;
            this.checkAngle(node1, node2, node3, i, way, false);
            ++i;
        }
        if (way.isClosed() && way.getNodesCount() > 2) {
            node1 = node2;
            node2 = node3;
            node3 = way.getNode(1);
            this.checkAngle(node1, node2, node3, i, way, true);
        }
    }

    private void checkAngle(Node node1, Node node2, Node node3, int i, Way way, boolean last) {
        EastNorth n3;
        EastNorth n2;
        if (node1 == null || node2 == null || node3 == null) {
            return;
        }
        EastNorth n1 = node1.getEastNorth();
        double angle = Math.toDegrees(Math.abs(Geometry.getCornerAngle(n1, n2 = node2.getEastNorth(), n3 = node3.getEastNorth())));
        if (angle < this.maxAngle) {
            this.processSharpAngleForErrorCreation(angle, i, way, last, node2);
        }
    }

    private void processSharpAngleForErrorCreation(double angle, int i, Way way, boolean last, Node pointNode) {
        double d2;
        WaySegment ws1 = new WaySegment(way, i);
        WaySegment ws2 = new WaySegment(way, last ? 0 : i + 1);
        double d1 = ws1.getFirstNode().getEastNorth().distance(ws1.getSecondNode().getEastNorth());
        double shorterLen = Math.min(d1, d2 = ws2.getFirstNode().getEastNorth().distance(ws2.getSecondNode().getEastNorth()));
        if (shorterLen < this.maxLength) {
            this.createNearlyOverlappingError(angle, way, pointNode);
        }
    }

    private void createNearlyOverlappingError(double angle, Way way, OsmPrimitive primitive) {
        Severity severity = this.getSeverity(angle);
        if (severity != Severity.OTHER || ValidatorPrefHelper.PREF_OTHER.get().booleanValue() || ValidatorPrefHelper.PREF_OTHER_UPLOAD.get().booleanValue()) {
            int addCode = severity == Severity.OTHER ? 1 : 0;
            TestError.Builder testError = TestError.builder(this, severity, 3800 + addCode).primitives(way).highlight(primitive).message(I18n.tr("Sharp angle", new Object[0]));
            this.errors.add(testError.build());
        }
    }

    private Severity getSeverity(double angle) {
        return angle < this.maxAngle * 2.0 / 3.0 ? Severity.WARNING : Severity.OTHER;
    }

    public void setMaxLength(double length) {
        this.maxLength = length;
    }

    public void addIgnoredHighway(String highway) {
        this.ignoreHighways.add(highway);
    }

    public void setMaxAngle(double angle) {
        this.maxAngle = angle;
    }
}

