/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.actions;

import java.awt.event.ActionEvent;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.data.UndoRedoHandler;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.MapFrame;
import org.openstreetmap.josm.gui.help.HelpUtil;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Shortcut;

public class RedoAction
extends JosmAction
implements UndoRedoHandler.CommandQueueListener {
    public RedoAction() {
        super(I18n.tr("Redo", new Object[0]), "redo", I18n.tr("Redo the last undone action.", new Object[0]), Shortcut.registerShortcut("system:redo", I18n.tr("Edit: {0}", I18n.tr("Redo", new Object[0])), 89, 5006), true);
        this.setEnabled(false);
        this.setHelpId(HelpUtil.ht("/Action/Redo"));
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        MapFrame map = MainApplication.getMap();
        if (map == null) {
            return;
        }
        map.repaint();
        UndoRedoHandler.getInstance().redo();
    }

    @Override
    protected void updateEnabledState() {
        this.setEnabled(UndoRedoHandler.getInstance().hasRedoCommands());
    }

    @Override
    public void commandChanged(int queueSize, int redoSize) {
        if (!UndoRedoHandler.getInstance().hasRedoCommands()) {
            this.putValue("Name", I18n.tr("Redo", new Object[0]));
            this.setTooltip(I18n.tr("Redo the last undone action.", new Object[0]));
        } else {
            this.putValue("Name", I18n.tr("Redo ...", new Object[0]));
            this.setTooltip(I18n.tr("Redo {0}", UndoRedoHandler.getInstance().getRedoCommands().get(0).getDescriptionText()));
        }
    }
}

