/*=========================================================================

  Program:   CABLE - CABLE Automates Bindings for Language Extension
  Module:    $RCSfile: cableClassType.cxx,v $
  Language:  C++
  Date:      $Date: 2002-10-23 21:35:02 $
  Version:   $Revision: 1.4 $

  Copyright (c) 2002 Kitware, Inc., Insight Consortium.  All rights reserved.
  See Copyright.txt for details.

     This software is distributed WITHOUT ANY WARRANTY; without even 
     the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
     PURPOSE.  See the above copyright notices for more information.

=========================================================================*/
#include "cableClassType.h"
#include "cableClass.h"
#include "cxxClassType.h"

namespace cable
{

//----------------------------------------------------------------------------
ClassType::ClassType()
{
  m_Class = 0;
}

//----------------------------------------------------------------------------
ClassType::~ClassType()
{
}

//----------------------------------------------------------------------------
Type::TypeIdType ClassType::GetTypeId() const
{
  return ClassTypeId;
}

//----------------------------------------------------------------------------
bool ClassType::CreateCxxType(cxx::TypeSystem* ts)
{
  // Make sure we haven't already created the type.
  if(m_CxxType.GetType())
    {
    return true;
    }
  
  if(m_Class)
    {
    const cxx::ClassType* t = m_Class->GetCxxClassType(ts);
    if(t)
      {
      m_CxxType = t->GetCvQualifiedType(m_Const, m_Volatile);
      return true;
      }
    }
  cableErrorMacro("Couldn't create cxx::ClassType.");
  return false;
}

//----------------------------------------------------------------------------
Class* ClassType::GetClass() const
{
  return m_Class;
}

//----------------------------------------------------------------------------
void ClassType::SetClass(Class* c)
{
  m_Class = c;
}

} // namespace cable
