/* GrandPerspective, Version 3.5.2 
 *   A utility for Mac OS X that graphically shows disk usage. 
 * Copyright (C) 2005-2022, Erwin Bonsma 
 * 
 * This program is free software; you can redistribute it and/or modify it 
 * under the terms of the GNU General Public License as published by the Free 
 * Software Foundation; either version 2 of the License, or (at your option) 
 * any later version. 
 * 
 * This program is distributed in the hope that it will be useful, but WITHOUT 
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or 
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for 
 * more details. 
 * 
 * You should have received a copy of the GNU General Public License along 
 * with this program; if not, write to the Free Software Foundation, Inc., 
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA. 
 */

#import <Foundation/Foundation.h>

#import <zlib.h>

extern const NSUInteger DECOMPRESSED_BUFFER_SIZE;

// Reads gzip-ed compressed data, de-compressing it on the fly.
//
// For backward compatibility, it also supports reading uncompressed text data
@interface CompressedInput : NSObject <NSStreamDelegate> {

  uint8_t  *compressedDataBuffer;
  void  *decompressedDataBuffer;

  BOOL  isCompressed;

  BOOL  inputDataAvailable;
  BOOL  inputEndEncountered;
  BOOL  decompressionDone;
  const uint8_t  *decompressedDataP;
  NSInteger numDecompressedBytesAvailable;
  BOOL  outputSpaceAvailable;

  struct z_stream_s  compressionStream;

  NSInputStream  *inputStream;
  NSOutputStream  *outputStream;
}

@property (atomic) unsigned long long totalBytesRead;

// Overrides designated initialiser
- (instancetype) init NS_UNAVAILABLE;

- (instancetype) initWithSourceUrl:(NSURL *)sourceUrl
                      outputStream:(NSOutputStream *)outputStream NS_DESIGNATED_INITIALIZER;

- (void) open;

// Stream event handler
- (void) stream:(NSStream *)stream handleEvent:(NSStreamEvent)eventCode;

@end
