/* GrandPerspective, Version 3.4 
 *   A utility for Mac OS X that graphically shows disk usage. 
 * Copyright (C) 2005-2022, Erwin Bonsma 
 * 
 * This program is free software; you can redistribute it and/or modify it 
 * under the terms of the GNU General Public License as published by the Free 
 * Software Foundation; either version 2 of the License, or (at your option) 
 * any later version. 
 * 
 * This program is distributed in the hope that it will be useful, but WITHOUT 
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or 
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for 
 * more details. 
 * 
 * You should have received a copy of the GNU General Public License along 
 * with this program; if not, write to the Free Software Foundation, Inc., 
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA. 
 */

#import <Cocoa/Cocoa.h>

/* A test that is part of a Filter. Instances of this object are immutable. However, instances of
 * the MutableFilterTestRef subclass are not.
 */
@interface FilterTestRef : NSObject {
}

+ (id) filterTestWithName:(NSString *)name;
+ (id) filterTestWithName:(NSString *)name inverted:(BOOL)inverted;

/* Creates a filter from a dictionary as generated by -dictionaryForObject.
 */
+ (FilterTestRef *)filterTestRefFromDictionary:(NSDictionary *)dict;

// Overrides designated initialiser.
- (instancetype) init NS_UNAVAILABLE;

- (instancetype) initWithName:(NSString *)name;
- (instancetype) initWithName:(NSString *)name
                     inverted:(BOOL)inverted NS_DESIGNATED_INITIALIZER;

@property (nonatomic, readonly, copy) NSString *name;
@property (nonatomic, getter=isInverted, readonly) BOOL inverted;

/* Returns a dictionary that represents the object. It can be used for storing the object to
 * preferences.
 */
- (NSDictionary *)dictionaryForObject;

@end
