/* GrandPerspective, Version 2.6.2 
 *   A utility for Mac OS X that graphically shows disk usage. 
 * Copyright (C) 2005-2022, Erwin Bonsma 
 * 
 * This program is free software; you can redistribute it and/or modify it 
 * under the terms of the GNU General Public License as published by the Free 
 * Software Foundation; either version 2 of the License, or (at your option) 
 * any later version. 
 * 
 * This program is distributed in the hope that it will be useful, but WITHOUT 
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or 
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for 
 * more details. 
 * 
 * You should have received a copy of the GNU General Public License along 
 * with this program; if not, write to the Free Software Foundation, Inc., 
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA. 
 */

#import <Cocoa/Cocoa.h>

@class NotifyingDictionary;
@class Filter;

@interface FilterRepository : NSObject {
  // Contains the filters provided by the application.
  NSDictionary  *applicationProvidedFilters;
}

+ (id) defaultInstance;

/* Returns dictionary which can subsequently be modified.
 */
@property (nonatomic, readonly, strong) NotifyingDictionary *filtersByNameAsNotifyingDictionary;

/* Returns dictionary as an NSDictionary, which is useful if the dictionary does not need to be
 * modified. Note, the dictionary can still be modified by casting it to NotifyingDictionary. This
 * is only a convenience method.
 */
@property (nonatomic, readonly, copy) NSDictionary *filtersByName;

- (Filter *)filterForName:(NSString *)name;

- (Filter *)applicationProvidedFilterForName:(NSString *)name;

- (void) storeUserCreatedFilters;

@end
