/* GrandPerspective, Version 2.5.2 
 *   A utility for Mac OS X that graphically shows disk usage. 
 * Copyright (C) 2005-2020, Erwin Bonsma 
 * 
 * This program is free software; you can redistribute it and/or modify it 
 * under the terms of the GNU General Public License as published by the Free 
 * Software Foundation; either version 2 of the License, or (at your option) 
 * any later version. 
 * 
 * This program is distributed in the hope that it will be useful, but WITHOUT 
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or 
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for 
 * more details. 
 * 
 * You should have received a copy of the GNU General Public License along 
 * with this program; if not, write to the Free Software Foundation, Inc., 
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA. 
 */

#import <Cocoa/Cocoa.h>

#import "FileItemMapping.h"
#import "FileItemMappingScheme.h"

/* Base class for file item mapping implementations that do not maintain any state (which are
 * therefore thread-safe).
 *
 * Given that the implementation is stateless, the corresponding file item mapping scheme can always
 * return the same file item mapping instance, which therefore can also represent the scheme.
 */
@interface StatelessFileItemMapping : NSObject <FileItemMappingScheme, FileItemMapping> {
}

@end
