// $Id: FFMainController.h 570 2006-08-20 14:35:58Z ravemax $

#import "FFOptions.h"

// External classes
@class FFImageListController;
@class FFPrefsController;
@class FFPreferences;
@class FFImageList;
@class FFActionHandler;
@class FFDockIcon;
@class FFInputEvent;
@class FFRecentList;
@class FFScriptMenu;

// Menu actions
typedef enum {
	NO_MENU_ACTION				= 0,
	MENU_SCRIPTS				= 8, // Used to get the scripts menu
	MENU_FORMAT					= 9,
	
	MENU_APP_FEEDBACK			= 101,
	MENU_APP_DONATE_POSTCARD	= 102,
	MENU_APP_CHECK_UPDATES		= 103,
	MENU_APP_PREFERENCES		= 105,
	MENU_APP_HIDE_FFVIEW		= 107,
	MENU_APP_HIDE_OTHERS		= 109,
	MENU_APP_SHOW_ALL			= 111,
	MENU_APP_QUICKSAVE_AND_QUIT	= 113,
	MENU_APP_QUIT_FFVIEW		= 115,
	
	MENU_FILE_OPEN				= 201,
	MENU_FILE_SAVE_IMGLIST		= 203,
	MENU_FILE_SHUFFLE_IMGLIST	= 205,
	MENU_FILE_CLEAR_IMGLIST		= 207,
	MENU_FILE_REMOVE			= 209,
	MENU_FILE_REVEAL_IN_FINDER	= 211,
	MENU_FILE_MOVE_TO_TRASH		= 213,
	MENU_FILE_COPY_SELECTED		= 215,
	MENU_FILE_CLEAR_RECENT		= 217,
	MENU_FILE_FINDER_ICON		= 219,

	MENU_VIEW_FULLSCREEN		= 301,
	MENU_VIEW_PREV_IMG			= 303,
	MENU_VIEW_NEXT_IMG			= 305,
	MENU_VIEW_FIRST_IMG			= 307,
	MENU_VIEW_LAST_IMG			= 309,
	MENU_VIEW_PAGE_UP			= 311,
	MENU_VIEW_PAGE_DOWN			= 313,
	MENU_VIEW_FOLDER_DRAWER		= 335,
	MENU_VIEW_PREV_FOLDER		= 337,
	MENU_VIEW_PREV_NEXT			= 339,
	MENU_VIEW_ACTUAL_SIZE		= 315,
	MENU_VIEW_ZOOM_IN			= 317,
	MENU_VIEW_ZOOM_OUT			= 319,
	MENU_VIEW_START_SLIDESHOW	= 321,
	MENU_VIEW_ENDLESS_SLIDESHOW	= 323,
	MENU_VIEW_STOP_SLIDESHOW	= 325,
	MENU_VIEW_OSD				= 327,
	MENU_VIEW_EXIF_DATA			= 331,
	MENU_VIEW_MAG_LENSE			= 333, 

	MENU_OPT_NO_ROTATION		= 401,
	MENU_OPT_ROTATE_90			= 403,
	MENU_OPT_ROTATE_180			= 405,
	MENU_OPT_ROTATE_270			= 407,
	MENU_OPT_NO_SCALING			= 409,
	MENU_OPT_FIT_WIN			= 411,
	MENU_OPT_PAGEWIDTH			= 413,
	MENU_OPT_SINGLE				= 415,
	MENU_OPT_WESTERN			= 417,
	MENU_OPT_MANGA				= 419, 
	MENU_OPT_NO_BLOW_UP			= 422,
	MENU_OPT_ANTIALIASING		= 423,
	MENU_OPT_SPEECH_ON			= 425,

	MENU_NAVI_PAN_LEFT			= 501,
	MENU_NAVI_PAN_LEFT_ACCEL	= 503,
	MENU_NAVI_PAN_RIGHT			= 505,
	MENU_NAVI_PAN_RIGHT_ACCEL	= 507,
	MENU_NAVI_PAN_UP			= 509,
	MENU_NAVI_PAN_UP_ACCEL		= 511,
	MENU_NAVI_PAN_DOWN			= 513,
	MENU_NAVI_PAN_DOWN_ACCEL	= 515,
	
	MENU_WIN_CLOSE_WINDOW		= 601,
	MENU_WIN_ZOOM_WINDOW		= 603,
	MENU_WIN_MINIMIZE_WINDOW	= 605,
	MENU_WIN_IMAGE_LIST			= 607,
	MENU_WIN_IMAGE				= 609,
	MENU_WIN_EXIF				= 610,
	MENU_WIN_BRING_ALL_TO_FRONT	= 611,
	MENU_WIN_HIDE_TOOLBAR		= 613,
	MENU_WIN_CUSTOMIZE_TOOLBAR	= 615,
	
	MENU_HELP_HELP				= 701,
	MENU_HELP_BROWSER			= 703,
	MENU_HELP_DEBUG_STATUS		= 705,
	
	MENU_SCRIPTS_OPEN_FOLDER	= 801,
	
	ABOVE_LAST_MENU_ACTION
} FFMenuAction;

// Class
@interface FFMainController : NSObject {
    IBOutlet NSMenuItem*	m_menuPrevImage;
    IBOutlet NSMenuItem*	m_menuNextImage;
	IBOutlet NSMenuItem*	m_menuFirstImage;
	IBOutlet NSMenuItem*	m_menuLastImage;
	IBOutlet NSMenuItem*	m_menuZoomLevel;
	IBOutlet NSMenuItem*	m_menuStartSlideshow;	
	IBOutlet NSMenuItem*	m_menuStopSlideshow;
	IBOutlet NSMenuItem*	m_menuImageWindow;
	IBOutlet NSMenuItem*	m_menuToggleOSD;
    IBOutlet NSMenuItem*	m_menuNoRotation;
    IBOutlet NSMenuItem*	m_menuRotateLeft;
    IBOutlet NSMenuItem*	m_menuRotateRight;
    IBOutlet NSMenuItem*	m_menuRotate180;
    IBOutlet NSMenuItem*	m_menuNoScaling;
    IBOutlet NSMenuItem*	m_menuFitToWindow;
	IBOutlet NSMenuItem*	m_menuPagewidth;
	IBOutlet NSMenuItem*	m_menuSingle;
	IBOutlet NSMenuItem*	m_menuWestern;
	IBOutlet NSMenuItem*	m_menuManga;
	IBOutlet NSMenuItem*	m_menuNoBlowUp;
    IBOutlet NSMenuItem*	m_menuAntialiasing;
	IBOutlet NSMenuItem*	m_menuSpeechOn;
	IBOutlet NSMenuItem*	m_menuHideToolbar;
	IBOutlet NSMenuItem*	m_menuCustomizeToolbar;
	
	IBOutlet NSMenu*				m_recentSubMenu;
	IBOutlet NSMenu*				m_archivEncodingMenu;
    IBOutlet FFImageListController* m_imgListCtrl;
    
	NSMenuItem*				m_rotationItems[OPT_NUM_ROTATION];
	NSMenuItem*				m_scalingItems[OPT_NUM_SCALING];
	NSMenuItem*				m_pageModeItems[OPT_NUM_PAGE_MODE];
	
	FFPreferences*			m_prefs;
	FFOptions*				m_opts;
	FFImageList*			m_imgList;
	FFActionHandler*		m_actionHandler;
	FFDockIcon*				m_dockIcon;
	FFPrefsController*		m_prefsCtrl;
	FFRecentList*			m_recentList;
	FFScriptMenu*			m_scriptMenu;
	NSMutableDictionary*	m_speechCommands;
	NSSpeechRecognizer*		m_speechRecog;
}

- (void)executeMenuAction:(FFMenuAction)action;
- (void)executeEvent:(FFInputEvent*)event;
- (IBAction)menuAction:(id)sender;

// Update menu item equivs
- (void)addInputEvent:(FFInputEvent*)ev toMenu:(NSMenu*)menu;
- (void)removeInputEvent:(FFInputEvent*)oldEv fromMenu:(NSMenu*)menu;
- (void)replaceInputEvent:(FFInputEvent*)oldEv inMenu:(NSMenu*)menu
					 with:(FFInputEvent*)newEv;

// Update speech commands
- (void)addSpeechEvent:(FFInputEvent*)ev;
- (void)removeSpeechEvent:(FFInputEvent*)ev;

// Forward declaration - required for "init"
- (BOOL)_addInputEvent:(FFInputEvent*)ev toMenu:(NSMenu*)menu;
- (void)updateRotationMenuItems:(NSNotification*)notification;
- (void)updateScalingMenuItems:(NSNotification*)notification;
- (void)updatePageModeMenuItems:(NSNotification*)notification;
- (void)updateNoBlowUpMenuItem:(NSNotification*)notification;
- (void)updateAntialiasingMenuItem:(NSNotification*)notification;
- (void)updateSpeechOnMenuItem:(NSNotification*)notification;
- (void)_updateSpeechCommands;
- (void)updateRecentMenu:(NSNotification*)notification;
- (void)updateZoomLevelMenuItem:(NSNotification*)notification;

@end
