// $Id: FFImageListController.h 569 2006-08-20 14:35:35Z ravemax $

#import "FFImageList.h"

// Notification (sends)
extern NSString*	ImageListWinActivatedNotification;

// Notification (receives)
extern NSString*	ShowOrHideImageListWinNotification;
extern NSString*	StartProgressNotification;
extern NSString*	StopProgressNotification;

// External classes
@class FFDropWindow;
@class FFImageList;
@class FFDirectory, FFDirNode;
@class FFThumbView;
@class FFToolTip;

@interface FFImageListController : NSObject {
    IBOutlet FFDropWindow*			m_window;
	IBOutlet NSTabView*				m_tabView;
    IBOutlet NSTableView*			m_table;
	IBOutlet NSTextField*			m_infoLabel;
	IBOutlet NSView*				m_filterView;
	IBOutlet FFThumbView*			m_thumbView;
	IBOutlet NSScrollView*			m_scrollView;
	IBOutlet NSProgressIndicator*	m_progress;
		
	IBOutlet NSView*				m_openPanelView;
	IBOutlet NSButton*				m_appendFilenames;
	IBOutlet NSButton*				m_restorePosition;
	
	IBOutlet NSDrawer*				m_dirDrawer;
	IBOutlet FFDirectory*			m_directory;
	IBOutlet NSOutlineView*			m_dirView;

	NSImage*						m_eyeImage;
	NSImage*						m_headerIndicatorImgs[IMGLIST_NUM_ORDER];
	FFImageList*					m_imgList;
	NSNotificationCenter*			m_nc;
	NSSegmentedControl*				m_displayModeControl;
	int								m_displayMode;
	NSMutableDictionary*			m_toolbarItems;
	int								m_progressCounter;
	NSMenu*							m_sortMethodMenu;
	FFDirNode*						m_clickedNodeParent;
	unsigned						m_clickedNodeIndex;
	
	BOOL							m_filterIsActive;
	NSColor*						m_nameColor[2]; // 0=normal, 1=filtered

	FFToolTip*						m_toolTip;
	unsigned						m_markedThumb;
}

- (id)init;
- (void)setImageList:(FFImageList*)imgList;

- (IBAction)directorySelectedInDrawer:(id)sender;
- (IBAction)filter:(id)sender;

// Exported
- (void)show;
- (void)openAddSheet:(BOOL)append;
- (void)openSaveSheet;
- (BOOL)listHasSelectedImages;
- (int)indexOfSingleSelectedImage;
- (BOOL)copySelected;
- (void)setWindowToSnap:(NSWindow*)win andTolerance:(float)tolerance;
- (BOOL)imageListWindowIsVisible;
- (void)toggleDirDrawer;
- (BOOL)aPreviousDirExists;
- (BOOL)aNextDirExists;
- (void)openPrevDir;
- (void)openNextDir;

// [Internal] Forward declaration
- (void)_updateInfoLabel;

@end
