// $Id: FFOSD.h 425 2005-06-09 15:39:06Z ravemax $

#import "FFOptions.h"

enum {
	OSD_IMG_NORMAL = 0,
	OSD_IMG_SELECTED,
	
	NUM_OSD_IMG_STATE
};

typedef struct {
	NSImage*	img[NUM_OSD_IMG_STATE];
	NSImage*	activeImg;
	NSPoint		origin;
} FFOSDStateImage;

@interface FFOSD : NSObject {
	// Maybe add some accessors for these vars
	NSColor*			m_backgroundCol;
	float				m_radius;
	float				m_padding;
	NSDictionary*		m_fnFontAttrib, *m_infoFontAttrib;
	NSPoint				m_baseTextPoint;
	NSPoint				m_fnPoint, m_infoPoint;
	NSPoint				m_fn2Point, m_info2Point;
	unsigned			m_iconSize;
	float				m_iconSpacing;
	float				m_iconBoxWd;
	float				m_textSpacing;

	// Accessable through constructor or setter
	FFOptions*			m_opts;
	NSString*			m_filename, *m_information;
	NSString*			m_filename2, *m_information2;
	
	// Internal
	FFOSDStateImage		m_imgRotation[OPT_NUM_ROTATION];
	FFOSDStateImage		m_imgScaling[OPT_NUM_SCALING];
	FFOSDStateImage		m_imgAntialiasing[1];
	FFOSDStateImage		m_imgNoBlowUp[1];
	NSBezierPath*		m_rectPath;
	BOOL				m_visible;
	NSLock*				m_bitmapLock;
	
	// Accessable : getter
	long				m_width, m_height;
	NSImage*			m_genImage;
	NSBitmapImageRep*   m_genBitmapRep;
}

- (id)initWithOptions:(FFOptions*)opts;

- (void)setFilename:(NSString*)fn andInformation:(NSString*)info;
- (void)setFilename:(NSString*)fn information:(NSString*)info
		  filename2:(NSString*)fn2 andInformation2:(NSString*)info2;

- (void)setRotation:(FFOptRotation)rot;
- (void)setScaling:(FFOptScaling)scale;
- (void)setAntialiasing:(BOOL)aa;
- (void)setNoBlowUp:(BOOL)noBlowUp;

- (void)setVisibility:(BOOL)vis;

- (BOOL)isVisible;
- (long)width;
- (long)height;
- (char*)dataRGBA;

@end
