// $Id: FFApplication.h 554 2006-08-20 14:10:51Z ravemax $

#import "FFMainController.h"

// External classes
@class FFInputEvent;

// [Internal]
typedef struct _FFAppActionNode {
	struct _FFAppActionNode*	next;
	int							value;
	FFInputEvent*				event;
} FFAppActionNode;

// Constants and macros
#define NUM_MODIFIER_COMBINATIONS	(0x1F+1) // 32

// The class
@interface FFApplication : NSApplication {
	// Event handling
	BOOL					m_forwardAll;
	FFMainController*		m_mainCtrl;
	FFAppActionNode*		m_ieKeyRoot[NUM_MODIFIER_COMBINATIONS];
	FFAppActionNode*		m_ieBtnRoot[NUM_MODIFIER_COMBINATIONS];
	unsigned				m_modifierMask;

	// Script objects
	NSMutableDictionary*	m_scriptObjs;
	
	// Misc
	NSString*				m_supportDir;
}

// Cleanup - no clue why dealloc isnt called
- (void)cleanUp;

// Event : Setup
- (void)setupInputEvents;
- (void)setMainController:(FFMainController*)mainCtrl;

// Event : Setters
- (void)setForwardAll:(BOOL)forwardAll;

// Event : Called from FFPreferences
- (void)didAddInputEvent:(FFInputEvent*)ev;
- (void)willRemoveInputEvent:(FFInputEvent*)ev;
- (void)willReplaceInputEvent:(FFInputEvent*)oldEv with:(FFInputEvent*)newEv;

// AS : Script object management
- (void)registerElement:(id)element forKey:(NSString*)key;
- (void)registerPropertyWithTarget:(id)target getter:(SEL)getter andSetter:(SEL)setter 
							forKey:(NSString*)key;
- (NSScriptObjectSpecifier*)indexSpecifierForObject:(id)obj
							   fromContainerWithKey:(id)key;

// Misc
- (NSString*)supportDirectory;

@end
