RCS_ID("$Id: NSString_Additions.m 473 2005-09-25 14:52:06Z ravemax $")

#import "NSString_Additions.h"
#import "NSArray_Additions.h"

@implementation NSString (Additions)

+ (NSString*)stringWithString:(NSString*)str times:(unsigned)times {
	return [[NSString string] stringByPaddingToLength:times*[str length] withString:str startingAtIndex:0];
}

- (NSString*)stringRelativeToPath:(NSString*)path {
	NSArray*	scomps  = [[self stringByDeletingLastPathComponent] pathComponents];
	NSArray*	pcomps  = [path pathComponents];
	NSString*   fname   = [self lastPathComponent];
	
	// Seek the point where each one goes his own way
	unsigned s, p;
	for (s = 0, p = 0; (s < [scomps count]) && (p < [pcomps count]); s++, p++) {
		if (![[scomps objectAtIndex:s] isEqualToString:[pcomps objectAtIndex:p]])
			break;
	}
	
	// Image list path is atleast at the same level
	NSString*   relPath;
	if (s == [scomps count]) {
		// Same directory
		if (p == [pcomps count])
			return fname;
		
		// Image list path is below
		relPath = [NSString stringWithString:@"../" times:([pcomps count] - p)];
		
		// Image list path is above the file path
	} else if (p == [pcomps count])
		relPath = [NSString pathWithComponents:[scomps subarrayFromIndex:s]];
	
	// Kinda complicated
	else
		relPath = [[NSString stringWithString:@"../" times:([pcomps count] - p)]
			stringByAppendingString:[NSString pathWithComponents:[scomps subarrayFromIndex:s]]];
	
	return [relPath stringByAppendingPathComponent:fname];
}

- (NSString*)absolutWithRootPath:(NSString*)path {
	return [[path stringByAppendingFormat:@"/%@", self] stringByStandardizingPath];
}

- (NSComparisonResult)caseInsensitiveAndNumericCompare:(NSString*)other {
	return [self compare:other
				 options:(NSCaseInsensitiveSearch | NSNumericSearch)];
}

@end
