// RCS_ID("$Id")

#import "FFEXIF.h"
#import <stdio.h>
#import "exif.h"
#import "jpeg.h"

static id infoHandler;

void setEXIFInfoHandler(id handler) {
	infoHandler = handler;
}

static void printprops(struct exifprop *list, unsigned short lvl, int pas)
{
	const char* n;
	#define INTBUF_SIZE 20
	char intBuf[INTBUF_SIZE]; // 19=INT64_MAX

	[infoHandler beginOfInfoType:(FFEXIFInfoType)lvl];
	
	while (list) {
		
		/* Take care of point-and-shoot values. */
		
		if (list->lvl == ED_PAS)
			list->lvl = pas ? ED_CAM : ED_IMG;
		
		/* For now, just treat overridden & bad values as verbose. */
		
		if (list->lvl == ED_OVR || list->lvl == ED_BAD)
			list->lvl = ED_VRB;
		
		if (list->lvl == lvl) {
			n = list->descr ? list->descr : list->name;
			if (list->str)
				[infoHandler handleInfoWithName:n andValue:list->str];
			else {
				snprintf(intBuf, INTBUF_SIZE, "%d", list->value);
				[infoHandler handleInfoWithName:n andValue:(const char*)intBuf];
			}
		}
		
		list = list->next;
	}
}

FFReadReturnCode readEXIF(NSString* filename) {
	FILE*				fp;
	FFReadReturnCode	retCode;
	BOOL				gotexif;
	int					mark, first;
	unsigned			len, rlen;
	unsigned char*		exifbuf;
	struct exiftags*	t;
	
	// Open the file
	fp = fopen([filename fileSystemRepresentation], "r");
	if (fp == NULL)
		return READ_RET_FILE_NOT_FOUND;
	
	// Try to read all the EXIF tags
	gotexif	= FALSE;
	first	= 0;
	exifbuf	= NULL;
	retCode	= READ_RET_OK;
	
	NS_DURING
	while (jpegscan(fp, &mark, &len, !(first++))) {
		// Not an EXIF tag
		if (mark != JPEG_M_APP1) {
			if (fseek(fp, len, SEEK_CUR)) { // Failed to skip
				retCode	= READ_JPEG_ERROR;
				break;
			}
			continue;
		}
		
		exifbuf = (unsigned char *)malloc(len);
		if (exifbuf == NULL) {
			retCode = READ_INTERNAL_ERROR;
			break;
		}

		rlen = fread(exifbuf, 1, len, fp);
		if (rlen != len) {
			retCode = READ_JPEG_ERROR; // error reading JPEG (length mismatch)
			free(exifbuf);
			break;
		}
		
		t = NULL;
		t = exifparse(exifbuf, len);
		
		if (t && t->props) {
			gotexif = TRUE;
			
			printprops(t->props, ED_CAM, TRUE); // TRUE = No removable lense
			printprops(t->props, ED_IMG, TRUE);
			printprops(t->props, ED_VRB, TRUE);
			printprops(t->props, ED_UNK, TRUE);
		}
		exiffree(t);
		free(exifbuf);
	}
	
	NS_HANDLER
//		NSLog(@"Exception : %@", [localException reason]);
		free(exifbuf);
	NS_ENDHANDLER
	
	if (!gotexif)
		retCode	= READ_RET_NO_EXIF_DATA;
		
	fclose(fp);
	return retCode;
}
