RCS_ID("$Id: FFArchiveRAR.m 541 2006-08-20 13:47:14Z ravemax $")

#import "FFArchiveRAR.h"
#import <stdio.h>
#import <string.h>
#import <unistd.h>
#import "dll.hpp"
#import "unzip.h" // for DOS time/date

typedef struct {
	FILE*		fhandle;
	FFArchive*	archive;
} RARCallbackUserData;

static int rarCallback(UINT msg, LONG UserData, LONG P1, LONG P2) {
	switch (msg) {
		case UCM_CHANGEVOLUME :
//			FFLOG(1, @"rarCallback : ChangeVol not supported")
			return -1;
			break;
		case UCM_PROCESSDATA :
			fwrite((const void*)P1, 1, (size_t)P2, ((RARCallbackUserData*)UserData)->fhandle);
			break;
		case UCM_NEEDPASSWORD : {
			const char* pwd = [((RARCallbackUserData*)UserData)->archive _getPassword];
			if ((pwd == NULL) || (strlen(pwd) >= P2))
				return -1;

			strcpy((char*)P1, pwd);
			break;
		}
	}
	return 0;
}

@implementation FFArchiveRAR

- (NSArray*)filesInArchive {
	HANDLE						handle;
	struct RAROpenArchiveData   openData;
	NSMutableArray*				files;
	struct RARHeaderData		headerData;
	int							ret;
	tm_unz						timeDate;
	
	// Open the .rar
	openData.ArcName = (char*)[[self filePath] fileSystemRepresentation];
	openData.OpenMode = RAR_OM_LIST;
	handle = RAROpenArchive(&openData);
	if (handle == NULL)
		[NSException raise:[self className]
					format:NSLocalizedString(@"Failed to open the RAR file '%@'", @"1=Filename"),
							[self filePath]];

	// Process all files
	files = [[NSMutableArray alloc] init];
	for (;;) {
		// Header
		ret = RARReadHeader(handle, &headerData);
		if (ret != 0) {
			if (ret == ERAR_END_ARCHIVE)
				ret = 0;				
			break;
		}
		
		// Add info if filesize > 0
		if (headerData.UnpSize > 0) {
			unzDosDateToTmuDate(headerData.FileTime, &timeDate);
			[files addObject:[NSDictionary dictionaryWithObjectsAndKeys:
				[NSString stringWithCString:headerData.FileName], FFFilename,
				[NSNumber numberWithUnsignedInt:headerData.PackSize], FFCompressedFileSize,
				[NSNumber numberWithUnsignedInt:headerData.UnpSize], FFUncompressedFileSize,
				[NSDate dateWithString:[NSString stringWithFormat:@"%4u-%02u-%02u %02u:%02u:%u +0000",
					timeDate.tm_year, timeDate.tm_mon, timeDate.tm_mday,
					timeDate.tm_hour, timeDate.tm_min, timeDate.tm_sec]],
					FFFileCreationDate,
				// 0x04 according to "RAR version 2.02 - Technical information"
				[NSNumber numberWithBool:(BOOL)(headerData.Flags >> 2 & 1)], FFEncrypted,
				nil]];
		}
		
		// Skip the data
		ret = RARProcessFile(handle, RAR_SKIP, NULL, NULL);
		if (ret != 0)
			break;
	}
	RARCloseArchive(handle);

	// A error occured during the processing
	if (ret != 0) {
		[files release];
		[NSException raise:[self className]
					format:NSLocalizedString(@"Corrupt RAR or internal problems", @"<no arguments>")];
	}
	
	return [files autorelease];
}

- (void)extractFile:(NSString*)filename toFilePath:(NSString*)toPath {
	HANDLE						handle;
	struct RAROpenArchiveData   openData;
	FILE*						fh;
	int							ret;
	struct RARHeaderData		headerData;
	const char*					fnc;
	RARCallbackUserData			cbUserData;
	
	// (Re)Open the RAR in extract mode
	openData.ArcName = (char*)[[self filePath] fileSystemRepresentation];
	openData.OpenMode = RAR_OM_EXTRACT;
	handle = RAROpenArchive(&openData);
	if (handle == NULL)
		[NSException raise:[self className]
					format:NSLocalizedString(@"Failed to reopen the RAR file '%@'", @"1=RAR filename"),
							[self filePath]];
	
	// Create the file and set the callback
	fh = fopen([toPath fileSystemRepresentation], "w");
	if (fh == NULL) {
		RARCloseArchive(handle);
		[NSException raise:[self className]
					format:NSLocalizedString(@"Failed to create the temp file '%@'", @"1=Dest. path"),
							toPath];
	}
	
	cbUserData.fhandle	= fh;
	cbUserData.archive	= self;
	RARSetCallback(handle, rarCallback, (LONG)&cbUserData);
	
	// Skip til the file is reached
	fnc = [filename cString];
	for (;;) {
		ret = RARReadHeader(handle, &headerData);
		if (ret != 0)
			break;
		
		// File reached ?
		if (!strcmp(headerData.FileName, fnc))
			break;
		
		// Skip the file
		ret = RARProcessFile(handle, RAR_SKIP, NULL, NULL);
		if (ret != 0)
			break;
	}
	
	// Skipping successfull
	if (ret == 0)
		ret = RARProcessFile(handle, RAR_EXTRACT, NULL, NULL);

	RARCloseArchive(handle);
	fclose(fh);
	
	// Something went wrong
	if (ret != 0) {
		unlink(fnc);
		[NSException raise:[self className]
					format:NSLocalizedString(@"An error occurred during decompression", @"<no arguments")];		
	}
}

@end
