RCS_ID("$Id: FFArchive.m 541 2006-08-20 13:47:14Z ravemax $")

#import "FFArchive.h"
#import "FFArchiveRAR.h"
#import "FFArchiveZIP.h"
#import <fcntl.h>
#import <unistd.h>

@implementation FFArchive

NSString*	FFFilename				= @"ff_filename";
NSString*	FFCompressedFileSize	= @"ff_compressed_file_size";
NSString*	FFUncompressedFileSize	= nil;
NSString*	FFFileCreationDate		= nil; // No timezone so it varies
NSString*	FFEncrypted				= @"ff_encrypted";

static id<FFArchiveHelper> helper = nil; // weak

+ (void)setHelper:(id<FFArchiveHelper>)hlp; {
	helper = hlp;
}

+ (void)initialize {
	FFUncompressedFileSize	= NSFileSize;
	FFFileCreationDate		= NSFileCreationDate;
}

+ (id)archiveWithFile:(NSString*)filePath fallbackEncoding:(NSStringEncoding)enc {
	// ZIP, RAR or nothing of both
	#ifdef __LITTLE_ENDIAN__
		const unsigned long	MAGIC_ZIP = 0x04034B50; // "..KP"
		const unsigned long MAGIC_RAR = 0x21726152; // !raR
	#else
		const unsigned long	MAGIC_ZIP = 0x504B0304; // "PK.."
		const unsigned long MAGIC_RAR = 0x52617221; // "Rar!"
	#endif
	
	unsigned long	magic;
	FFArchive*		arch = nil;
	
	int fd = open([filePath fileSystemRepresentation], O_RDONLY, 0);
	if (fd == -1)
		return nil;
		
	if (read(fd, &magic, 4) == 4) {
		if (magic == MAGIC_RAR)
			arch = [FFArchiveRAR alloc];
		else if (magic == MAGIC_ZIP)
			arch = [FFArchiveZIP alloc];
				
		if (arch != nil)
			[arch initWithFile:filePath fallbackEncoding:enc];
	}
	close(fd);
	
	return arch;
}

- (id)initWithFile:(NSString*)filePath fallbackEncoding:(NSStringEncoding)enc {
	if ([super init]) {
		m_filePath	= [filePath retain];
		m_encoding	= enc;
		m_password	= nil;
	}
	return self;
}

- (void)dealloc {
	[m_filePath release];
	if (m_password != nil)
		[m_password release];
	[super dealloc];
}

- (NSString*)filePath {
	return m_filePath;
}

- (NSArray*)filesInArchive {
	return [NSArray array];
}

- (void)extractFile:(NSString*)filename toFilePath:(NSString*)toPath {
	[NSException raise:[self className] format:@"FFArchive:extractFile should never be called!"];
}

#pragma mark -
#pragma mark Internal, shared methods

- (const char*)_getPassword {
	if (m_password == nil) {
		if (helper == nil)
			return NULL;
	
		m_password = [[helper getPasswordForFilename:[m_filePath lastPathComponent]] retain];
	}
	return [m_password UTF8String];
}

@end
