/*
 * Decompiled with CFR 0.152.
 */
package uru;

import auto.AllGames;
import auto.Game;
import java.util.Arrays;
import java.util.Vector;
import org.bouncycastle.crypto.engines.AESEngine;
import org.bouncycastle.crypto.params.KeyParameter;
import shared.Bytes;
import shared.FileUtils;
import shared.Format;
import shared.State.AllStates;
import shared.b;
import shared.m;
import shared.uncaughtexception;
import uru.UruFileTypes;

public class UruCrypt {
    private static byte[] whatdoyouseeHeader = new byte[]{119, 104, 97, 116, 100, 111, 121, 111, 117, 115, 101, 101};
    private static byte[] notthedroidsHeader = new byte[]{110, 111, 116, 116, 104, 101, 100, 114, 111, 105, 100, 115};
    private static byte[] eoaHeader = new byte[]{-120, 66, -121, 13};
    private static byte[] briceissmartHeader = new byte[]{66, 114, 105, 99, 101, 73, 115, 83, 109, 97, 114, 116};
    private static final int[] notthedroidsKey = new int[]{-1709755347, -468989930, 2066675293, -1432529607};
    private static final int[] notthedroidsKeyMqo = new int[]{213129576, -1008498746, 250355160, 1181519064};

    public static byte[] DecryptAny(String filename, AllGames.GameInfo game) {
        byte[] encdata = FileUtils.ReadFile(filename);
        return UruCrypt.DecryptAny(encdata, game);
    }

    public static byte[] DecryptAny(byte[] encdata, AllGames.GameInfo game) {
        UruFileTypes type = UruCrypt.DetectType(encdata, game);
        return UruCrypt.DecryptAny(encdata, type);
    }

    public static byte[] EncryptAny(byte[] unencdata, Format format) {
        if (format == Format.pots) {
            return UruCrypt.EncryptWhatdoyousee(unencdata);
        }
        throw new uncaughtexception("unimplemented");
    }

    public static byte[] DecryptAny(byte[] encdata, Format format) {
        if (format == Format.pots) {
            return UruCrypt.DecryptWhatdoyousee(encdata);
        }
        throw new uncaughtexception("unimplemented");
    }

    public static byte[] DecryptAny(byte[] encdata, UruFileTypes type) {
        switch (type) {
            case whatdoyousee: {
                return UruCrypt.DecryptWhatdoyousee(encdata);
            }
            case notthedroids: {
                return UruCrypt.DecryptNotthedroids(encdata, false);
            }
            case notthedroids_mqo: {
                return UruCrypt.DecryptNotthedroids(encdata, true);
            }
            case eoaenc: {
                return UruCrypt.DecryptEoa(encdata);
            }
            case unencrypted: {
                return encdata;
            }
            case unknown: {
                m.msg("Unknown encryption type; assuming it is unencrypted.");
                return encdata;
            }
        }
        throw new uncaughtexception("unexpected");
    }

    public static UruFileTypes DetectType(byte[] encdata, AllGames.GameInfo game) {
        if (b.startswith(encdata, whatdoyouseeHeader)) {
            return UruFileTypes.whatdoyousee;
        }
        if (b.startswith(encdata, notthedroidsHeader)) {
            if (game.game == Game.mqo) {
                return UruFileTypes.notthedroids_mqo;
            }
            return UruFileTypes.notthedroids;
        }
        if (b.startswith(encdata, eoaHeader)) {
            return UruFileTypes.eoaenc;
        }
        return UruFileTypes.unencrypted;
    }

    public static UruFileTypes DetectType(String filename) {
        String filestring = FileUtils.ReadFileAsString(filename);
        if (filestring.startsWith(new String(whatdoyouseeHeader))) {
            return UruFileTypes.whatdoyousee;
        }
        if (filestring.startsWith(new String(notthedroidsHeader))) {
            return UruFileTypes.notthedroids;
        }
        if (filestring.startsWith(new String(eoaHeader))) {
            return UruFileTypes.eoaenc;
        }
        if (filestring.startsWith(new String(briceissmartHeader))) {
            m.warn("briceissmart encountered(it needs to be implemented):", filename);
            return UruFileTypes.briceissmart;
        }
        return UruFileTypes.unknown;
    }

    public static byte[] EncryptElf(byte[] input) {
        Vector<Vector> lines = new Vector<Vector>();
        Vector curline = new Vector();
        for (int i = 0; i < input.length; ++i) {
            if (input[i] == 10) {
                lines.add(curline);
                curline = new Vector();
                continue;
            }
            if (input[i] == 13) continue;
            curline.add(input[i]);
        }
        if (curline.size() != 0) {
            lines.add(curline);
        }
        Vector<Byte> results = new Vector<Byte>();
        int file_pos = 0;
        for (int i = 0; i < lines.size(); ++i) {
            int j;
            curline = (Vector)lines.get(i);
            int seg_size = curline.size();
            byte key = (byte)(file_pos & 0xFF);
            int seg_head32 = seg_size ^ b.ByteToInt32(key);
            short seg_head = (short)seg_head32;
            byte[] seg_head_bytes = b.Int16ToBytes(seg_head);
            results.add(seg_head_bytes[0]);
            results.add(seg_head_bytes[1]);
            byte[] inblock = new byte[seg_size];
            byte[] outblock = new byte[seg_size];
            for (j = 0; j < seg_size; ++j) {
                inblock[j] = (Byte)curline.get(j);
            }
            UruCrypt.EncryptElfBlock(inblock, outblock, key);
            for (j = 0; j < seg_size; ++j) {
                results.add(outblock[j]);
            }
            file_pos += 2 + seg_size;
        }
        Byte[] results2 = new Byte[results.size()];
        results.toArray(results2);
        byte[] result = new byte[results.size()];
        for (int i = 0; i < result.length; ++i) {
            result[i] = results2[i];
        }
        return result;
    }

    public static void EncryptElfBlock(byte[] v, byte[] encoded, byte key) {
        int len = v.length;
        byte c = v[len - 1];
        c = b.and(c, 252);
        c = b.shl(c, 3);
        for (int i = 0; i < len; ++i) {
            byte d;
            byte a = d = v[i];
            a = b.shl(a, 6);
            d = b.shr(d, 2);
            d = a = b.or(a, d);
            a = b.shr(a, 3);
            a = b.or(a, c);
            c = key;
            a = b.or(a, c);
            d = b.shl(d, 5);
            encoded[i] = a;
            c = d;
        }
    }

    public static byte[] DecryptElf(byte[] input) {
        byte key;
        int seg_head;
        int seg_size;
        Vector<Byte> results = new Vector<Byte>();
        int file_pos = 0;
        int length = input.length;
        int i = 0;
        while (file_pos + 2 <= length && (file_pos += 2) + (seg_size = (seg_head = b.Int16ToInt32(b.BytesToInt16(input, file_pos))) ^ b.ByteToInt32(key = (byte)(file_pos & 0xFF))) <= length) {
            byte[] block = Arrays.copyOfRange(input, file_pos, file_pos + seg_size);
            file_pos += seg_size;
            byte[] outblock = new byte[block.length];
            UruCrypt.DecryptElfBlock(block, outblock, key);
            for (int j = 0; j < outblock.length; ++j) {
                results.add(outblock[j]);
            }
            results.add((byte)10);
            ++i;
        }
        Byte[] results2 = new Byte[results.size()];
        results.toArray(results2);
        byte[] result = new byte[results.size()];
        for (int i2 = 0; i2 < result.length; ++i2) {
            result[i2] = results2[i2];
        }
        return result;
    }

    public static void DecryptElfBlock(byte[] v, byte[] unencoded, byte key) {
        int length = v.length;
        byte d = v[0];
        d = b.xor(d, key);
        d = b.shr(d, 5);
        for (int i = length - 1; i >= 0; --i) {
            byte a = v[i];
            byte c = a = b.or(a, key);
            a = b.shl(a, 3);
            d = a = b.or(a, d);
            d = b.shr(d, 6);
            a = b.shl(a, 2);
            d = b.or(d, a);
            c = b.shr(c, 5);
            unencoded[i] = d;
            d = c;
        }
    }

    public static byte[] EncryptWhatdoyousee(byte[] data) {
        int blockLength = 8;
        int prefixSize = 16;
        int length = data.length;
        int numblocks = length / blockLength;
        if (numblocks * blockLength < length) {
            ++numblocks;
        }
        byte[] result = new byte[numblocks * blockLength + prefixSize];
        b.CopyBytes(whatdoyouseeHeader, result, 0);
        byte[] l = b.Int32ToBytes(length);
        b.CopyBytes(l, result, 12);
        byte[] encodedblock = new byte[blockLength];
        byte[] unencodedblock = new byte[blockLength];
        for (int i = 0; i < length; i += blockLength) {
            int remainingbytes = length - i;
            if (remainingbytes > blockLength) {
                remainingbytes = blockLength;
            }
            b.CopyBytes(data, i, unencodedblock, 0, remainingbytes);
            for (int j = remainingbytes; j < blockLength; ++j) {
                unencodedblock[j] = 0;
            }
            UruCrypt.EncryptWhatdoyouseeBlock(unencodedblock, encodedblock);
            b.CopyBytes(encodedblock, result, prefixSize + i);
        }
        return result;
    }

    public static Bytes EncryptWhatdoyousee(Bytes data) {
        return new Bytes(UruCrypt.EncryptWhatdoyousee(data.getByteArray()));
    }

    private static void EncryptWhatdoyouseeBlock(byte[] unencodedblock, byte[] encodedblock) {
        int[] k = new int[]{1812616274, 58883343, 974588818, 383483842};
        int v0 = b.BytesToInt32(unencodedblock, 0);
        int v1 = b.BytesToInt32(unencodedblock, 4);
        int sum = 0;
        int delta = -1640531527;
        for (int i = 0; i < 32; ++i) {
            v1 += ((v0 += (v1 << 4 ^ v1 >>> 5) + v1 ^ sum + k[sum & 3]) << 4 ^ v0 >>> 5) + v0 ^ (sum += delta) + k[sum >>> 11 & 3];
        }
        b.loadInt32IntoBytes(v0, encodedblock, 0);
        b.loadInt32IntoBytes(v1, encodedblock, 4);
    }

    public static byte[] EncryptEoa(byte[] data) {
        byte[] key = new byte[]{-16, 77, 37, 51, -84, 93, 39, 90, -98, 24, 120, 62, 101, 44, 72, 8};
        int length = data.length;
        int numblocks = length / 16;
        if (numblocks * 16 < length) {
            ++numblocks;
        }
        byte[] result = new byte[numblocks * 16 + 4 + 4];
        b.CopyBytes(eoaHeader, result, 0);
        byte[] l = b.Int32ToBytes(length);
        b.CopyBytes(l, result, 4);
        byte[] encodedblock = new byte[16];
        byte[] unencodedblock = new byte[16];
        AESEngine aes = new AESEngine();
        aes.init(true, new KeyParameter(key));
        for (int i = 0; i < length; i += 16) {
            int remainingbytes = length - i;
            if (remainingbytes > 16) {
                remainingbytes = 16;
            }
            b.CopyBytes(data, i, unencodedblock, 0, remainingbytes);
            for (int j = remainingbytes; j < 16; ++j) {
                unencodedblock[j] = 0;
            }
            aes.processBlock(unencodedblock, 0, encodedblock, 0);
            b.CopyBytes(encodedblock, result, 8 + i);
        }
        return result;
    }

    public static byte[] DecryptEoa(byte[] encryptedData) {
        byte[] key = new byte[]{-16, 77, 37, 51, -84, 93, 39, 90, -98, 24, 120, 62, 101, 44, 72, 8};
        byte[] header = Arrays.copyOfRange(encryptedData, 0, 4);
        byte[] lbytes = Arrays.copyOfRange(encryptedData, 4, 8);
        int length = b.BytesToInt32(lbytes, 0);
        byte[] result = new byte[length];
        KeyParameter keyparam = new KeyParameter(key);
        AESEngine aes = new AESEngine();
        aes.init(false, keyparam);
        byte[] decrypted = new byte[16];
        for (int i = 0; i < length; i += 16) {
            aes.processBlock(encryptedData, i + 8, decrypted, 0);
            int remaining = length - i;
            if (remaining > 16) {
                remaining = 16;
            }
            b.CopyBytes(decrypted, 0, result, i, remaining);
        }
        return result;
    }

    public static Bytes DecryptEoa(Bytes encryptedData) {
        return new Bytes(UruCrypt.DecryptEoa(encryptedData.getByteArray()));
    }

    public static byte[] DecryptEoastring(byte[] eoastring) {
        byte[] key = new byte[]{109, 121, 115, 116, 110, 101, 114, 100};
        int len = b.BytesToInt16(eoastring, 0);
        byte[] result = new byte[len];
        for (int i = 0; i < len; ++i) {
            result[i] = (byte)(eoastring[i + 2] ^ key[i % 8]);
        }
        return result;
    }

    public static byte[] EncryptEoastring(byte[] string) {
        byte[] key = new byte[]{109, 121, 115, 116, 110, 101, 114, 100};
        int len = string.length;
        byte[] result = new byte[len + 2];
        byte[] lenbytes = b.Int16ToBytes((short)len);
        b.CopyBytes(lenbytes, result, 0);
        for (int i = 0; i < len; ++i) {
            result[i + 2] = (byte)(string[i] ^ key[i % 8]);
        }
        return result;
    }

    public static byte[] EncryptNotthedroids(byte[] unencrypted) {
        return UruCrypt.EncryptNotthedroids(unencrypted, notthedroidsKey);
    }

    public static byte[] EncryptNotthedroids(byte[] unencrypted, int[] key) {
        int length = unencrypted.length;
        int numblocks = length / 8;
        if (numblocks * 8 < length) {
            ++numblocks;
        }
        byte[] result = new byte[numblocks * 8 + 12 + 4];
        b.CopyBytes(notthedroidsHeader, result, 0);
        byte[] l = b.Int32ToBytes(length);
        b.CopyBytes(l, result, 12);
        byte[] encodedblock = new byte[8];
        byte[] unencodedblock = new byte[8];
        for (int i = 0; i < length; i += 8) {
            int remainingbytes = length - i;
            if (remainingbytes > 8) {
                remainingbytes = 8;
            }
            b.CopyBytes(unencrypted, i, unencodedblock, 0, remainingbytes);
            for (int j = remainingbytes; j < 8; ++j) {
                unencodedblock[j] = 0;
            }
            UruCrypt.EncryptNotthedroidsBlock(unencodedblock, encodedblock, key);
            b.CopyBytes(encodedblock, result, 16 + i);
        }
        return result;
    }

    public static void EncryptNotthedroidsBlock(byte[] unencodedblock, byte[] encodedblock, int[] k) {
        int v0 = b.BytesToInt32(unencodedblock, 0);
        int v1 = b.BytesToInt32(unencodedblock, 4);
        int sum = 0;
        int DELTA = -1640531527;
        int y = v0;
        int z = v1;
        int q = 32;
        while (q-- > 0) {
            int e2 = (sum += DELTA) >>> 2 & 3;
            int p = 0;
            y = v1;
            z = v0 += (v1 >>> 5 ^ y << 2) + (y >>> 3 ^ v1 << 4) ^ (sum ^ y) + (k[p & 3 ^ e2] ^ v1);
            p = 1;
            y = v0;
            z = v1 += (v0 >>> 5 ^ y << 2) + (y >>> 3 ^ v0 << 4) ^ (sum ^ y) + (k[p & 3 ^ e2] ^ v0);
        }
        b.loadInt32IntoBytes(v0, encodedblock, 0);
        b.loadInt32IntoBytes(v1, encodedblock, 4);
    }

    public static byte[] DecryptNotthedroids(byte[] filecontents) {
        return UruCrypt.DecryptNotthedroids(filecontents, false);
    }

    public static byte[] DecryptNotthedroids(byte[] filecontents, boolean isMqo) {
        int[] key = isMqo ? notthedroidsKeyMqo : notthedroidsKey;
        return UruCrypt.DecryptNotthedroids(filecontents, key);
    }

    public static byte[] DecryptNotthedroids(byte[] filecontents, int[] key) {
        int filelength = filecontents.length;
        byte[] header = Arrays.copyOfRange(filecontents, 0, 12);
        byte[] lbytes = Arrays.copyOfRange(filecontents, 12, 16);
        int innerlength = b.BytesToInt32(lbytes, 0);
        if (AllStates.getStateAsBoolean("reportDecryption")) {
            m.msg("decrypting notthedroids...");
            m.msg("header:", new String(header));
            m.msg("payload length:", Integer.toString(innerlength));
        }
        byte[] result = new byte[innerlength];
        byte[] decodedBlock = new byte[8];
        for (int i = 0; i < innerlength; i += 8) {
            UruCrypt.DecodeNotthedroidsBlock(filecontents, decodedBlock, i + 16, 0, key);
            int remainingbytes = innerlength - i;
            if (remainingbytes > 8) {
                remainingbytes = 8;
            }
            for (int j = 0; j < remainingbytes; ++j) {
                result[i + j] = decodedBlock[j];
            }
        }
        return result;
    }

    public static byte[] DecryptWhatdoyousee(byte[] filecontents) {
        int filelength = filecontents.length;
        byte[] header = Arrays.copyOfRange(filecontents, 0, 12);
        byte[] lbytes = Arrays.copyOfRange(filecontents, 12, 16);
        int innerlength = b.BytesToInt32(lbytes, 0);
        if (AllStates.getStateAsBoolean("reportDecryption")) {
            m.msg("decrypting whatdoyousee...");
            m.msg("header:", new String(header));
            m.msg("payload length:", Integer.toString(innerlength));
        }
        byte[] result = new byte[innerlength];
        byte[] decodedBlock = new byte[8];
        for (int i = 0; i < innerlength; i += 8) {
            UruCrypt.DecodeWhatdoyouseeBlock(filecontents, decodedBlock, i + 16, 0);
            int remainingbytes = innerlength - i;
            if (remainingbytes > 8) {
                remainingbytes = 8;
            }
            for (int j = 0; j < remainingbytes; ++j) {
                result[i + j] = decodedBlock[j];
            }
        }
        return result;
    }

    private static void DecodeNotthedroidsBlock(byte[] input, byte[] output, int inputpos, int outputpos, int[] key) {
        int v0 = b.BytesToInt32(input, inputpos);
        int v1 = b.BytesToInt32(input, inputpos + 4);
        int y = v0;
        int DELTA = -1640531527;
        for (int sum = 32 * DELTA; sum != 0; sum -= DELTA) {
            int e2 = sum >>> 2 & 3;
            int p = 1;
            v1 = y = v1 - ((v0 >>> 5 ^ y << 2) + (y >>> 3 ^ v0 << 4) ^ (sum ^ y) + (key[p & 3 ^ e2] ^ v0));
            p = 0;
            v0 = y = v0 - ((v1 >>> 5 ^ y << 2) + (y >>> 3 ^ v1 << 4) ^ (sum ^ y) + (key[p & 3 ^ e2] ^ v1));
        }
        b.loadInt32IntoBytes(v0, output, outputpos);
        b.loadInt32IntoBytes(v1, output, outputpos + 4);
    }

    private static void DecodeWhatdoyouseeBlock(byte[] input, byte[] output, int inputpos, int outputpos) {
        int num_rounds = 32;
        int[] k = new int[]{1812616274, 58883343, 974588818, 383483842};
        int v0 = b.BytesToInt32(input, inputpos);
        int v1 = b.BytesToInt32(input, inputpos + 4);
        int delta = -1640531527;
        int sum = delta * num_rounds;
        for (int i = 0; i < num_rounds; ++i) {
            v0 -= ((v1 -= (v0 << 4 ^ v0 >>> 5) + v0 ^ sum + k[sum >>> 11 & 3]) << 4 ^ v1 >>> 5) + v1 ^ (sum -= delta) + k[sum & 3];
        }
        b.loadInt32IntoBytes(v0, output, outputpos);
        b.loadInt32IntoBytes(v1, output, outputpos + 4);
    }

    public static void EncryptUruMessageInPlace(byte[] string) {
        byte[] result = new byte[string.length];
        for (int i = 0; i < string.length; ++i) {
            int k = i % 8;
            int j = b.ByteToInt32(string[i]) << k;
            int l = b.ByteToInt32(string[i]) >>> 8 - k;
            string[i] = (byte)(j | l);
        }
    }

    public static void DecryptUruMessageInPlace(byte[] string) {
        byte[] result = new byte[string.length];
        for (int i = 0; i < string.length; ++i) {
            int k = i % 8;
            int j = b.ByteToInt32(string[i]) >>> k;
            int l = b.ByteToInt32(string[i]) << 8 - k;
            string[i] = (byte)(j | l);
        }
    }

    public static byte[] EncryptUrustring(byte[] string) {
        int actuallength = string.length;
        byte[] result = new byte[actuallength + 2];
        short startint = (short)(0xF000 | actuallength);
        byte[] startbytes = b.Int16ToBytes(startint);
        b.CopyBytes(startbytes, result, 0);
        for (int i = 0; i < actuallength; ++i) {
            result[i + 2] = ~string[i];
        }
        return result;
    }

    public static byte[] DecryptUrustring(byte[] urustring) {
        short lengthbytes = b.BytesToInt16(urustring, 0);
        int startpos = (lengthbytes & 0xF000) == 0 ? 4 : 2;
        int actuallength = lengthbytes & 0xFFF;
        if (actuallength > 255) {
            m.warn("urustring over 255 bytes:", new String(urustring));
        }
        byte[] result = new byte[actuallength];
        if (actuallength > 0 && (urustring[startpos] & 0x80) != 0) {
            for (int i = 0; i < actuallength; ++i) {
                result[i] = ~urustring[startpos + i];
            }
        } else {
            for (int i = 0; i < actuallength; ++i) {
                result[i] = urustring[startpos + i];
            }
        }
        return result;
    }
}

