/*
 * Decompiled with CFR 0.152.
 */
package prpobjects;

import java.io.File;
import prpobjects.PrpHeader;
import prpobjects.PrpObjectIndex;
import prpobjects.prpfile;
import shared.FileUtils;
import shared.m;
import uru.Bytestream;
import uru.context;

public class allprpfiles {
    public static void parseAllPrpfiles(PrpfileCallbackInterface callback, String prpdirname) {
        File prpfolder = new File(prpdirname);
        if (!prpfolder.isDirectory() || !prpfolder.exists()) {
            m.err("Prp directory not in proper format or not found.");
            return;
        }
        File[] files = prpfolder.listFiles();
        m.msg("Parsing files... count=", Integer.toString(files.length));
        for (int i = 0; i < files.length; ++i) {
            File curfile = files[i];
            if (!curfile.getName().toLowerCase().endsWith(".prp")) continue;
            byte[] filedata = FileUtils.ReadFile(curfile);
            context c = context.createFromBytestream(new Bytestream(filedata));
            PrpHeader header = new PrpHeader(c);
            context c2 = c.Fork(header.offsetToObjectIndex);
            PrpObjectIndex objectindex = new PrpObjectIndex(c2);
            c2.close();
            prpfile prp = new prpfile();
            prp.header = header;
            prp.objectindex = objectindex;
            callback.handlePrpfile(prp);
        }
    }

    public static void parseAllRootobjs(RootobjCallbackInterface roCallback, String prpdirname) {
        class Prpcallback
        implements PrpfileCallbackInterface {
            RootobjCallbackInterface roCallback;

            public Prpcallback(RootobjCallbackInterface callback2) {
                this.roCallback = callback2;
            }

            @Override
            public void handlePrpfile(prpfile prp) {
                int numtypes = prp.objectindex.indexCount;
                for (int i = 0; i < numtypes; ++i) {
                    int numobjects = prp.objectindex.types[i].objectcount;
                    for (int j = 0; j < numobjects; ++j) {
                        PrpObjectIndex.ObjectindexObjecttypeObjectdesc objdesc = prp.objectindex.types[i].descs[j];
                        this.roCallback.handleRootobj(prp, objdesc);
                    }
                }
            }
        }
        allprpfiles.parseAllPrpfiles(new Prpcallback(roCallback), prpdirname);
    }

    public static interface RootobjCallbackInterface {
        public void handleRootobj(prpfile var1, PrpObjectIndex.ObjectindexObjecttypeObjectdesc var2);
    }

    public static interface PrpfileCallbackInterface {
        public void handlePrpfile(prpfile var1);
    }
}

