/*
 * Decompiled with CFR 0.152.
 */
package prpobjects;

import java.io.Serializable;
import org.w3c.dom.Element;
import prpobjects.uruobj;
import shared.Bytes;
import shared.Format;
import shared.e;
import shared.m;
import uru.Bytedeque;
import uru.context;

public class Pagetype
extends uruobj
implements Serializable {
    public static final int kLocalOnly = 1;
    public static final int kVolatile = 2;
    public static final int kReserved = 4;
    public static final int kBuiltIn = 8;
    public static final int kItinerant = 16;
    short pagetype;

    public Pagetype(context c) {
        if (c.readversion == 6 || c.readversion == 3) {
            this.pagetype = c.readShort();
        } else if (c.readversion == 4 || c.readversion == 7) {
            this.pagetype = Bytes.ByteToInt16(c.readByte());
        }
        e.ensure(this.pagetype == 0 || this.pagetype == 4 || this.pagetype == 8 || this.pagetype == 16 || this.pagetype == 20);
    }

    private Pagetype() {
    }

    public static Pagetype createDefault() {
        Pagetype result = new Pagetype();
        result.pagetype = 0;
        return result;
    }

    public static Pagetype createWithType(int pagetype) {
        if (pagetype < 0 || pagetype > 20) {
            m.err("Incorrect pagetype in Pagetype.createWithType.");
        }
        Pagetype result = new Pagetype();
        result.pagetype = (short)pagetype;
        return result;
    }

    @Override
    public void compile(Bytedeque c) {
        if (c.format == Format.pots || c.format == Format.moul) {
            c.writeShort(this.pagetype);
        } else {
            m.throwUncaughtException("unimplemented");
        }
    }

    public String toString() {
        return Short.toString(this.pagetype);
    }

    public void addXml(StringBuilder s) {
        s.append(Short.toString(this.pagetype));
    }

    public static Pagetype createFromXml(Element e1) {
        int pagetype = Integer.parseInt(e1.getTextContent());
        return Pagetype.createWithType(pagetype);
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (!(o instanceof Pagetype)) {
            return false;
        }
        Pagetype o2 = (Pagetype)o;
        return this.pagetype == o2.pagetype;
    }

    public Pagetype deepClone() {
        Pagetype result = new Pagetype();
        result.pagetype = this.pagetype;
        return result;
    }
}

