/*
 * Decompiled with CFR 0.152.
 */
package SevenZip.Archive.Common;

import SevenZipCommon.CRC;
import java.io.IOException;
import java.io.OutputStream;

public class OutStreamWithCRC
extends OutputStream {
    OutputStream _stream;
    long _size;
    CRC _crc = new CRC();
    boolean _calculateCrc;

    @Override
    public void write(int b2) throws IOException {
        throw new IOException("OutStreamWithCRC - write() not implemented");
    }

    @Override
    public void write(byte[] data, int off, int size) throws IOException {
        if (this._stream != null) {
            if (size == 0) {
                throw new IOException("size = 0");
            }
            this._stream.write(data, off, size);
        }
        if (this._calculateCrc) {
            this._crc.Update(data, off, size);
        }
        this._size += (long)size;
    }

    public void SetStream(OutputStream stream) {
        this._stream = stream;
    }

    public void Init() {
        this.Init(true);
    }

    public void Init(boolean calculateCrc) {
        this._size = 0L;
        this._calculateCrc = calculateCrc;
        this._crc.Init();
    }

    public void ReleaseStream() throws IOException {
        if (this._stream != null) {
            this._stream.close();
        }
        this._stream = null;
    }

    public long GetSize() {
        return this._size;
    }

    public int GetCRC() {
        return this._crc.GetDigest();
    }

    public void InitCRC() {
        this._crc.Init();
    }
}

